/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml;

import be.re.util.Equal;
import be.re.util.Substitute;
import be.re.xml.CatalogResolver;
import be.re.xml.ExpandedName;
import be.re.xml.sax.ErrorHandler;
import com.ibm.xml.omake.Regexp;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class Util {
    private static final Equal elementSelector = new Equal(){

        public boolean equal(Object object, Object refData) {
            return object instanceof Element;
        }
    };
    private static final Equal nameSelector = new Equal(){

        public boolean equal(Object object, Object refData) {
            return ((Node)object).getNodeName().equals((String)refData);
        }
    };
    private static final Equal qnameSelector = new Equal(){

        public boolean equal(Object object, Object refData) {
            return (((ExpandedName)refData).localName == null || ((ExpandedName)refData).localName.equals(((Node)object).getLocalName())) && ((ExpandedName)refData).namespaceURI.equals(((Node)object).getNamespaceURI());
        }
    };

    private static void collectChild(Node node, List children) {
        if (node != null) {
            children.add(node);
            Util.collectChild(node.getNextSibling(), children);
        }
    }

    public static Node[] collectChildren(Node node) {
        ArrayList children = new ArrayList();
        Util.collectChild(node.getFirstChild(), children);
        return children.toArray(new Node[children.size()]);
    }

    public static Node copy(Node node, Document owner) {
        if (node == null) {
            return null;
        }
        Node result = null;
        switch (node.getNodeType()) {
            case 2: {
                result = Util.copyAttribute((Attr)node, owner);
                break;
            }
            case 4: {
                result = owner.createCDATASection(((CDATASection)node).getData());
                break;
            }
            case 8: {
                result = owner.createComment(((Comment)node).getData());
                break;
            }
            case 11: {
                result = owner.createDocumentFragment();
                break;
            }
            case 1: {
                result = Util.copyElement((Element)node, owner);
                break;
            }
            case 5: {
                result = owner.createEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                result = owner.createProcessingInstruction(((ProcessingInstruction)node).getTarget(), ((ProcessingInstruction)node).getData());
                break;
            }
            case 3: {
                result = owner.createTextNode(((Text)node).getData());
            }
        }
        if (result != null) {
            for (Node i = node.getFirstChild(); i != null; i = i.getNextSibling()) {
                result.appendChild(Util.copy(i, owner));
            }
        }
        return result;
    }

    private static Node copyAttribute(Attr attribute, Document owner) {
        Attr result = attribute.getNamespaceURI() != null ? owner.createAttributeNS(attribute.getNamespaceURI(), attribute.getName()) : owner.createAttribute(attribute.getName());
        result.setValue(attribute.getValue());
        return result;
    }

    private static Node copyElement(Element element, Document owner) {
        NamedNodeMap attributes = element.getAttributes();
        Element result = element.getNamespaceURI() != null ? owner.createElementNS(element.getNamespaceURI(), element.getTagName()) : owner.createElement(element.getTagName());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)Util.copy(attributes.item(i), owner);
            if (attribute.getNamespaceURI() != null) {
                result.setAttributeNodeNS(attribute);
                continue;
            }
            result.setAttributeNode(attribute);
        }
        return result;
    }

    public static AttributeList createAttributeList(Element element) {
        AttributeListImpl attributes = new AttributeListImpl();
        NamedNodeMap map = element.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attribute = (Attr)map.item(i);
            attributes.addAttribute(attribute.getName(), "CDATA", attribute.getValue());
        }
        return attributes;
    }

    public static void elementToDocumentHandler(Element element, DocumentHandler handler) throws SAXException {
        handler.startElement(element.getTagName(), Util.createAttributeList(element));
        Util.elementToDocumentHandlerChild(element.getFirstChild(), handler);
        handler.endElement(element.getTagName());
    }

    private static void elementToDocumentHandlerChild(Node node, DocumentHandler handler) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Util.elementToDocumentHandler((Element)node, handler);
                break;
            }
            case 7: {
                Util.processingInstructionToDocumentHandler((ProcessingInstruction)node, handler);
                break;
            }
            case 3: {
                Util.textToDocumentHandler((Text)node, handler);
            }
        }
        Util.elementToDocumentHandlerChild(node.getNextSibling(), handler);
    }

    public static String escapeText(String value) {
        return Substitute.substitute(Substitute.substitute(Substitute.substitute(Substitute.substitute(value, new Regexp("&"), "&amp;"), new Regexp("\""), "&quot;"), new Regexp(">"), "&gt;"), new Regexp("<"), "&lt;");
    }

    public static Node findAncestor(Node node, String name) {
        return node == null ? null : (node.getNodeName().equalsIgnoreCase(name) ? node : Util.findAncestor(node.getParentNode(), name));
    }

    public static Node findAncestorNotBeyond(Node node, String name, String limitingElement) {
        return node == null ? null : (node.getNodeName().equalsIgnoreCase(name) ? node : (node.getNodeName().equalsIgnoreCase(limitingElement) ? null : Util.findAncestorNotBeyond(node.getParentNode(), name, limitingElement)));
    }

    public static DocumentBuilder getDocumentBuilder(URL catalog, boolean validating) throws IOException, ParserConfigurationException {
        return Util.getDocumentBuilder(Util.newDocumentBuilderFactory(validating), catalog);
    }

    public static DocumentBuilder getDocumentBuilder(DocumentBuilderFactory factory, URL catalog) throws IOException, ParserConfigurationException {
        DocumentBuilder result = factory.newDocumentBuilder();
        result.setErrorHandler(new ErrorHandler(false));
        if (catalog != null) {
            result.setEntityResolver(new CatalogResolver(catalog));
        }
        return result;
    }

    public static Element getNextSiblingElement(Node node, String namespaceURI, String localName) {
        if (node == null) {
            return null;
        }
        return node instanceof Element && new ExpandedName(node.getNamespaceURI(), node.getLocalName()).equals(new ExpandedName(namespaceURI, localName)) ? (Element)node : Util.getNextSiblingElement(node.getNextSibling(), namespaceURI, localName);
    }

    public static Element getPreviousSiblingElement(Node node, String namespaceURI, String localName) {
        if (node == null) {
            return null;
        }
        return node instanceof Element && new ExpandedName(node.getNamespaceURI(), node.getLocalName()).equals(new ExpandedName(namespaceURI, localName)) ? (Element)node : Util.getPreviousSiblingElement(node.getPreviousSibling(), namespaceURI, localName);
    }

    public static String getText(Node node) {
        if (node == null) {
            return null;
        }
        NodeList list = node.getChildNodes();
        int position = 0;
        int size = Util.getTextSize(list);
        char[] array = new char[size];
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Text)) continue;
            char[] chars = ((Text)list.item(i)).getData().toCharArray();
            System.arraycopy(chars, 0, array, position, chars.length);
            position += chars.length;
        }
        return new String(array);
    }

    private static int getTextSize(NodeList list) {
        int result = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Text)) continue;
            result += ((Text)list.item(i)).getLength();
        }
        return result;
    }

    private static boolean isWhiteSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXml(String mimeType) {
        return "text/xml".equals(mimeType = Util.stripMimeTypeParameters(mimeType).toLowerCase()) || "application/xml".equals(mimeType) || mimeType.endsWith("+xml");
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(boolean validating) throws ParserConfigurationException {
        try {
            String className = be.re.util.Util.getSystemProperty("javax.xml.parsers.DocumentBuilderFactory");
            DocumentBuilderFactory factory = className != null ? (DocumentBuilderFactory)Class.forName(className).newInstance() : DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(validating);
            return factory;
        }
        catch (Exception e) {
            throw new ParserConfigurationException(e.getMessage());
        }
    }

    public static TransformerFactory newTransformerFactory() throws TransformerConfigurationException {
        try {
            String className = be.re.util.Util.getSystemProperty("javax.xml.transform.TransformerFactory");
            return className != null ? (TransformerFactory)Class.forName(className).newInstance() : TransformerFactory.newInstance();
        }
        catch (Exception e) {
            throw new TransformerConfigurationException(e);
        }
    }

    public static void processingInstructionToDocumentHandler(ProcessingInstruction processingInstruction, DocumentHandler handler) throws SAXException {
        handler.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
    }

    public static void removeChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getLastChild());
        }
    }

    public static void removeIgnorableSpace(Element element) {
        element.normalize();
        Util.removeIgnorableSpace(element.getFirstChild());
    }

    private static void removeIgnorableSpace(Node node) {
        if (node == null) {
            return;
        }
        Util.removeIgnorableSpace(node.getNextSibling());
        Util.removeIgnorableSpace(node.getFirstChild());
        if (node instanceof Text && Util.isWhiteSpace(((Text)node).getData())) {
            node.getParentNode().removeChild(node);
        }
    }

    private static void selectChild(Node node, Equal equal, Object refData, List children) {
        if (node != null) {
            if (equal.equal(node, refData)) {
                children.add(node);
            }
            Util.selectChild(node.getNextSibling(), equal, refData, children);
        }
    }

    private static void selectChildNotBeyond(Node node, Equal equal, Object refData, Equal equalLimit, Object refDataLimit, List children) {
        if (node != null) {
            if (equal.equal(node, refData)) {
                children.add(node);
            }
            if (!equalLimit.equal(node, refDataLimit)) {
                Util.selectChildNotBeyond(node.getNextSibling(), equal, refData, equalLimit, refDataLimit, children);
            }
        }
    }

    public static Node[] selectChildren(Node node, Equal equal, Object refData) {
        ArrayList children = new ArrayList();
        Util.selectChild(node.getFirstChild(), equal, refData, children);
        return children.toArray(new Node[children.size()]);
    }

    public static Node[] selectChildren(Node node, String name) {
        return Util.selectChildren(node, nameSelector, (Object)name);
    }

    public static Node[] selectChildren(Node node, String namespaceURI, String localName) {
        return Util.selectChildren(node, qnameSelector, new ExpandedName(namespaceURI, localName));
    }

    public static Node[] selectChildrenNotBeyond(Node node, Equal equal, Object refData, Equal equalLimit, Object refDataLimit) {
        ArrayList children = new ArrayList();
        Util.selectChildNotBeyond(node.getFirstChild(), equal, refData, equalLimit, refDataLimit, children);
        return children.toArray(new Node[children.size()]);
    }

    public static Node[] selectChildrenNotBeyond(Node node, String name, String limit) {
        return Util.selectChildrenNotBeyond(node, nameSelector, name, nameSelector, limit);
    }

    public static Element selectElement(Node node, ExpandedName[] path) {
        ArrayList result = new ArrayList();
        Util.selectElements(node, path, 0, result);
        return result.size() == 1 ? (Element)result.get(0) : null;
    }

    public static Element[] selectElements(Node node) {
        ArrayList children = new ArrayList();
        Util.selectChild(node.getFirstChild(), elementSelector, null, children);
        return children.toArray(new Element[children.size()]);
    }

    public static Element[] selectElements(Node node, ExpandedName[] path) {
        ArrayList result = new ArrayList();
        Util.selectElements(node, path, 0, result);
        return result.toArray(new Element[0]);
    }

    private static void selectElements(Node node, ExpandedName[] path, int position, List result) {
        if (position == path.length) {
            return;
        }
        Node[] children = Util.selectChildren(node, path[position].namespaceURI, path[position].localName);
        for (int i = 0; i < children.length; ++i) {
            if (position < path.length - 1) {
                Util.selectElements(children[i], path, position + 1, result);
                continue;
            }
            result.add((Element)children[i]);
        }
    }

    public static Node selectFirstChild(Node node, Equal equal, Object refData) {
        return node == null ? null : Util.selectNextSiblingSibling(node.getFirstChild(), equal, refData);
    }

    public static Node selectFirstChild(Node node, String name) {
        return Util.selectFirstChild(node, nameSelector, (Object)name);
    }

    public static Node selectFirstChild(Node node, String namespaceURI, String localName) {
        return Util.selectFirstChild(node, qnameSelector, new ExpandedName(namespaceURI, localName));
    }

    public static Node selectLastChild(Node node, Equal equal, Object refData) {
        return node == null ? null : Util.selectPreviousSiblingSibling(node.getLastChild(), equal, refData);
    }

    public static Node selectLastChild(Node node, String name) {
        return Util.selectLastChild(node, nameSelector, (Object)name);
    }

    public static Node selectLastChild(Node node, String namespaceURI, String localName) {
        return Util.selectLastChild(node, qnameSelector, new ExpandedName(namespaceURI, localName));
    }

    public static Node selectNextSibling(Node node, Equal equal, Object refData) {
        return node == null ? null : Util.selectNextSiblingSibling(node.getNextSibling(), equal, refData);
    }

    public static Node selectNextSibling(Node node, String name) {
        return Util.selectNextSibling(node, nameSelector, (Object)name);
    }

    public static Node selectNextSibling(Node node, String namespaceURI, String localName) {
        return Util.selectNextSibling(node, qnameSelector, new ExpandedName(namespaceURI, localName));
    }

    private static Node selectNextSiblingSibling(Node node, Equal equal, Object refData) {
        return node == null ? null : (equal.equal(node, refData) ? node : Util.selectNextSiblingSibling(node.getNextSibling(), equal, refData));
    }

    public static Node selectPreviousSibling(Node node, Equal equal, Object refData) {
        return node == null ? null : Util.selectPreviousSiblingSibling(node.getPreviousSibling(), equal, refData);
    }

    public static Node selectPreviousSibling(Node node, String name) {
        return Util.selectPreviousSibling(node, nameSelector, (Object)name);
    }

    public static Node selectPreviousSibling(Node node, String namespaceURI, String localName) {
        return Util.selectPreviousSibling(node, qnameSelector, new ExpandedName(namespaceURI, localName));
    }

    private static Node selectPreviousSiblingSibling(Node node, Equal equal, Object refData) {
        return node == null ? null : (equal.equal(node, refData) ? node : Util.selectPreviousSiblingSibling(node.getPreviousSibling(), equal, refData));
    }

    public static void setTransformerParameters(Transformer transformer, Map parameters) {
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            transformer.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static String stripMimeTypeParameters(String mimeType) {
        int index = mimeType.indexOf(59);
        return index != -1 ? mimeType.substring(0, index) : mimeType;
    }

    public static void textToDocumentHandler(Text text, DocumentHandler handler) throws SAXException {
        String data = text.getData();
        char[] chars = new char[data.length()];
        data.getChars(0, chars.length, chars, 0);
        handler.characters(chars, 0, chars.length);
    }
}

