/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import be.re.css.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class LinkFilter
extends XMLFilterImpl {
    private static final int EXTERNAL_LINK = 0;
    private static final int INTERNAL_LINK = 1;
    private static final int NO_LINK = 2;
    private URL baseUrl;
    private Stack elements = new Stack();

    LinkFilter(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    LinkFilter(URL baseUrl, XMLReader parent) {
        super(parent);
        this.baseUrl = baseUrl;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        int linkType = ((Element)this.elements.pop()).linkType;
        if (linkType != 2) {
            String name = linkType == 1 ? "internal-link" : "external-link";
            super.endElement(Constants.CSS, name, "css:" + name);
        }
    }

    private void handleBaseUrl(Attributes atts) throws SAXException {
        String base = atts.getValue("xml:base");
        try {
            ((Element)this.elements.peek()).baseUrl = base != null ? new URL(base) : (this.elements.size() == 1 ? this.baseUrl : ((Element)this.elements.get(this.elements.size() - 2)).baseUrl);
        }
        catch (MalformedURLException e) {
            throw new SAXException(e);
        }
    }

    private static boolean isUrl(URL baseUrl, String target) {
        try {
            new URL(baseUrl != null ? baseUrl : new URL("file:///nowhere"), target);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static Attributes resolveAnchor(Attributes atts) {
        if (atts.getIndex(Constants.CSS, "anchor") == -1) {
            return atts;
        }
        AttributesImpl result = new AttributesImpl(atts);
        int index = result.getIndex(Constants.CSS, "anchor");
        if (result.getValue(index).equalsIgnoreCase("none")) {
            result.removeAttribute(index);
        } else {
            result.setValue(index, Util.getIndirectValue(result, "anchor"));
        }
        return result;
    }

    void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element = new Element();
        this.elements.push(element);
        this.handleBaseUrl(atts);
        String link = atts.getValue(Constants.CSS, "link");
        if (link != null) {
            String target = Util.getIndirectValue(atts, "link");
            String type = Util.getIndirectType(atts, "link");
            atts = new AttributesImpl(atts);
            ((AttributesImpl)atts).removeAttribute(atts.getIndex(Constants.CSS, "link"));
            if (!link.equalsIgnoreCase("none") && target != null) {
                AttributesImpl linkAtts = new AttributesImpl();
                element.linkType = target.startsWith("#") || "IDREF".equals(type) ? 1 : (LinkFilter.isUrl(element.baseUrl, target) ? 0 : 2);
                if (element.linkType != 2) {
                    try {
                        String name;
                        String string = name = element.linkType == 1 ? "internal-link" : "external-link";
                        linkAtts.addAttribute("", "target", "target", "CDATA", element.linkType == 1 ? target.substring(target.startsWith("#") ? 1 : 0) : (element.baseUrl != null ? new URL(element.baseUrl, target).toString() : target));
                        super.startElement(Constants.CSS, name, "css:" + name, linkAtts);
                    }
                    catch (MalformedURLException e) {
                        throw new SAXException(e);
                    }
                }
            } else {
                element.linkType = 2;
            }
        } else {
            element.linkType = 2;
        }
        super.startElement(namespaceURI, localName, qName, LinkFilter.resolveAnchor(atts));
    }

    private static class Element {
        private URL baseUrl;
        private int linkType;

        private Element() {
        }
    }
}

