# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class SisImportData(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, import_type=None, supplied_batches=None, counts=None):
        """
        SisImportData - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'import_type': 'str',
            'supplied_batches': 'list[str]',
            'counts': 'SisImportCounts'
        }

        self.attribute_map = {
            'import_type': 'import_type',
            'supplied_batches': 'supplied_batches',
            'counts': 'counts'
        }

        self._import_type = import_type
        self._supplied_batches = supplied_batches
        self._counts = counts

    @property
    def import_type(self):
        """
        Gets the import_type of this SisImportData.
        The type of SIS import

        :return: The import_type of this SisImportData.
        :rtype: str
        """
        return self._import_type

    @import_type.setter
    def import_type(self, import_type):
        """
        Sets the import_type of this SisImportData.
        The type of SIS import

        :param import_type: The import_type of this SisImportData.
        :type: str
        """

        self._import_type = import_type

    @property
    def supplied_batches(self):
        """
        Gets the supplied_batches of this SisImportData.
        Which file were included in the SIS import

        :return: The supplied_batches of this SisImportData.
        :rtype: list[str]
        """
        return self._supplied_batches

    @supplied_batches.setter
    def supplied_batches(self, supplied_batches):
        """
        Sets the supplied_batches of this SisImportData.
        Which file were included in the SIS import

        :param supplied_batches: The supplied_batches of this SisImportData.
        :type: list[str]
        """

        self._supplied_batches = supplied_batches

    @property
    def counts(self):
        """
        Gets the counts of this SisImportData.
        The number of rows processed for each type of import

        :return: The counts of this SisImportData.
        :rtype: SisImportCounts
        """
        return self._counts

    @counts.setter
    def counts(self, counts):
        """
        Sets the counts of this SisImportData.
        The number of rows processed for each type of import

        :param counts: The counts of this SisImportData.
        :type: SisImportCounts
        """

        self._counts = counts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
