# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class SisImport(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, created_at=None, ended_at=None, updated_at=None, workflow_state=None, data=None, progress=None, processing_warnings=None, processing_errors=None, batch_mode=None, batch_mode_term_id=None, override_sis_stickiness=None, add_sis_stickiness=None, clear_sis_stickiness=None, diffing_data_set_identifier=None, diffed_against_import_id=None):
        """
        SisImport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'created_at': 'Datetime',
            'ended_at': 'Datetime',
            'updated_at': 'Datetime',
            'workflow_state': 'str',
            'data': 'SisImportData',
            'progress': 'str',
            'processing_warnings': 'list[str]',
            'processing_errors': 'list[str]',
            'batch_mode': 'bool',
            'batch_mode_term_id': 'str',
            'override_sis_stickiness': 'bool',
            'add_sis_stickiness': 'bool',
            'clear_sis_stickiness': 'bool',
            'diffing_data_set_identifier': 'str',
            'diffed_against_import_id': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'created_at': 'created_at',
            'ended_at': 'ended_at',
            'updated_at': 'updated_at',
            'workflow_state': 'workflow_state',
            'data': 'data',
            'progress': 'progress',
            'processing_warnings': 'processing_warnings',
            'processing_errors': 'processing_errors',
            'batch_mode': 'batch_mode',
            'batch_mode_term_id': 'batch_mode_term_id',
            'override_sis_stickiness': 'override_sis_stickiness',
            'add_sis_stickiness': 'add_sis_stickiness',
            'clear_sis_stickiness': 'clear_sis_stickiness',
            'diffing_data_set_identifier': 'diffing_data_set_identifier',
            'diffed_against_import_id': 'diffed_against_import_id'
        }

        self._id = id
        self._created_at = created_at
        self._ended_at = ended_at
        self._updated_at = updated_at
        self._workflow_state = workflow_state
        self._data = data
        self._progress = progress
        self._processing_warnings = processing_warnings
        self._processing_errors = processing_errors
        self._batch_mode = batch_mode
        self._batch_mode_term_id = batch_mode_term_id
        self._override_sis_stickiness = override_sis_stickiness
        self._add_sis_stickiness = add_sis_stickiness
        self._clear_sis_stickiness = clear_sis_stickiness
        self._diffing_data_set_identifier = diffing_data_set_identifier
        self._diffed_against_import_id = diffed_against_import_id

    @property
    def id(self):
        """
        Gets the id of this SisImport.
        The unique identifier for the SIS import.

        :return: The id of this SisImport.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SisImport.
        The unique identifier for the SIS import.

        :param id: The id of this SisImport.
        :type: int
        """

        self._id = id

    @property
    def created_at(self):
        """
        Gets the created_at of this SisImport.
        The date the SIS import was created.

        :return: The created_at of this SisImport.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this SisImport.
        The date the SIS import was created.

        :param created_at: The created_at of this SisImport.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def ended_at(self):
        """
        Gets the ended_at of this SisImport.
        The date the SIS import finished. Returns null if not finished.

        :return: The ended_at of this SisImport.
        :rtype: Datetime
        """
        return self._ended_at

    @ended_at.setter
    def ended_at(self, ended_at):
        """
        Sets the ended_at of this SisImport.
        The date the SIS import finished. Returns null if not finished.

        :param ended_at: The ended_at of this SisImport.
        :type: Datetime
        """

        self._ended_at = ended_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this SisImport.
        The date the SIS import was last updated.

        :return: The updated_at of this SisImport.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this SisImport.
        The date the SIS import was last updated.

        :param updated_at: The updated_at of this SisImport.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this SisImport.
        The current state of the SIS import. - 'created': The SIS import has been created.  - 'importing': The SIS import is currently processing.  - 'imported': The SIS import has completed successfully.  - 'imported_with_messages': The SIS import completed with errors or warnings.  - 'failed_with_messages': The SIS import failed with errors.  - 'failed': The SIS import failed.

        :return: The workflow_state of this SisImport.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this SisImport.
        The current state of the SIS import. - 'created': The SIS import has been created.  - 'importing': The SIS import is currently processing.  - 'imported': The SIS import has completed successfully.  - 'imported_with_messages': The SIS import completed with errors or warnings.  - 'failed_with_messages': The SIS import failed with errors.  - 'failed': The SIS import failed.

        :param workflow_state: The workflow_state of this SisImport.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def data(self):
        """
        Gets the data of this SisImport.
        data

        :return: The data of this SisImport.
        :rtype: SisImportData
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this SisImport.
        data

        :param data: The data of this SisImport.
        :type: SisImportData
        """

        self._data = data

    @property
    def progress(self):
        """
        Gets the progress of this SisImport.
        The progress of the SIS import.

        :return: The progress of this SisImport.
        :rtype: str
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this SisImport.
        The progress of the SIS import.

        :param progress: The progress of this SisImport.
        :type: str
        """

        self._progress = progress

    @property
    def processing_warnings(self):
        """
        Gets the processing_warnings of this SisImport.
        Only imports that are complete will get this data. An array of CSV_file/warning_message pairs.

        :return: The processing_warnings of this SisImport.
        :rtype: list[str]
        """
        return self._processing_warnings

    @processing_warnings.setter
    def processing_warnings(self, processing_warnings):
        """
        Sets the processing_warnings of this SisImport.
        Only imports that are complete will get this data. An array of CSV_file/warning_message pairs.

        :param processing_warnings: The processing_warnings of this SisImport.
        :type: list[str]
        """

        self._processing_warnings = processing_warnings

    @property
    def processing_errors(self):
        """
        Gets the processing_errors of this SisImport.
        An array of CSV_file/error_message pairs.

        :return: The processing_errors of this SisImport.
        :rtype: list[str]
        """
        return self._processing_errors

    @processing_errors.setter
    def processing_errors(self, processing_errors):
        """
        Sets the processing_errors of this SisImport.
        An array of CSV_file/error_message pairs.

        :param processing_errors: The processing_errors of this SisImport.
        :type: list[str]
        """

        self._processing_errors = processing_errors

    @property
    def batch_mode(self):
        """
        Gets the batch_mode of this SisImport.
        Whether the import was run in batch mode.

        :return: The batch_mode of this SisImport.
        :rtype: bool
        """
        return self._batch_mode

    @batch_mode.setter
    def batch_mode(self, batch_mode):
        """
        Sets the batch_mode of this SisImport.
        Whether the import was run in batch mode.

        :param batch_mode: The batch_mode of this SisImport.
        :type: bool
        """

        self._batch_mode = batch_mode

    @property
    def batch_mode_term_id(self):
        """
        Gets the batch_mode_term_id of this SisImport.
        The term the batch was limited to.

        :return: The batch_mode_term_id of this SisImport.
        :rtype: str
        """
        return self._batch_mode_term_id

    @batch_mode_term_id.setter
    def batch_mode_term_id(self, batch_mode_term_id):
        """
        Sets the batch_mode_term_id of this SisImport.
        The term the batch was limited to.

        :param batch_mode_term_id: The batch_mode_term_id of this SisImport.
        :type: str
        """

        self._batch_mode_term_id = batch_mode_term_id

    @property
    def override_sis_stickiness(self):
        """
        Gets the override_sis_stickiness of this SisImport.
        Whether UI changes were overridden.

        :return: The override_sis_stickiness of this SisImport.
        :rtype: bool
        """
        return self._override_sis_stickiness

    @override_sis_stickiness.setter
    def override_sis_stickiness(self, override_sis_stickiness):
        """
        Sets the override_sis_stickiness of this SisImport.
        Whether UI changes were overridden.

        :param override_sis_stickiness: The override_sis_stickiness of this SisImport.
        :type: bool
        """

        self._override_sis_stickiness = override_sis_stickiness

    @property
    def add_sis_stickiness(self):
        """
        Gets the add_sis_stickiness of this SisImport.
        Whether stickiness was added to the batch changes.

        :return: The add_sis_stickiness of this SisImport.
        :rtype: bool
        """
        return self._add_sis_stickiness

    @add_sis_stickiness.setter
    def add_sis_stickiness(self, add_sis_stickiness):
        """
        Sets the add_sis_stickiness of this SisImport.
        Whether stickiness was added to the batch changes.

        :param add_sis_stickiness: The add_sis_stickiness of this SisImport.
        :type: bool
        """

        self._add_sis_stickiness = add_sis_stickiness

    @property
    def clear_sis_stickiness(self):
        """
        Gets the clear_sis_stickiness of this SisImport.
        Whether stickiness was cleared.

        :return: The clear_sis_stickiness of this SisImport.
        :rtype: bool
        """
        return self._clear_sis_stickiness

    @clear_sis_stickiness.setter
    def clear_sis_stickiness(self, clear_sis_stickiness):
        """
        Sets the clear_sis_stickiness of this SisImport.
        Whether stickiness was cleared.

        :param clear_sis_stickiness: The clear_sis_stickiness of this SisImport.
        :type: bool
        """

        self._clear_sis_stickiness = clear_sis_stickiness

    @property
    def diffing_data_set_identifier(self):
        """
        Gets the diffing_data_set_identifier of this SisImport.
        The identifier of the data set that this SIS batch diffs against

        :return: The diffing_data_set_identifier of this SisImport.
        :rtype: str
        """
        return self._diffing_data_set_identifier

    @diffing_data_set_identifier.setter
    def diffing_data_set_identifier(self, diffing_data_set_identifier):
        """
        Sets the diffing_data_set_identifier of this SisImport.
        The identifier of the data set that this SIS batch diffs against

        :param diffing_data_set_identifier: The diffing_data_set_identifier of this SisImport.
        :type: str
        """

        self._diffing_data_set_identifier = diffing_data_set_identifier

    @property
    def diffed_against_import_id(self):
        """
        Gets the diffed_against_import_id of this SisImport.
        The ID of the SIS Import that this import was diffed against

        :return: The diffed_against_import_id of this SisImport.
        :rtype: int
        """
        return self._diffed_against_import_id

    @diffed_against_import_id.setter
    def diffed_against_import_id(self, diffed_against_import_id):
        """
        Sets the diffed_against_import_id of this SisImport.
        The ID of the SIS Import that this import was diffed against

        :param diffed_against_import_id: The diffed_against_import_id of this SisImport.
        :type: int
        """

        self._diffed_against_import_id = diffed_against_import_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
