# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizPermissions(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, read=None, submit=None, create=None, manage=None, read_statistics=None, review_grades=None, update=None):
        """
        QuizPermissions - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'read': 'bool',
            'submit': 'bool',
            'create': 'bool',
            'manage': 'bool',
            'read_statistics': 'bool',
            'review_grades': 'bool',
            'update': 'bool'
        }

        self.attribute_map = {
            'read': 'read',
            'submit': 'submit',
            'create': 'create',
            'manage': 'manage',
            'read_statistics': 'read_statistics',
            'review_grades': 'review_grades',
            'update': 'update'
        }

        self._read = read
        self._submit = submit
        self._create = create
        self._manage = manage
        self._read_statistics = read_statistics
        self._review_grades = review_grades
        self._update = update

    @property
    def read(self):
        """
        Gets the read of this QuizPermissions.
        whether the user can view the quiz

        :return: The read of this QuizPermissions.
        :rtype: bool
        """
        return self._read

    @read.setter
    def read(self, read):
        """
        Sets the read of this QuizPermissions.
        whether the user can view the quiz

        :param read: The read of this QuizPermissions.
        :type: bool
        """

        self._read = read

    @property
    def submit(self):
        """
        Gets the submit of this QuizPermissions.
        whether the user may submit a submission for the quiz

        :return: The submit of this QuizPermissions.
        :rtype: bool
        """
        return self._submit

    @submit.setter
    def submit(self, submit):
        """
        Sets the submit of this QuizPermissions.
        whether the user may submit a submission for the quiz

        :param submit: The submit of this QuizPermissions.
        :type: bool
        """

        self._submit = submit

    @property
    def create(self):
        """
        Gets the create of this QuizPermissions.
        whether the user may create a new quiz

        :return: The create of this QuizPermissions.
        :rtype: bool
        """
        return self._create

    @create.setter
    def create(self, create):
        """
        Sets the create of this QuizPermissions.
        whether the user may create a new quiz

        :param create: The create of this QuizPermissions.
        :type: bool
        """

        self._create = create

    @property
    def manage(self):
        """
        Gets the manage of this QuizPermissions.
        whether the user may edit, update, or delete the quiz

        :return: The manage of this QuizPermissions.
        :rtype: bool
        """
        return self._manage

    @manage.setter
    def manage(self, manage):
        """
        Sets the manage of this QuizPermissions.
        whether the user may edit, update, or delete the quiz

        :param manage: The manage of this QuizPermissions.
        :type: bool
        """

        self._manage = manage

    @property
    def read_statistics(self):
        """
        Gets the read_statistics of this QuizPermissions.
        whether the user may view quiz statistics for this quiz

        :return: The read_statistics of this QuizPermissions.
        :rtype: bool
        """
        return self._read_statistics

    @read_statistics.setter
    def read_statistics(self, read_statistics):
        """
        Sets the read_statistics of this QuizPermissions.
        whether the user may view quiz statistics for this quiz

        :param read_statistics: The read_statistics of this QuizPermissions.
        :type: bool
        """

        self._read_statistics = read_statistics

    @property
    def review_grades(self):
        """
        Gets the review_grades of this QuizPermissions.
        whether the user may review grades for all quiz submissions for this quiz

        :return: The review_grades of this QuizPermissions.
        :rtype: bool
        """
        return self._review_grades

    @review_grades.setter
    def review_grades(self, review_grades):
        """
        Sets the review_grades of this QuizPermissions.
        whether the user may review grades for all quiz submissions for this quiz

        :param review_grades: The review_grades of this QuizPermissions.
        :type: bool
        """

        self._review_grades = review_grades

    @property
    def update(self):
        """
        Gets the update of this QuizPermissions.
        whether the user may update the quiz

        :return: The update of this QuizPermissions.
        :rtype: bool
        """
        return self._update

    @update.setter
    def update(self, update):
        """
        Sets the update of this QuizPermissions.
        whether the user may update the quiz

        :param update: The update of this QuizPermissions.
        :type: bool
        """

        self._update = update

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
