# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Quiz(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, title=None, html_url=None, mobile_url=None, preview_url=None, description=None, quiz_type=None, assignment_group_id=None, time_limit=None, shuffle_answers=None, hide_results=None, show_correct_answers=None, show_correct_answers_last_attempt=None, show_correct_answers_at=None, hide_correct_answers_at=None, one_time_results=None, scoring_policy=None, allowed_attempts=None, one_question_at_a_time=None, question_count=None, points_possible=None, cant_go_back=None, access_code=None, ip_filter=None, due_at=None, lock_at=None, unlock_at=None, published=None, unpublishable=None, locked_for_user=None, lock_info=None, lock_explanation=None, speedgrader_url=None, quiz_extensions_url=None, permissions=None, all_dates=None, version_number=None):
        """
        Quiz - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'title': 'str',
            'html_url': 'str',
            'mobile_url': 'str',
            'preview_url': 'str',
            'description': 'str',
            'quiz_type': 'str',
            'assignment_group_id': 'int',
            'time_limit': 'int',
            'shuffle_answers': 'bool',
            'hide_results': 'str',
            'show_correct_answers': 'bool',
            'show_correct_answers_last_attempt': 'bool',
            'show_correct_answers_at': 'Datetime',
            'hide_correct_answers_at': 'Datetime',
            'one_time_results': 'bool',
            'scoring_policy': 'str',
            'allowed_attempts': 'int',
            'one_question_at_a_time': 'bool',
            'question_count': 'int',
            'points_possible': 'int',
            'cant_go_back': 'bool',
            'access_code': 'str',
            'ip_filter': 'str',
            'due_at': 'Datetime',
            'lock_at': 'Datetime',
            'unlock_at': 'Datetime',
            'published': 'bool',
            'unpublishable': 'bool',
            'locked_for_user': 'bool',
            'lock_info': 'LockInfo',
            'lock_explanation': 'str',
            'speedgrader_url': 'str',
            'quiz_extensions_url': 'str',
            'permissions': 'QuizPermissions',
            'all_dates': 'AssignmentDate',
            'version_number': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'html_url': 'html_url',
            'mobile_url': 'mobile_url',
            'preview_url': 'preview_url',
            'description': 'description',
            'quiz_type': 'quiz_type',
            'assignment_group_id': 'assignment_group_id',
            'time_limit': 'time_limit',
            'shuffle_answers': 'shuffle_answers',
            'hide_results': 'hide_results',
            'show_correct_answers': 'show_correct_answers',
            'show_correct_answers_last_attempt': 'show_correct_answers_last_attempt',
            'show_correct_answers_at': 'show_correct_answers_at',
            'hide_correct_answers_at': 'hide_correct_answers_at',
            'one_time_results': 'one_time_results',
            'scoring_policy': 'scoring_policy',
            'allowed_attempts': 'allowed_attempts',
            'one_question_at_a_time': 'one_question_at_a_time',
            'question_count': 'question_count',
            'points_possible': 'points_possible',
            'cant_go_back': 'cant_go_back',
            'access_code': 'access_code',
            'ip_filter': 'ip_filter',
            'due_at': 'due_at',
            'lock_at': 'lock_at',
            'unlock_at': 'unlock_at',
            'published': 'published',
            'unpublishable': 'unpublishable',
            'locked_for_user': 'locked_for_user',
            'lock_info': 'lock_info',
            'lock_explanation': 'lock_explanation',
            'speedgrader_url': 'speedgrader_url',
            'quiz_extensions_url': 'quiz_extensions_url',
            'permissions': 'permissions',
            'all_dates': 'all_dates',
            'version_number': 'version_number'
        }

        self._id = id
        self._title = title
        self._html_url = html_url
        self._mobile_url = mobile_url
        self._preview_url = preview_url
        self._description = description
        self._quiz_type = quiz_type
        self._assignment_group_id = assignment_group_id
        self._time_limit = time_limit
        self._shuffle_answers = shuffle_answers
        self._hide_results = hide_results
        self._show_correct_answers = show_correct_answers
        self._show_correct_answers_last_attempt = show_correct_answers_last_attempt
        self._show_correct_answers_at = show_correct_answers_at
        self._hide_correct_answers_at = hide_correct_answers_at
        self._one_time_results = one_time_results
        self._scoring_policy = scoring_policy
        self._allowed_attempts = allowed_attempts
        self._one_question_at_a_time = one_question_at_a_time
        self._question_count = question_count
        self._points_possible = points_possible
        self._cant_go_back = cant_go_back
        self._access_code = access_code
        self._ip_filter = ip_filter
        self._due_at = due_at
        self._lock_at = lock_at
        self._unlock_at = unlock_at
        self._published = published
        self._unpublishable = unpublishable
        self._locked_for_user = locked_for_user
        self._lock_info = lock_info
        self._lock_explanation = lock_explanation
        self._speedgrader_url = speedgrader_url
        self._quiz_extensions_url = quiz_extensions_url
        self._permissions = permissions
        self._all_dates = all_dates
        self._version_number = version_number

    @property
    def id(self):
        """
        Gets the id of this Quiz.
        the ID of the quiz

        :return: The id of this Quiz.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Quiz.
        the ID of the quiz

        :param id: The id of this Quiz.
        :type: int
        """

        self._id = id

    @property
    def title(self):
        """
        Gets the title of this Quiz.
        the title of the quiz

        :return: The title of this Quiz.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Quiz.
        the title of the quiz

        :param title: The title of this Quiz.
        :type: str
        """

        self._title = title

    @property
    def html_url(self):
        """
        Gets the html_url of this Quiz.
        the HTTP/HTTPS URL to the quiz

        :return: The html_url of this Quiz.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this Quiz.
        the HTTP/HTTPS URL to the quiz

        :param html_url: The html_url of this Quiz.
        :type: str
        """

        self._html_url = html_url

    @property
    def mobile_url(self):
        """
        Gets the mobile_url of this Quiz.
        a url suitable for loading the quiz in a mobile webview.  it will persiste the headless session and, for quizzes in public courses, will force the user to login

        :return: The mobile_url of this Quiz.
        :rtype: str
        """
        return self._mobile_url

    @mobile_url.setter
    def mobile_url(self, mobile_url):
        """
        Sets the mobile_url of this Quiz.
        a url suitable for loading the quiz in a mobile webview.  it will persiste the headless session and, for quizzes in public courses, will force the user to login

        :param mobile_url: The mobile_url of this Quiz.
        :type: str
        """

        self._mobile_url = mobile_url

    @property
    def preview_url(self):
        """
        Gets the preview_url of this Quiz.
        A url that can be visited in the browser with a POST request to preview a quiz as the teacher. Only present when the user may grade

        :return: The preview_url of this Quiz.
        :rtype: str
        """
        return self._preview_url

    @preview_url.setter
    def preview_url(self, preview_url):
        """
        Sets the preview_url of this Quiz.
        A url that can be visited in the browser with a POST request to preview a quiz as the teacher. Only present when the user may grade

        :param preview_url: The preview_url of this Quiz.
        :type: str
        """

        self._preview_url = preview_url

    @property
    def description(self):
        """
        Gets the description of this Quiz.
        the description of the quiz

        :return: The description of this Quiz.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Quiz.
        the description of the quiz

        :param description: The description of this Quiz.
        :type: str
        """

        self._description = description

    @property
    def quiz_type(self):
        """
        Gets the quiz_type of this Quiz.
        type of quiz possible values: 'practice_quiz', 'assignment', 'graded_survey', 'survey'

        :return: The quiz_type of this Quiz.
        :rtype: str
        """
        return self._quiz_type

    @quiz_type.setter
    def quiz_type(self, quiz_type):
        """
        Sets the quiz_type of this Quiz.
        type of quiz possible values: 'practice_quiz', 'assignment', 'graded_survey', 'survey'

        :param quiz_type: The quiz_type of this Quiz.
        :type: str
        """

        self._quiz_type = quiz_type

    @property
    def assignment_group_id(self):
        """
        Gets the assignment_group_id of this Quiz.
        the ID of the quiz's assignment group:

        :return: The assignment_group_id of this Quiz.
        :rtype: int
        """
        return self._assignment_group_id

    @assignment_group_id.setter
    def assignment_group_id(self, assignment_group_id):
        """
        Sets the assignment_group_id of this Quiz.
        the ID of the quiz's assignment group:

        :param assignment_group_id: The assignment_group_id of this Quiz.
        :type: int
        """

        self._assignment_group_id = assignment_group_id

    @property
    def time_limit(self):
        """
        Gets the time_limit of this Quiz.
        quiz time limit in minutes

        :return: The time_limit of this Quiz.
        :rtype: int
        """
        return self._time_limit

    @time_limit.setter
    def time_limit(self, time_limit):
        """
        Sets the time_limit of this Quiz.
        quiz time limit in minutes

        :param time_limit: The time_limit of this Quiz.
        :type: int
        """

        self._time_limit = time_limit

    @property
    def shuffle_answers(self):
        """
        Gets the shuffle_answers of this Quiz.
        shuffle answers for students?

        :return: The shuffle_answers of this Quiz.
        :rtype: bool
        """
        return self._shuffle_answers

    @shuffle_answers.setter
    def shuffle_answers(self, shuffle_answers):
        """
        Sets the shuffle_answers of this Quiz.
        shuffle answers for students?

        :param shuffle_answers: The shuffle_answers of this Quiz.
        :type: bool
        """

        self._shuffle_answers = shuffle_answers

    @property
    def hide_results(self):
        """
        Gets the hide_results of this Quiz.
        let students see their quiz responses? possible values: null, 'always', 'until_after_last_attempt'

        :return: The hide_results of this Quiz.
        :rtype: str
        """
        return self._hide_results

    @hide_results.setter
    def hide_results(self, hide_results):
        """
        Sets the hide_results of this Quiz.
        let students see their quiz responses? possible values: null, 'always', 'until_after_last_attempt'

        :param hide_results: The hide_results of this Quiz.
        :type: str
        """

        self._hide_results = hide_results

    @property
    def show_correct_answers(self):
        """
        Gets the show_correct_answers of this Quiz.
        show which answers were correct when results are shown? only valid if hide_results=null

        :return: The show_correct_answers of this Quiz.
        :rtype: bool
        """
        return self._show_correct_answers

    @show_correct_answers.setter
    def show_correct_answers(self, show_correct_answers):
        """
        Sets the show_correct_answers of this Quiz.
        show which answers were correct when results are shown? only valid if hide_results=null

        :param show_correct_answers: The show_correct_answers of this Quiz.
        :type: bool
        """

        self._show_correct_answers = show_correct_answers

    @property
    def show_correct_answers_last_attempt(self):
        """
        Gets the show_correct_answers_last_attempt of this Quiz.
        restrict the show_correct_answers option above to apply only to the last submitted attempt of a quiz that allows multiple attempts. only valid if show_correct_answers=true and allowed_attempts > 1

        :return: The show_correct_answers_last_attempt of this Quiz.
        :rtype: bool
        """
        return self._show_correct_answers_last_attempt

    @show_correct_answers_last_attempt.setter
    def show_correct_answers_last_attempt(self, show_correct_answers_last_attempt):
        """
        Sets the show_correct_answers_last_attempt of this Quiz.
        restrict the show_correct_answers option above to apply only to the last submitted attempt of a quiz that allows multiple attempts. only valid if show_correct_answers=true and allowed_attempts > 1

        :param show_correct_answers_last_attempt: The show_correct_answers_last_attempt of this Quiz.
        :type: bool
        """

        self._show_correct_answers_last_attempt = show_correct_answers_last_attempt

    @property
    def show_correct_answers_at(self):
        """
        Gets the show_correct_answers_at of this Quiz.
        when should the correct answers be visible by students? only valid if show_correct_answers=true

        :return: The show_correct_answers_at of this Quiz.
        :rtype: Datetime
        """
        return self._show_correct_answers_at

    @show_correct_answers_at.setter
    def show_correct_answers_at(self, show_correct_answers_at):
        """
        Sets the show_correct_answers_at of this Quiz.
        when should the correct answers be visible by students? only valid if show_correct_answers=true

        :param show_correct_answers_at: The show_correct_answers_at of this Quiz.
        :type: Datetime
        """

        self._show_correct_answers_at = show_correct_answers_at

    @property
    def hide_correct_answers_at(self):
        """
        Gets the hide_correct_answers_at of this Quiz.
        prevent the students from seeing correct answers after the specified date has passed. only valid if show_correct_answers=true

        :return: The hide_correct_answers_at of this Quiz.
        :rtype: Datetime
        """
        return self._hide_correct_answers_at

    @hide_correct_answers_at.setter
    def hide_correct_answers_at(self, hide_correct_answers_at):
        """
        Sets the hide_correct_answers_at of this Quiz.
        prevent the students from seeing correct answers after the specified date has passed. only valid if show_correct_answers=true

        :param hide_correct_answers_at: The hide_correct_answers_at of this Quiz.
        :type: Datetime
        """

        self._hide_correct_answers_at = hide_correct_answers_at

    @property
    def one_time_results(self):
        """
        Gets the one_time_results of this Quiz.
        prevent the students from seeing their results more than once (right after they submit the quiz)

        :return: The one_time_results of this Quiz.
        :rtype: bool
        """
        return self._one_time_results

    @one_time_results.setter
    def one_time_results(self, one_time_results):
        """
        Sets the one_time_results of this Quiz.
        prevent the students from seeing their results more than once (right after they submit the quiz)

        :param one_time_results: The one_time_results of this Quiz.
        :type: bool
        """

        self._one_time_results = one_time_results

    @property
    def scoring_policy(self):
        """
        Gets the scoring_policy of this Quiz.
        which quiz score to keep (only if allowed_attempts != 1) possible values: 'keep_highest', 'keep_latest'

        :return: The scoring_policy of this Quiz.
        :rtype: str
        """
        return self._scoring_policy

    @scoring_policy.setter
    def scoring_policy(self, scoring_policy):
        """
        Sets the scoring_policy of this Quiz.
        which quiz score to keep (only if allowed_attempts != 1) possible values: 'keep_highest', 'keep_latest'

        :param scoring_policy: The scoring_policy of this Quiz.
        :type: str
        """

        self._scoring_policy = scoring_policy

    @property
    def allowed_attempts(self):
        """
        Gets the allowed_attempts of this Quiz.
        how many times a student can take the quiz -1 = unlimited attempts

        :return: The allowed_attempts of this Quiz.
        :rtype: int
        """
        return self._allowed_attempts

    @allowed_attempts.setter
    def allowed_attempts(self, allowed_attempts):
        """
        Sets the allowed_attempts of this Quiz.
        how many times a student can take the quiz -1 = unlimited attempts

        :param allowed_attempts: The allowed_attempts of this Quiz.
        :type: int
        """

        self._allowed_attempts = allowed_attempts

    @property
    def one_question_at_a_time(self):
        """
        Gets the one_question_at_a_time of this Quiz.
        show one question at a time?

        :return: The one_question_at_a_time of this Quiz.
        :rtype: bool
        """
        return self._one_question_at_a_time

    @one_question_at_a_time.setter
    def one_question_at_a_time(self, one_question_at_a_time):
        """
        Sets the one_question_at_a_time of this Quiz.
        show one question at a time?

        :param one_question_at_a_time: The one_question_at_a_time of this Quiz.
        :type: bool
        """

        self._one_question_at_a_time = one_question_at_a_time

    @property
    def question_count(self):
        """
        Gets the question_count of this Quiz.
        the number of questions in the quiz

        :return: The question_count of this Quiz.
        :rtype: int
        """
        return self._question_count

    @question_count.setter
    def question_count(self, question_count):
        """
        Sets the question_count of this Quiz.
        the number of questions in the quiz

        :param question_count: The question_count of this Quiz.
        :type: int
        """

        self._question_count = question_count

    @property
    def points_possible(self):
        """
        Gets the points_possible of this Quiz.
        The total point value given to the quiz

        :return: The points_possible of this Quiz.
        :rtype: int
        """
        return self._points_possible

    @points_possible.setter
    def points_possible(self, points_possible):
        """
        Sets the points_possible of this Quiz.
        The total point value given to the quiz

        :param points_possible: The points_possible of this Quiz.
        :type: int
        """

        self._points_possible = points_possible

    @property
    def cant_go_back(self):
        """
        Gets the cant_go_back of this Quiz.
        lock questions after answering? only valid if one_question_at_a_time=true

        :return: The cant_go_back of this Quiz.
        :rtype: bool
        """
        return self._cant_go_back

    @cant_go_back.setter
    def cant_go_back(self, cant_go_back):
        """
        Sets the cant_go_back of this Quiz.
        lock questions after answering? only valid if one_question_at_a_time=true

        :param cant_go_back: The cant_go_back of this Quiz.
        :type: bool
        """

        self._cant_go_back = cant_go_back

    @property
    def access_code(self):
        """
        Gets the access_code of this Quiz.
        access code to restrict quiz access

        :return: The access_code of this Quiz.
        :rtype: str
        """
        return self._access_code

    @access_code.setter
    def access_code(self, access_code):
        """
        Sets the access_code of this Quiz.
        access code to restrict quiz access

        :param access_code: The access_code of this Quiz.
        :type: str
        """

        self._access_code = access_code

    @property
    def ip_filter(self):
        """
        Gets the ip_filter of this Quiz.
        IP address or range that quiz access is limited to

        :return: The ip_filter of this Quiz.
        :rtype: str
        """
        return self._ip_filter

    @ip_filter.setter
    def ip_filter(self, ip_filter):
        """
        Sets the ip_filter of this Quiz.
        IP address or range that quiz access is limited to

        :param ip_filter: The ip_filter of this Quiz.
        :type: str
        """

        self._ip_filter = ip_filter

    @property
    def due_at(self):
        """
        Gets the due_at of this Quiz.
        when the quiz is due

        :return: The due_at of this Quiz.
        :rtype: Datetime
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """
        Sets the due_at of this Quiz.
        when the quiz is due

        :param due_at: The due_at of this Quiz.
        :type: Datetime
        """

        self._due_at = due_at

    @property
    def lock_at(self):
        """
        Gets the lock_at of this Quiz.
        when to lock the quiz

        :return: The lock_at of this Quiz.
        :rtype: Datetime
        """
        return self._lock_at

    @lock_at.setter
    def lock_at(self, lock_at):
        """
        Sets the lock_at of this Quiz.
        when to lock the quiz

        :param lock_at: The lock_at of this Quiz.
        :type: Datetime
        """

        self._lock_at = lock_at

    @property
    def unlock_at(self):
        """
        Gets the unlock_at of this Quiz.
        when to unlock the quiz

        :return: The unlock_at of this Quiz.
        :rtype: Datetime
        """
        return self._unlock_at

    @unlock_at.setter
    def unlock_at(self, unlock_at):
        """
        Sets the unlock_at of this Quiz.
        when to unlock the quiz

        :param unlock_at: The unlock_at of this Quiz.
        :type: Datetime
        """

        self._unlock_at = unlock_at

    @property
    def published(self):
        """
        Gets the published of this Quiz.
        whether the quiz has a published or unpublished draft state.

        :return: The published of this Quiz.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this Quiz.
        whether the quiz has a published or unpublished draft state.

        :param published: The published of this Quiz.
        :type: bool
        """

        self._published = published

    @property
    def unpublishable(self):
        """
        Gets the unpublishable of this Quiz.
        Whether the assignment's 'published' state can be changed to false. Will be false if there are student submissions for the quiz.

        :return: The unpublishable of this Quiz.
        :rtype: bool
        """
        return self._unpublishable

    @unpublishable.setter
    def unpublishable(self, unpublishable):
        """
        Sets the unpublishable of this Quiz.
        Whether the assignment's 'published' state can be changed to false. Will be false if there are student submissions for the quiz.

        :param unpublishable: The unpublishable of this Quiz.
        :type: bool
        """

        self._unpublishable = unpublishable

    @property
    def locked_for_user(self):
        """
        Gets the locked_for_user of this Quiz.
        Whether or not this is locked for the user.

        :return: The locked_for_user of this Quiz.
        :rtype: bool
        """
        return self._locked_for_user

    @locked_for_user.setter
    def locked_for_user(self, locked_for_user):
        """
        Sets the locked_for_user of this Quiz.
        Whether or not this is locked for the user.

        :param locked_for_user: The locked_for_user of this Quiz.
        :type: bool
        """

        self._locked_for_user = locked_for_user

    @property
    def lock_info(self):
        """
        Gets the lock_info of this Quiz.
        (Optional) Information for the user about the lock. Present when locked_for_user is true.

        :return: The lock_info of this Quiz.
        :rtype: LockInfo
        """
        return self._lock_info

    @lock_info.setter
    def lock_info(self, lock_info):
        """
        Sets the lock_info of this Quiz.
        (Optional) Information for the user about the lock. Present when locked_for_user is true.

        :param lock_info: The lock_info of this Quiz.
        :type: LockInfo
        """

        self._lock_info = lock_info

    @property
    def lock_explanation(self):
        """
        Gets the lock_explanation of this Quiz.
        (Optional) An explanation of why this is locked for the user. Present when locked_for_user is true.

        :return: The lock_explanation of this Quiz.
        :rtype: str
        """
        return self._lock_explanation

    @lock_explanation.setter
    def lock_explanation(self, lock_explanation):
        """
        Sets the lock_explanation of this Quiz.
        (Optional) An explanation of why this is locked for the user. Present when locked_for_user is true.

        :param lock_explanation: The lock_explanation of this Quiz.
        :type: str
        """

        self._lock_explanation = lock_explanation

    @property
    def speedgrader_url(self):
        """
        Gets the speedgrader_url of this Quiz.
        Link to Speed Grader for this quiz. Will not be present if quiz is unpublished

        :return: The speedgrader_url of this Quiz.
        :rtype: str
        """
        return self._speedgrader_url

    @speedgrader_url.setter
    def speedgrader_url(self, speedgrader_url):
        """
        Sets the speedgrader_url of this Quiz.
        Link to Speed Grader for this quiz. Will not be present if quiz is unpublished

        :param speedgrader_url: The speedgrader_url of this Quiz.
        :type: str
        """

        self._speedgrader_url = speedgrader_url

    @property
    def quiz_extensions_url(self):
        """
        Gets the quiz_extensions_url of this Quiz.
        Link to endpoint to send extensions for this quiz.

        :return: The quiz_extensions_url of this Quiz.
        :rtype: str
        """
        return self._quiz_extensions_url

    @quiz_extensions_url.setter
    def quiz_extensions_url(self, quiz_extensions_url):
        """
        Sets the quiz_extensions_url of this Quiz.
        Link to endpoint to send extensions for this quiz.

        :param quiz_extensions_url: The quiz_extensions_url of this Quiz.
        :type: str
        """

        self._quiz_extensions_url = quiz_extensions_url

    @property
    def permissions(self):
        """
        Gets the permissions of this Quiz.
        Permissions the user has for the quiz

        :return: The permissions of this Quiz.
        :rtype: QuizPermissions
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this Quiz.
        Permissions the user has for the quiz

        :param permissions: The permissions of this Quiz.
        :type: QuizPermissions
        """

        self._permissions = permissions

    @property
    def all_dates(self):
        """
        Gets the all_dates of this Quiz.
        list of due dates for the quiz

        :return: The all_dates of this Quiz.
        :rtype: AssignmentDate
        """
        return self._all_dates

    @all_dates.setter
    def all_dates(self, all_dates):
        """
        Sets the all_dates of this Quiz.
        list of due dates for the quiz

        :param all_dates: The all_dates of this Quiz.
        :type: AssignmentDate
        """

        self._all_dates = all_dates

    @property
    def version_number(self):
        """
        Gets the version_number of this Quiz.
        Current version number of the quiz

        :return: The version_number of this Quiz.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this Quiz.
        Current version number of the quiz

        :param version_number: The version_number of this Quiz.
        :type: int
        """

        self._version_number = version_number

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
