# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizStatisticsSubmissionStatistics(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, unique_count=None, score_average=None, score_high=None, score_low=None, score_stdev=None, scores=None, correct_count_average=None, incorrect_count_average=None, duration_average=None):
        """
        QuizStatisticsSubmissionStatistics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'unique_count': 'int',
            'score_average': 'float',
            'score_high': 'float',
            'score_low': 'float',
            'score_stdev': 'float',
            'scores': 'object',
            'correct_count_average': 'float',
            'incorrect_count_average': 'float',
            'duration_average': 'float'
        }

        self.attribute_map = {
            'unique_count': 'unique_count',
            'score_average': 'score_average',
            'score_high': 'score_high',
            'score_low': 'score_low',
            'score_stdev': 'score_stdev',
            'scores': 'scores',
            'correct_count_average': 'correct_count_average',
            'incorrect_count_average': 'incorrect_count_average',
            'duration_average': 'duration_average'
        }

        self._unique_count = unique_count
        self._score_average = score_average
        self._score_high = score_high
        self._score_low = score_low
        self._score_stdev = score_stdev
        self._scores = scores
        self._correct_count_average = correct_count_average
        self._incorrect_count_average = incorrect_count_average
        self._duration_average = duration_average

    @property
    def unique_count(self):
        """
        Gets the unique_count of this QuizStatisticsSubmissionStatistics.
        The number of students who have taken the quiz.

        :return: The unique_count of this QuizStatisticsSubmissionStatistics.
        :rtype: int
        """
        return self._unique_count

    @unique_count.setter
    def unique_count(self, unique_count):
        """
        Sets the unique_count of this QuizStatisticsSubmissionStatistics.
        The number of students who have taken the quiz.

        :param unique_count: The unique_count of this QuizStatisticsSubmissionStatistics.
        :type: int
        """

        self._unique_count = unique_count

    @property
    def score_average(self):
        """
        Gets the score_average of this QuizStatisticsSubmissionStatistics.
        The mean of the student submission scores.

        :return: The score_average of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._score_average

    @score_average.setter
    def score_average(self, score_average):
        """
        Sets the score_average of this QuizStatisticsSubmissionStatistics.
        The mean of the student submission scores.

        :param score_average: The score_average of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._score_average = score_average

    @property
    def score_high(self):
        """
        Gets the score_high of this QuizStatisticsSubmissionStatistics.
        The highest submission score.

        :return: The score_high of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._score_high

    @score_high.setter
    def score_high(self, score_high):
        """
        Sets the score_high of this QuizStatisticsSubmissionStatistics.
        The highest submission score.

        :param score_high: The score_high of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._score_high = score_high

    @property
    def score_low(self):
        """
        Gets the score_low of this QuizStatisticsSubmissionStatistics.
        The lowest submission score.

        :return: The score_low of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._score_low

    @score_low.setter
    def score_low(self, score_low):
        """
        Sets the score_low of this QuizStatisticsSubmissionStatistics.
        The lowest submission score.

        :param score_low: The score_low of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._score_low = score_low

    @property
    def score_stdev(self):
        """
        Gets the score_stdev of this QuizStatisticsSubmissionStatistics.
        Standard deviation of the submission scores.

        :return: The score_stdev of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._score_stdev

    @score_stdev.setter
    def score_stdev(self, score_stdev):
        """
        Sets the score_stdev of this QuizStatisticsSubmissionStatistics.
        Standard deviation of the submission scores.

        :param score_stdev: The score_stdev of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._score_stdev = score_stdev

    @property
    def scores(self):
        """
        Gets the scores of this QuizStatisticsSubmissionStatistics.
        A percentile distribution of the student scores, each key is the percentile (ranges between 0 and 100%) while the value is the number of students who received that score.

        :return: The scores of this QuizStatisticsSubmissionStatistics.
        :rtype: object
        """
        return self._scores

    @scores.setter
    def scores(self, scores):
        """
        Sets the scores of this QuizStatisticsSubmissionStatistics.
        A percentile distribution of the student scores, each key is the percentile (ranges between 0 and 100%) while the value is the number of students who received that score.

        :param scores: The scores of this QuizStatisticsSubmissionStatistics.
        :type: object
        """

        self._scores = scores

    @property
    def correct_count_average(self):
        """
        Gets the correct_count_average of this QuizStatisticsSubmissionStatistics.
        The mean of the number of questions answered correctly by each student.

        :return: The correct_count_average of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._correct_count_average

    @correct_count_average.setter
    def correct_count_average(self, correct_count_average):
        """
        Sets the correct_count_average of this QuizStatisticsSubmissionStatistics.
        The mean of the number of questions answered correctly by each student.

        :param correct_count_average: The correct_count_average of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._correct_count_average = correct_count_average

    @property
    def incorrect_count_average(self):
        """
        Gets the incorrect_count_average of this QuizStatisticsSubmissionStatistics.
        The mean of the number of questions answered incorrectly by each student.

        :return: The incorrect_count_average of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._incorrect_count_average

    @incorrect_count_average.setter
    def incorrect_count_average(self, incorrect_count_average):
        """
        Sets the incorrect_count_average of this QuizStatisticsSubmissionStatistics.
        The mean of the number of questions answered incorrectly by each student.

        :param incorrect_count_average: The incorrect_count_average of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._incorrect_count_average = incorrect_count_average

    @property
    def duration_average(self):
        """
        Gets the duration_average of this QuizStatisticsSubmissionStatistics.
        The average time spent by students while taking the quiz.

        :return: The duration_average of this QuizStatisticsSubmissionStatistics.
        :rtype: float
        """
        return self._duration_average

    @duration_average.setter
    def duration_average(self, duration_average):
        """
        Sets the duration_average of this QuizStatisticsSubmissionStatistics.
        The average time spent by students while taking the quiz.

        :param duration_average: The duration_average of this QuizStatisticsSubmissionStatistics.
        :type: float
        """

        self._duration_average = duration_average

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
