# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Answer(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, answer_text=None, answer_weight=None, answer_comments=None, text_after_answers=None, answer_match_left=None, answer_match_right=None, matching_answer_incorrect_matches=None, numerical_answer_type=None, exact=None, margin=None, start=None, end=None, blank_id=None):
        """
        Answer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'answer_text': 'str',
            'answer_weight': 'int',
            'answer_comments': 'str',
            'text_after_answers': 'str',
            'answer_match_left': 'str',
            'answer_match_right': 'str',
            'matching_answer_incorrect_matches': 'str',
            'numerical_answer_type': 'str',
            'exact': 'int',
            'margin': 'int',
            'start': 'int',
            'end': 'int',
            'blank_id': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'answer_text': 'answer_text',
            'answer_weight': 'answer_weight',
            'answer_comments': 'answer_comments',
            'text_after_answers': 'text_after_answers',
            'answer_match_left': 'answer_match_left',
            'answer_match_right': 'answer_match_right',
            'matching_answer_incorrect_matches': 'matching_answer_incorrect_matches',
            'numerical_answer_type': 'numerical_answer_type',
            'exact': 'exact',
            'margin': 'margin',
            'start': 'start',
            'end': 'end',
            'blank_id': 'blank_id'
        }

        self._id = id
        self._answer_text = answer_text
        self._answer_weight = answer_weight
        self._answer_comments = answer_comments
        self._text_after_answers = text_after_answers
        self._answer_match_left = answer_match_left
        self._answer_match_right = answer_match_right
        self._matching_answer_incorrect_matches = matching_answer_incorrect_matches
        self._numerical_answer_type = numerical_answer_type
        self._exact = exact
        self._margin = margin
        self._start = start
        self._end = end
        self._blank_id = blank_id

    @property
    def id(self):
        """
        Gets the id of this Answer.
        The unique identifier for the answer.  Do not supply if this answer is part of a new question

        :return: The id of this Answer.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Answer.
        The unique identifier for the answer.  Do not supply if this answer is part of a new question

        :param id: The id of this Answer.
        :type: int
        """

        self._id = id

    @property
    def answer_text(self):
        """
        Gets the answer_text of this Answer.
        The text of the answer.

        :return: The answer_text of this Answer.
        :rtype: str
        """
        return self._answer_text

    @answer_text.setter
    def answer_text(self, answer_text):
        """
        Sets the answer_text of this Answer.
        The text of the answer.

        :param answer_text: The answer_text of this Answer.
        :type: str
        """

        self._answer_text = answer_text

    @property
    def answer_weight(self):
        """
        Gets the answer_weight of this Answer.
        An integer to determine correctness of the answer. Incorrect answers should be 0, correct answers should be non-negative.

        :return: The answer_weight of this Answer.
        :rtype: int
        """
        return self._answer_weight

    @answer_weight.setter
    def answer_weight(self, answer_weight):
        """
        Sets the answer_weight of this Answer.
        An integer to determine correctness of the answer. Incorrect answers should be 0, correct answers should be non-negative.

        :param answer_weight: The answer_weight of this Answer.
        :type: int
        """

        self._answer_weight = answer_weight

    @property
    def answer_comments(self):
        """
        Gets the answer_comments of this Answer.
        Specific contextual comments for a particular answer.

        :return: The answer_comments of this Answer.
        :rtype: str
        """
        return self._answer_comments

    @answer_comments.setter
    def answer_comments(self, answer_comments):
        """
        Sets the answer_comments of this Answer.
        Specific contextual comments for a particular answer.

        :param answer_comments: The answer_comments of this Answer.
        :type: str
        """

        self._answer_comments = answer_comments

    @property
    def text_after_answers(self):
        """
        Gets the text_after_answers of this Answer.
        Used in missing word questions.  The text to follow the missing word

        :return: The text_after_answers of this Answer.
        :rtype: str
        """
        return self._text_after_answers

    @text_after_answers.setter
    def text_after_answers(self, text_after_answers):
        """
        Sets the text_after_answers of this Answer.
        Used in missing word questions.  The text to follow the missing word

        :param text_after_answers: The text_after_answers of this Answer.
        :type: str
        """

        self._text_after_answers = text_after_answers

    @property
    def answer_match_left(self):
        """
        Gets the answer_match_left of this Answer.
        Used in matching questions.  The static value of the answer that will be displayed on the left for students to match for.

        :return: The answer_match_left of this Answer.
        :rtype: str
        """
        return self._answer_match_left

    @answer_match_left.setter
    def answer_match_left(self, answer_match_left):
        """
        Sets the answer_match_left of this Answer.
        Used in matching questions.  The static value of the answer that will be displayed on the left for students to match for.

        :param answer_match_left: The answer_match_left of this Answer.
        :type: str
        """

        self._answer_match_left = answer_match_left

    @property
    def answer_match_right(self):
        """
        Gets the answer_match_right of this Answer.
        Used in matching questions. The correct match for the value given in answer_match_left.  Will be displayed in a dropdown with the other answer_match_right values..

        :return: The answer_match_right of this Answer.
        :rtype: str
        """
        return self._answer_match_right

    @answer_match_right.setter
    def answer_match_right(self, answer_match_right):
        """
        Sets the answer_match_right of this Answer.
        Used in matching questions. The correct match for the value given in answer_match_left.  Will be displayed in a dropdown with the other answer_match_right values..

        :param answer_match_right: The answer_match_right of this Answer.
        :type: str
        """

        self._answer_match_right = answer_match_right

    @property
    def matching_answer_incorrect_matches(self):
        """
        Gets the matching_answer_incorrect_matches of this Answer.
        Used in matching questions. A list of distractors, delimited by new lines ( ) that will be seeded with all the answer_match_right values.

        :return: The matching_answer_incorrect_matches of this Answer.
        :rtype: str
        """
        return self._matching_answer_incorrect_matches

    @matching_answer_incorrect_matches.setter
    def matching_answer_incorrect_matches(self, matching_answer_incorrect_matches):
        """
        Sets the matching_answer_incorrect_matches of this Answer.
        Used in matching questions. A list of distractors, delimited by new lines ( ) that will be seeded with all the answer_match_right values.

        :param matching_answer_incorrect_matches: The matching_answer_incorrect_matches of this Answer.
        :type: str
        """

        self._matching_answer_incorrect_matches = matching_answer_incorrect_matches

    @property
    def numerical_answer_type(self):
        """
        Gets the numerical_answer_type of this Answer.
        Used in numerical questions.  Values can be 'exact_answer' or 'range_answer'.

        :return: The numerical_answer_type of this Answer.
        :rtype: str
        """
        return self._numerical_answer_type

    @numerical_answer_type.setter
    def numerical_answer_type(self, numerical_answer_type):
        """
        Sets the numerical_answer_type of this Answer.
        Used in numerical questions.  Values can be 'exact_answer' or 'range_answer'.

        :param numerical_answer_type: The numerical_answer_type of this Answer.
        :type: str
        """

        self._numerical_answer_type = numerical_answer_type

    @property
    def exact(self):
        """
        Gets the exact of this Answer.
        Used in numerical questions of type 'exact_answer'.  The value the answer should equal.

        :return: The exact of this Answer.
        :rtype: int
        """
        return self._exact

    @exact.setter
    def exact(self, exact):
        """
        Sets the exact of this Answer.
        Used in numerical questions of type 'exact_answer'.  The value the answer should equal.

        :param exact: The exact of this Answer.
        :type: int
        """

        self._exact = exact

    @property
    def margin(self):
        """
        Gets the margin of this Answer.
        Used in numerical questions of type 'exact_answer'. The margin of error allowed for the student's answer.

        :return: The margin of this Answer.
        :rtype: int
        """
        return self._margin

    @margin.setter
    def margin(self, margin):
        """
        Sets the margin of this Answer.
        Used in numerical questions of type 'exact_answer'. The margin of error allowed for the student's answer.

        :param margin: The margin of this Answer.
        :type: int
        """

        self._margin = margin

    @property
    def start(self):
        """
        Gets the start of this Answer.
        Used in numerical questions of type 'range_answer'. The start of the allowed range (inclusive).

        :return: The start of this Answer.
        :rtype: int
        """
        return self._start

    @start.setter
    def start(self, start):
        """
        Sets the start of this Answer.
        Used in numerical questions of type 'range_answer'. The start of the allowed range (inclusive).

        :param start: The start of this Answer.
        :type: int
        """

        self._start = start

    @property
    def end(self):
        """
        Gets the end of this Answer.
        Used in numerical questions of type 'range_answer'. The end of the allowed range (inclusive).

        :return: The end of this Answer.
        :rtype: int
        """
        return self._end

    @end.setter
    def end(self, end):
        """
        Sets the end of this Answer.
        Used in numerical questions of type 'range_answer'. The end of the allowed range (inclusive).

        :param end: The end of this Answer.
        :type: int
        """

        self._end = end

    @property
    def blank_id(self):
        """
        Gets the blank_id of this Answer.
        Used in fill in multiple blank and multiple dropdowns questions.

        :return: The blank_id of this Answer.
        :rtype: int
        """
        return self._blank_id

    @blank_id.setter
    def blank_id(self, blank_id):
        """
        Sets the blank_id of this Answer.
        Used in fill in multiple blank and multiple dropdowns questions.

        :param blank_id: The blank_id of this Answer.
        :type: int
        """

        self._blank_id = blank_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
