# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class QuizquestionsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_single_quiz_question
    def create_single_quiz_question(self, course_id, quiz_id, **kwargs):
        """
        Create a single quiz question
        Create a new quiz question for this quiz

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_single_quiz_question_with_http_info(course_id, quiz_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str question_question_name: The name of the question.
        :param str question_question_text: The text of the question.
        :param int question_quiz_group_id: The id of the quiz group to assign the question to.
        :param str question_question_type: The type of question. Multiple optional fields depend upon the type of question to be used.
        :param int question_position: The order in which the question will be displayed in the quiz in relation to other questions.
        :param int question_points_possible: The maximum amount of points received for answering this question correctly.
        :param str question_correct_comments: The comment to display if the student answers the question correctly.
        :param str question_incorrect_comments: The comment to display if the student answers incorrectly.
        :param str question_neutral_comments: The comment to display regardless of how the student answered.
        :param str question_text_after_answers: no description
        :param Object question_answers: no description
        :return: QuizQuestion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'question_question_name', 'question_question_text', 'question_quiz_group_id', 'question_question_type', 'question_position', 'question_points_possible', 'question_correct_comments', 'question_incorrect_comments', 'question_neutral_comments', 'question_text_after_answers', 'question_answers']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_single_quiz_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_single_quiz_question`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `create_single_quiz_question`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/questions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'question_question_name' in params:
            form_params.append(('question[question_name]', params['question_question_name']))
        if 'question_question_text' in params:
            form_params.append(('question[question_text]', params['question_question_text']))
        if 'question_quiz_group_id' in params:
            form_params.append(('question[quiz_group_id]', params['question_quiz_group_id']))
        if 'question_question_type' in params:
            form_params.append(('question[question_type]', params['question_question_type']))
        if 'question_position' in params:
            form_params.append(('question[position]', params['question_position']))
        if 'question_points_possible' in params:
            form_params.append(('question[points_possible]', params['question_points_possible']))
        if 'question_correct_comments' in params:
            form_params.append(('question[correct_comments]', params['question_correct_comments']))
        if 'question_incorrect_comments' in params:
            form_params.append(('question[incorrect_comments]', params['question_incorrect_comments']))
        if 'question_neutral_comments' in params:
            form_params.append(('question[neutral_comments]', params['question_neutral_comments']))
        if 'question_text_after_answers' in params:
            form_params.append(('question[text_after_answers]', params['question_text_after_answers']))
        if 'question_answers' in params:
            form_params.append(('question[answers]', params['question_answers']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QuizQuestion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_quiz_question
    def delete_quiz_question(self, course_id, quiz_id, id, **kwargs):
        """
        Delete a quiz question
        <b>204 No Content</b> response code is returned if the deletion was successful.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quiz_question_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param int quiz_id: The associated quiz's unique identifier (required)
        :param int id: The quiz question's unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quiz_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_quiz_question`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `delete_quiz_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_quiz_question`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/questions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_quiz_question
    def get_single_quiz_question(self, course_id, quiz_id, id, **kwargs):
        """
        Get a single quiz question
        Returns the quiz question with the given id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_quiz_question_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param int id: The quiz question unique identifier. (required)
        :return: QuizQuestion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_quiz_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_quiz_question`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `get_single_quiz_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_quiz_question`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/questions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QuizQuestion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_questions_in_quiz_or_submission
    def list_questions_in_quiz_or_submission(self, course_id, quiz_id, **kwargs):
        """
        List questions in a quiz or a submission
        Returns the list of QuizQuestions in this quiz.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_questions_in_quiz_or_submission_with_http_info(course_id, quiz_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param int quiz_submission_id: If specified, the endpoint will return the questions that were presented for that submission. This is useful if the quiz has been modified after the submission was created and the latest quiz version's set of questions does not match the submission's. NOTE: you must specify quiz_submission_attempt as well if you specify this parameter.
        :param int quiz_submission_attempt: The attempt of the submission you want the questions for.
        :return: list[QuizQuestion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'quiz_submission_id', 'quiz_submission_attempt']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_questions_in_quiz_or_submission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_questions_in_quiz_or_submission`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `list_questions_in_quiz_or_submission`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/questions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'quiz_submission_id' in params:
            query_params['quiz_submission_id'] = params['quiz_submission_id']
        if 'quiz_submission_attempt' in params:
            query_params['quiz_submission_attempt'] = params['quiz_submission_attempt']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[QuizQuestion]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_existing_quiz_question
    def update_existing_quiz_question(self, course_id, quiz_id, id, **kwargs):
        """
        Update an existing quiz question
        Updates an existing quiz question for this quiz

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_existing_quiz_question_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param int quiz_id: The associated quiz's unique identifier. (required)
        :param int id: The quiz question's unique identifier. (required)
        :param str question_question_name: The name of the question.
        :param str question_question_text: The text of the question.
        :param int question_quiz_group_id: The id of the quiz group to assign the question to.
        :param str question_question_type: The type of question. Multiple optional fields depend upon the type of question to be used.
        :param int question_position: The order in which the question will be displayed in the quiz in relation to other questions.
        :param int question_points_possible: The maximum amount of points received for answering this question correctly.
        :param str question_correct_comments: The comment to display if the student answers the question correctly.
        :param str question_incorrect_comments: The comment to display if the student answers incorrectly.
        :param str question_neutral_comments: The comment to display regardless of how the student answered.
        :param str question_text_after_answers: no description
        :param Object question_answers: no description
        :return: QuizQuestion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id', 'question_question_name', 'question_question_text', 'question_quiz_group_id', 'question_question_type', 'question_position', 'question_points_possible', 'question_correct_comments', 'question_incorrect_comments', 'question_neutral_comments', 'question_text_after_answers', 'question_answers']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_existing_quiz_question" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_existing_quiz_question`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `update_existing_quiz_question`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_existing_quiz_question`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/questions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'question_question_name' in params:
            form_params.append(('question[question_name]', params['question_question_name']))
        if 'question_question_text' in params:
            form_params.append(('question[question_text]', params['question_question_text']))
        if 'question_quiz_group_id' in params:
            form_params.append(('question[quiz_group_id]', params['question_quiz_group_id']))
        if 'question_question_type' in params:
            form_params.append(('question[question_type]', params['question_question_type']))
        if 'question_position' in params:
            form_params.append(('question[position]', params['question_position']))
        if 'question_points_possible' in params:
            form_params.append(('question[points_possible]', params['question_points_possible']))
        if 'question_correct_comments' in params:
            form_params.append(('question[correct_comments]', params['question_correct_comments']))
        if 'question_incorrect_comments' in params:
            form_params.append(('question[incorrect_comments]', params['question_incorrect_comments']))
        if 'question_neutral_comments' in params:
            form_params.append(('question[neutral_comments]', params['question_neutral_comments']))
        if 'question_text_after_answers' in params:
            form_params.append(('question[text_after_answers]', params['question_text_after_answers']))
        if 'question_answers' in params:
            form_params.append(('question[answers]', params['question_answers']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QuizQuestion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
