# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizGroup(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, quiz_id=None, name=None, pick_count=None, question_points=None, assessment_question_bank_id=None, position=None):
        """
        QuizGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'quiz_id': 'int',
            'name': 'str',
            'pick_count': 'int',
            'question_points': 'int',
            'assessment_question_bank_id': 'int',
            'position': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'quiz_id': 'quiz_id',
            'name': 'name',
            'pick_count': 'pick_count',
            'question_points': 'question_points',
            'assessment_question_bank_id': 'assessment_question_bank_id',
            'position': 'position'
        }

        self._id = id
        self._quiz_id = quiz_id
        self._name = name
        self._pick_count = pick_count
        self._question_points = question_points
        self._assessment_question_bank_id = assessment_question_bank_id
        self._position = position

    @property
    def id(self):
        """
        Gets the id of this QuizGroup.
        The ID of the question group.

        :return: The id of this QuizGroup.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizGroup.
        The ID of the question group.

        :param id: The id of this QuizGroup.
        :type: int
        """

        self._id = id

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizGroup.
        The ID of the Quiz the question group belongs to.

        :return: The quiz_id of this QuizGroup.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizGroup.
        The ID of the Quiz the question group belongs to.

        :param quiz_id: The quiz_id of this QuizGroup.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def name(self):
        """
        Gets the name of this QuizGroup.
        The name of the question group.

        :return: The name of this QuizGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QuizGroup.
        The name of the question group.

        :param name: The name of this QuizGroup.
        :type: str
        """

        self._name = name

    @property
    def pick_count(self):
        """
        Gets the pick_count of this QuizGroup.
        The number of questions to pick from the group to display to the student.

        :return: The pick_count of this QuizGroup.
        :rtype: int
        """
        return self._pick_count

    @pick_count.setter
    def pick_count(self, pick_count):
        """
        Sets the pick_count of this QuizGroup.
        The number of questions to pick from the group to display to the student.

        :param pick_count: The pick_count of this QuizGroup.
        :type: int
        """

        self._pick_count = pick_count

    @property
    def question_points(self):
        """
        Gets the question_points of this QuizGroup.
        The amount of points allotted to each question in the group.

        :return: The question_points of this QuizGroup.
        :rtype: int
        """
        return self._question_points

    @question_points.setter
    def question_points(self, question_points):
        """
        Sets the question_points of this QuizGroup.
        The amount of points allotted to each question in the group.

        :param question_points: The question_points of this QuizGroup.
        :type: int
        """

        self._question_points = question_points

    @property
    def assessment_question_bank_id(self):
        """
        Gets the assessment_question_bank_id of this QuizGroup.
        The ID of the Assessment question bank to pull questions from.

        :return: The assessment_question_bank_id of this QuizGroup.
        :rtype: int
        """
        return self._assessment_question_bank_id

    @assessment_question_bank_id.setter
    def assessment_question_bank_id(self, assessment_question_bank_id):
        """
        Sets the assessment_question_bank_id of this QuizGroup.
        The ID of the Assessment question bank to pull questions from.

        :param assessment_question_bank_id: The assessment_question_bank_id of this QuizGroup.
        :type: int
        """

        self._assessment_question_bank_id = assessment_question_bank_id

    @property
    def position(self):
        """
        Gets the position of this QuizGroup.
        The order in which the question group will be retrieved and displayed.

        :return: The position of this QuizGroup.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this QuizGroup.
        The order in which the question group will be retrieved and displayed.

        :param position: The position of this QuizGroup.
        :type: int
        """

        self._position = position

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
