# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizAssignmentOverride(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, due_at=None, unlock_at=None, lock_at=None, title=None, base=None):
        """
        QuizAssignmentOverride - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'due_at': 'Datetime',
            'unlock_at': 'Datetime',
            'lock_at': 'Datetime',
            'title': 'str',
            'base': 'bool'
        }

        self.attribute_map = {
            'id': 'id',
            'due_at': 'due_at',
            'unlock_at': 'unlock_at',
            'lock_at': 'lock_at',
            'title': 'title',
            'base': 'base'
        }

        self._id = id
        self._due_at = due_at
        self._unlock_at = unlock_at
        self._lock_at = lock_at
        self._title = title
        self._base = base

    @property
    def id(self):
        """
        Gets the id of this QuizAssignmentOverride.
        ID of the assignment override, unless this is the base construct, in which case the 'id' field is omitted.

        :return: The id of this QuizAssignmentOverride.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizAssignmentOverride.
        ID of the assignment override, unless this is the base construct, in which case the 'id' field is omitted.

        :param id: The id of this QuizAssignmentOverride.
        :type: int
        """

        self._id = id

    @property
    def due_at(self):
        """
        Gets the due_at of this QuizAssignmentOverride.
        The date after which any quiz submission is considered late.

        :return: The due_at of this QuizAssignmentOverride.
        :rtype: Datetime
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """
        Sets the due_at of this QuizAssignmentOverride.
        The date after which any quiz submission is considered late.

        :param due_at: The due_at of this QuizAssignmentOverride.
        :type: Datetime
        """

        self._due_at = due_at

    @property
    def unlock_at(self):
        """
        Gets the unlock_at of this QuizAssignmentOverride.
        Date when the quiz becomes available for taking.

        :return: The unlock_at of this QuizAssignmentOverride.
        :rtype: Datetime
        """
        return self._unlock_at

    @unlock_at.setter
    def unlock_at(self, unlock_at):
        """
        Sets the unlock_at of this QuizAssignmentOverride.
        Date when the quiz becomes available for taking.

        :param unlock_at: The unlock_at of this QuizAssignmentOverride.
        :type: Datetime
        """

        self._unlock_at = unlock_at

    @property
    def lock_at(self):
        """
        Gets the lock_at of this QuizAssignmentOverride.
        When the quiz will stop being available for taking. A value of null means it can always be taken.

        :return: The lock_at of this QuizAssignmentOverride.
        :rtype: Datetime
        """
        return self._lock_at

    @lock_at.setter
    def lock_at(self, lock_at):
        """
        Sets the lock_at of this QuizAssignmentOverride.
        When the quiz will stop being available for taking. A value of null means it can always be taken.

        :param lock_at: The lock_at of this QuizAssignmentOverride.
        :type: Datetime
        """

        self._lock_at = lock_at

    @property
    def title(self):
        """
        Gets the title of this QuizAssignmentOverride.
        Title of the section this assignment override is for, if any.

        :return: The title of this QuizAssignmentOverride.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this QuizAssignmentOverride.
        Title of the section this assignment override is for, if any.

        :param title: The title of this QuizAssignmentOverride.
        :type: str
        """

        self._title = title

    @property
    def base(self):
        """
        Gets the base of this QuizAssignmentOverride.
        If this property is present, it means that dates in this structure are not based on an assignment override, but are instead for all students.

        :return: The base of this QuizAssignmentOverride.
        :rtype: bool
        """
        return self._base

    @base.setter
    def base(self, base):
        """
        Sets the base of this QuizAssignmentOverride.
        If this property is present, it means that dates in this structure are not based on an assignment override, but are instead for all students.

        :param base: The base of this QuizAssignmentOverride.
        :type: bool
        """

        self._base = base

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
