# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Result(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, passed=None, assessed_at=None, links=None):
        """
        Result - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'passed': 'bool',
            'assessed_at': 'Datetime',
            'links': 'ResultLinks'
        }

        self.attribute_map = {
            'id': 'id',
            'passed': 'passed',
            'assessed_at': 'assessed_at',
            'links': 'links'
        }

        self._id = id
        self._passed = passed
        self._assessed_at = assessed_at
        self._links = links

    @property
    def id(self):
        """
        Gets the id of this Result.
        A unique identifier for this result

        :return: The id of this Result.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Result.
        A unique identifier for this result

        :param id: The id of this Result.
        :type: str
        """

        self._id = id

    @property
    def passed(self):
        """
        Gets the passed of this Result.
        Whether the user passed or not

        :return: The passed of this Result.
        :rtype: bool
        """
        return self._passed

    @passed.setter
    def passed(self, passed):
        """
        Sets the passed of this Result.
        Whether the user passed or not

        :param passed: The passed of this Result.
        :type: bool
        """

        self._passed = passed

    @property
    def assessed_at(self):
        """
        Gets the assessed_at of this Result.
        When this result was recorded

        :return: The assessed_at of this Result.
        :rtype: Datetime
        """
        return self._assessed_at

    @assessed_at.setter
    def assessed_at(self, assessed_at):
        """
        Sets the assessed_at of this Result.
        When this result was recorded

        :param assessed_at: The assessed_at of this Result.
        :type: Datetime
        """

        self._assessed_at = assessed_at

    @property
    def links(self):
        """
        Gets the links of this Result.
        Unique identifiers of objects associated with this result

        :return: The links of this Result.
        :rtype: ResultLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this Result.
        Unique identifiers of objects associated with this result

        :param links: The links of this Result.
        :type: ResultLinks
        """

        self._links = links

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
