# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class FeatureFlag(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, context_type=None, context_id=None, feature=None, state=None, locked=None, locking_account_id=None):
        """
        FeatureFlag - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'context_type': 'str',
            'context_id': 'int',
            'feature': 'str',
            'state': 'str',
            'locked': 'bool',
            'locking_account_id': 'int'
        }

        self.attribute_map = {
            'context_type': 'context_type',
            'context_id': 'context_id',
            'feature': 'feature',
            'state': 'state',
            'locked': 'locked',
            'locking_account_id': 'locking_account_id'
        }

        self._context_type = context_type
        self._context_id = context_id
        self._feature = feature
        self._state = state
        self._locked = locked
        self._locking_account_id = locking_account_id

    @property
    def context_type(self):
        """
        Gets the context_type of this FeatureFlag.
        The type of object to which this flag applies (Account, Course, or User). (This field is not present if this FeatureFlag represents the global Canvas default)

        :return: The context_type of this FeatureFlag.
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type):
        """
        Sets the context_type of this FeatureFlag.
        The type of object to which this flag applies (Account, Course, or User). (This field is not present if this FeatureFlag represents the global Canvas default)

        :param context_type: The context_type of this FeatureFlag.
        :type: str
        """

        self._context_type = context_type

    @property
    def context_id(self):
        """
        Gets the context_id of this FeatureFlag.
        The id of the object to which this flag applies (This field is not present if this FeatureFlag represents the global Canvas default)

        :return: The context_id of this FeatureFlag.
        :rtype: int
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id):
        """
        Sets the context_id of this FeatureFlag.
        The id of the object to which this flag applies (This field is not present if this FeatureFlag represents the global Canvas default)

        :param context_id: The context_id of this FeatureFlag.
        :type: int
        """

        self._context_id = context_id

    @property
    def feature(self):
        """
        Gets the feature of this FeatureFlag.
        The feature this flag controls

        :return: The feature of this FeatureFlag.
        :rtype: str
        """
        return self._feature

    @feature.setter
    def feature(self, feature):
        """
        Sets the feature of this FeatureFlag.
        The feature this flag controls

        :param feature: The feature of this FeatureFlag.
        :type: str
        """

        self._feature = feature

    @property
    def state(self):
        """
        Gets the state of this FeatureFlag.
        The policy for the feature at this context.  can be 'off', 'allowed', or 'on'.

        :return: The state of this FeatureFlag.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this FeatureFlag.
        The policy for the feature at this context.  can be 'off', 'allowed', or 'on'.

        :param state: The state of this FeatureFlag.
        :type: str
        """

        self._state = state

    @property
    def locked(self):
        """
        Gets the locked of this FeatureFlag.
        If set, this feature flag cannot be changed in the caller's context because the flag is set 'off' or 'on' in a higher context, or the flag is locked by an account the caller does not have permission to administer

        :return: The locked of this FeatureFlag.
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """
        Sets the locked of this FeatureFlag.
        If set, this feature flag cannot be changed in the caller's context because the flag is set 'off' or 'on' in a higher context, or the flag is locked by an account the caller does not have permission to administer

        :param locked: The locked of this FeatureFlag.
        :type: bool
        """

        self._locked = locked

    @property
    def locking_account_id(self):
        """
        Gets the locking_account_id of this FeatureFlag.
        If set, this FeatureFlag can only be modified by someone with administrative rights in the specified account

        :return: The locking_account_id of this FeatureFlag.
        :rtype: int
        """
        return self._locking_account_id

    @locking_account_id.setter
    def locking_account_id(self, locking_account_id):
        """
        Sets the locking_account_id of this FeatureFlag.
        If set, this FeatureFlag can only be modified by someone with administrative rights in the specified account

        :param locking_account_id: The locking_account_id of this FeatureFlag.
        :type: int
        """

        self._locking_account_id = locking_account_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
