# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Feature(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, display_name=None, applies_to=None, enable_at=None, feature_flag=None, root_opt_in=None, beta=None, development=None, release_notes_url=None):
        """
        Feature - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'applies_to': 'str',
            'enable_at': 'Datetime',
            'feature_flag': 'FeatureFlag',
            'root_opt_in': 'bool',
            'beta': 'bool',
            'development': 'bool',
            'release_notes_url': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'display_name': 'display_name',
            'applies_to': 'applies_to',
            'enable_at': 'enable_at',
            'feature_flag': 'feature_flag',
            'root_opt_in': 'root_opt_in',
            'beta': 'beta',
            'development': 'development',
            'release_notes_url': 'release_notes_url'
        }

        self._name = name
        self._display_name = display_name
        self._applies_to = applies_to
        self._enable_at = enable_at
        self._feature_flag = feature_flag
        self._root_opt_in = root_opt_in
        self._beta = beta
        self._development = development
        self._release_notes_url = release_notes_url

    @property
    def name(self):
        """
        Gets the name of this Feature.
        The symbolic name of the feature, used in FeatureFlags

        :return: The name of this Feature.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Feature.
        The symbolic name of the feature, used in FeatureFlags

        :param name: The name of this Feature.
        :type: str
        """

        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this Feature.
        The user-visible name of the feature

        :return: The display_name of this Feature.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Feature.
        The user-visible name of the feature

        :param display_name: The display_name of this Feature.
        :type: str
        """

        self._display_name = display_name

    @property
    def applies_to(self):
        """
        Gets the applies_to of this Feature.
        The type of object the feature applies to (RootAccount, Account, Course, or User):  * RootAccount features may only be controlled by flags on root accounts.  * Account features may be controlled by flags on accounts and their parent accounts.  * Course features may be controlled by flags on courses and their parent accounts.  * User features may be controlled by flags on users and site admin only.

        :return: The applies_to of this Feature.
        :rtype: str
        """
        return self._applies_to

    @applies_to.setter
    def applies_to(self, applies_to):
        """
        Sets the applies_to of this Feature.
        The type of object the feature applies to (RootAccount, Account, Course, or User):  * RootAccount features may only be controlled by flags on root accounts.  * Account features may be controlled by flags on accounts and their parent accounts.  * Course features may be controlled by flags on courses and their parent accounts.  * User features may be controlled by flags on users and site admin only.

        :param applies_to: The applies_to of this Feature.
        :type: str
        """

        self._applies_to = applies_to

    @property
    def enable_at(self):
        """
        Gets the enable_at of this Feature.
        The date this feature will be globally enabled, or null if this is not planned. (This information is subject to change.)

        :return: The enable_at of this Feature.
        :rtype: Datetime
        """
        return self._enable_at

    @enable_at.setter
    def enable_at(self, enable_at):
        """
        Sets the enable_at of this Feature.
        The date this feature will be globally enabled, or null if this is not planned. (This information is subject to change.)

        :param enable_at: The enable_at of this Feature.
        :type: Datetime
        """

        self._enable_at = enable_at

    @property
    def feature_flag(self):
        """
        Gets the feature_flag of this Feature.
        The FeatureFlag that applies to the caller

        :return: The feature_flag of this Feature.
        :rtype: FeatureFlag
        """
        return self._feature_flag

    @feature_flag.setter
    def feature_flag(self, feature_flag):
        """
        Sets the feature_flag of this Feature.
        The FeatureFlag that applies to the caller

        :param feature_flag: The feature_flag of this Feature.
        :type: FeatureFlag
        """

        self._feature_flag = feature_flag

    @property
    def root_opt_in(self):
        """
        Gets the root_opt_in of this Feature.
        If true, a feature that is 'allowed' globally will be 'off' by default in root accounts. Otherwise, root accounts inherit the global 'allowed' setting, which allows sub-accounts and courses to turn features on with no root account action.

        :return: The root_opt_in of this Feature.
        :rtype: bool
        """
        return self._root_opt_in

    @root_opt_in.setter
    def root_opt_in(self, root_opt_in):
        """
        Sets the root_opt_in of this Feature.
        If true, a feature that is 'allowed' globally will be 'off' by default in root accounts. Otherwise, root accounts inherit the global 'allowed' setting, which allows sub-accounts and courses to turn features on with no root account action.

        :param root_opt_in: The root_opt_in of this Feature.
        :type: bool
        """

        self._root_opt_in = root_opt_in

    @property
    def beta(self):
        """
        Gets the beta of this Feature.
        Whether the feature is a beta feature. If true, the feature may not be fully polished and may be subject to change in the future.

        :return: The beta of this Feature.
        :rtype: bool
        """
        return self._beta

    @beta.setter
    def beta(self, beta):
        """
        Sets the beta of this Feature.
        Whether the feature is a beta feature. If true, the feature may not be fully polished and may be subject to change in the future.

        :param beta: The beta of this Feature.
        :type: bool
        """

        self._beta = beta

    @property
    def development(self):
        """
        Gets the development of this Feature.
        Whether the feature is in active development. Features in this state are only visible in test and beta instances and are not yet available for production use.

        :return: The development of this Feature.
        :rtype: bool
        """
        return self._development

    @development.setter
    def development(self, development):
        """
        Sets the development of this Feature.
        Whether the feature is in active development. Features in this state are only visible in test and beta instances and are not yet available for production use.

        :param development: The development of this Feature.
        :type: bool
        """

        self._development = development

    @property
    def release_notes_url(self):
        """
        Gets the release_notes_url of this Feature.
        A URL to the release notes describing the feature

        :return: The release_notes_url of this Feature.
        :rtype: str
        """
        return self._release_notes_url

    @release_notes_url.setter
    def release_notes_url(self, release_notes_url):
        """
        Sets the release_notes_url of this Feature.
        A URL to the release notes describing the feature

        :param release_notes_url: The release_notes_url of this Feature.
        :type: str
        """

        self._release_notes_url = release_notes_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
