# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class ExternaltoolsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_external_tool_accounts
    def create_external_tool_accounts(self, account_id, name, privacy_level, consumer_key, shared_secret, **kwargs):
        """
        Create an external tool
        Create an external tool in the specified course/account. The created tool will be returned, see the \"show\" endpoint for an example.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_tool_accounts_with_http_info(account_id, name, privacy_level, consumer_key, shared_secret, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str name: The name of the tool (required)
        :param str privacy_level: What information to send to the external tool. (required)
        :param str consumer_key: The consumer key for the external tool (required)
        :param str shared_secret: The shared secret with the external tool (required)
        :param str description: A description of the tool
        :param str url: The url to match links against. Either \"url\" or \"domain\" should be set, not both.
        :param str domain: The domain to match links against. Either \"url\" or \"domain\" should be set, not both.
        :param str icon_url: The url of the icon to show for this tool
        :param str text: The default text to show for this tool
        :param bool not_selectable: Default: false, if set to true the tool won't show up in the external tool selection UI in modules and assignments
        :param str custom_fields: Custom fields that will be sent to the tool consumer, specified as custom_fields[field_name]
        :param str account_navigation_url: The url of the external tool for account navigation
        :param bool account_navigation_enabled: Set this to enable this feature
        :param str account_navigation_text: The text that will show on the left-tab in the account navigation
        :param str user_navigation_url: The url of the external tool for user navigation
        :param bool user_navigation_enabled: Set this to enable this feature
        :param str user_navigation_text: The text that will show on the left-tab in the user navigation
        :param str course_navigation_url: The url of the external tool for course navigation
        :param bool course_navigation_enabled: Set this to enable this feature
        :param str course_navigation_text: The text that will show on the left-tab in the course navigation
        :param str course_navigation_visibility: Who will see the navigation tab. \"admins\" for course admins, \"members\" for students, null for everyone
        :param bool course_navigation_default: Whether the navigation option will show in the course by default or whether the teacher will have to explicitly enable it
        :param str editor_button_url: The url of the external tool
        :param bool editor_button_enabled: Set this to enable this feature
        :param str editor_button_icon_url: The url of the icon to show in the WYSIWYG editor
        :param str editor_button_selection_width: The width of the dialog the tool is launched in
        :param str editor_button_selection_height: The height of the dialog the tool is launched in
        :param str resource_selection_url: The url of the external tool
        :param bool resource_selection_enabled: Set this to enable this feature
        :param str resource_selection_icon_url: The url of the icon to show in the module external tool list
        :param str resource_selection_selection_width: The width of the dialog the tool is launched in
        :param str resource_selection_selection_height: The height of the dialog the tool is launched in
        :param str config_type: Configuration can be passed in as CC xml instead of using query parameters. If this value is \"by_url\" or \"by_xml\" then an xml configuration will be expected in either the \"config_xml\" or \"config_url\" parameter. Note that the name parameter overrides the tool name provided in the xml
        :param str config_xml: XML tool configuration, as specified in the CC xml specification. This is required if \"config_type\" is set to \"by_xml\"
        :param str config_url: URL where the server can retrieve an XML tool configuration, as specified in the CC xml specification. This is required if \"config_type\" is set to \"by_url\"
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'name', 'privacy_level', 'consumer_key', 'shared_secret', 'description', 'url', 'domain', 'icon_url', 'text', 'not_selectable', 'custom_fields', 'account_navigation_url', 'account_navigation_enabled', 'account_navigation_text', 'user_navigation_url', 'user_navigation_enabled', 'user_navigation_text', 'course_navigation_url', 'course_navigation_enabled', 'course_navigation_text', 'course_navigation_visibility', 'course_navigation_default', 'editor_button_url', 'editor_button_enabled', 'editor_button_icon_url', 'editor_button_selection_width', 'editor_button_selection_height', 'resource_selection_url', 'resource_selection_enabled', 'resource_selection_icon_url', 'resource_selection_selection_width', 'resource_selection_selection_height', 'config_type', 'config_xml', 'config_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_tool_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_external_tool_accounts`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_external_tool_accounts`")
        # verify the required parameter 'privacy_level' is set
        if ('privacy_level' not in params) or (params['privacy_level'] is None):
            raise ValueError("Missing the required parameter `privacy_level` when calling `create_external_tool_accounts`")
        # verify the required parameter 'consumer_key' is set
        if ('consumer_key' not in params) or (params['consumer_key'] is None):
            raise ValueError("Missing the required parameter `consumer_key` when calling `create_external_tool_accounts`")
        # verify the required parameter 'shared_secret' is set
        if ('shared_secret' not in params) or (params['shared_secret'] is None):
            raise ValueError("Missing the required parameter `shared_secret` when calling `create_external_tool_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'privacy_level' in params:
            form_params.append(('privacy_level', params['privacy_level']))
        if 'consumer_key' in params:
            form_params.append(('consumer_key', params['consumer_key']))
        if 'shared_secret' in params:
            form_params.append(('shared_secret', params['shared_secret']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'url' in params:
            form_params.append(('url', params['url']))
        if 'domain' in params:
            form_params.append(('domain', params['domain']))
        if 'icon_url' in params:
            form_params.append(('icon_url', params['icon_url']))
        if 'text' in params:
            form_params.append(('text', params['text']))
        if 'not_selectable' in params:
            form_params.append(('not_selectable', params['not_selectable']))
        if 'custom_fields' in params:
            form_params.append(('custom_fields', params['custom_fields']))
        if 'account_navigation_url' in params:
            form_params.append(('account_navigation[url]', params['account_navigation_url']))
        if 'account_navigation_enabled' in params:
            form_params.append(('account_navigation[enabled]', params['account_navigation_enabled']))
        if 'account_navigation_text' in params:
            form_params.append(('account_navigation[text]', params['account_navigation_text']))
        if 'user_navigation_url' in params:
            form_params.append(('user_navigation[url]', params['user_navigation_url']))
        if 'user_navigation_enabled' in params:
            form_params.append(('user_navigation[enabled]', params['user_navigation_enabled']))
        if 'user_navigation_text' in params:
            form_params.append(('user_navigation[text]', params['user_navigation_text']))
        if 'course_navigation_url' in params:
            form_params.append(('course_navigation[url]', params['course_navigation_url']))
        if 'course_navigation_enabled' in params:
            form_params.append(('course_navigation[enabled]', params['course_navigation_enabled']))
        if 'course_navigation_text' in params:
            form_params.append(('course_navigation[text]', params['course_navigation_text']))
        if 'course_navigation_visibility' in params:
            form_params.append(('course_navigation[visibility]', params['course_navigation_visibility']))
        if 'course_navigation_default' in params:
            form_params.append(('course_navigation[default]', params['course_navigation_default']))
        if 'editor_button_url' in params:
            form_params.append(('editor_button[url]', params['editor_button_url']))
        if 'editor_button_enabled' in params:
            form_params.append(('editor_button[enabled]', params['editor_button_enabled']))
        if 'editor_button_icon_url' in params:
            form_params.append(('editor_button[icon_url]', params['editor_button_icon_url']))
        if 'editor_button_selection_width' in params:
            form_params.append(('editor_button[selection_width]', params['editor_button_selection_width']))
        if 'editor_button_selection_height' in params:
            form_params.append(('editor_button[selection_height]', params['editor_button_selection_height']))
        if 'resource_selection_url' in params:
            form_params.append(('resource_selection[url]', params['resource_selection_url']))
        if 'resource_selection_enabled' in params:
            form_params.append(('resource_selection[enabled]', params['resource_selection_enabled']))
        if 'resource_selection_icon_url' in params:
            form_params.append(('resource_selection[icon_url]', params['resource_selection_icon_url']))
        if 'resource_selection_selection_width' in params:
            form_params.append(('resource_selection[selection_width]', params['resource_selection_selection_width']))
        if 'resource_selection_selection_height' in params:
            form_params.append(('resource_selection[selection_height]', params['resource_selection_selection_height']))
        if 'config_type' in params:
            form_params.append(('config_type', params['config_type']))
        if 'config_xml' in params:
            form_params.append(('config_xml', params['config_xml']))
        if 'config_url' in params:
            form_params.append(('config_url', params['config_url']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_external_tool_courses
    def create_external_tool_courses(self, course_id, name, privacy_level, consumer_key, shared_secret, **kwargs):
        """
        Create an external tool
        Create an external tool in the specified course/account. The created tool will be returned, see the \"show\" endpoint for an example.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_external_tool_courses_with_http_info(course_id, name, privacy_level, consumer_key, shared_secret, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str name: The name of the tool (required)
        :param str privacy_level: What information to send to the external tool. (required)
        :param str consumer_key: The consumer key for the external tool (required)
        :param str shared_secret: The shared secret with the external tool (required)
        :param str description: A description of the tool
        :param str url: The url to match links against. Either \"url\" or \"domain\" should be set, not both.
        :param str domain: The domain to match links against. Either \"url\" or \"domain\" should be set, not both.
        :param str icon_url: The url of the icon to show for this tool
        :param str text: The default text to show for this tool
        :param bool not_selectable: Default: false, if set to true the tool won't show up in the external tool selection UI in modules and assignments
        :param str custom_fields: Custom fields that will be sent to the tool consumer, specified as custom_fields[field_name]
        :param str account_navigation_url: The url of the external tool for account navigation
        :param bool account_navigation_enabled: Set this to enable this feature
        :param str account_navigation_text: The text that will show on the left-tab in the account navigation
        :param str user_navigation_url: The url of the external tool for user navigation
        :param bool user_navigation_enabled: Set this to enable this feature
        :param str user_navigation_text: The text that will show on the left-tab in the user navigation
        :param str course_navigation_url: The url of the external tool for course navigation
        :param bool course_navigation_enabled: Set this to enable this feature
        :param str course_navigation_text: The text that will show on the left-tab in the course navigation
        :param str course_navigation_visibility: Who will see the navigation tab. \"admins\" for course admins, \"members\" for students, null for everyone
        :param bool course_navigation_default: Whether the navigation option will show in the course by default or whether the teacher will have to explicitly enable it
        :param str editor_button_url: The url of the external tool
        :param bool editor_button_enabled: Set this to enable this feature
        :param str editor_button_icon_url: The url of the icon to show in the WYSIWYG editor
        :param str editor_button_selection_width: The width of the dialog the tool is launched in
        :param str editor_button_selection_height: The height of the dialog the tool is launched in
        :param str resource_selection_url: The url of the external tool
        :param bool resource_selection_enabled: Set this to enable this feature
        :param str resource_selection_icon_url: The url of the icon to show in the module external tool list
        :param str resource_selection_selection_width: The width of the dialog the tool is launched in
        :param str resource_selection_selection_height: The height of the dialog the tool is launched in
        :param str config_type: Configuration can be passed in as CC xml instead of using query parameters. If this value is \"by_url\" or \"by_xml\" then an xml configuration will be expected in either the \"config_xml\" or \"config_url\" parameter. Note that the name parameter overrides the tool name provided in the xml
        :param str config_xml: XML tool configuration, as specified in the CC xml specification. This is required if \"config_type\" is set to \"by_xml\"
        :param str config_url: URL where the server can retrieve an XML tool configuration, as specified in the CC xml specification. This is required if \"config_type\" is set to \"by_url\"
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'name', 'privacy_level', 'consumer_key', 'shared_secret', 'description', 'url', 'domain', 'icon_url', 'text', 'not_selectable', 'custom_fields', 'account_navigation_url', 'account_navigation_enabled', 'account_navigation_text', 'user_navigation_url', 'user_navigation_enabled', 'user_navigation_text', 'course_navigation_url', 'course_navigation_enabled', 'course_navigation_text', 'course_navigation_visibility', 'course_navigation_default', 'editor_button_url', 'editor_button_enabled', 'editor_button_icon_url', 'editor_button_selection_width', 'editor_button_selection_height', 'resource_selection_url', 'resource_selection_enabled', 'resource_selection_icon_url', 'resource_selection_selection_width', 'resource_selection_selection_height', 'config_type', 'config_xml', 'config_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_tool_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_external_tool_courses`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_external_tool_courses`")
        # verify the required parameter 'privacy_level' is set
        if ('privacy_level' not in params) or (params['privacy_level'] is None):
            raise ValueError("Missing the required parameter `privacy_level` when calling `create_external_tool_courses`")
        # verify the required parameter 'consumer_key' is set
        if ('consumer_key' not in params) or (params['consumer_key'] is None):
            raise ValueError("Missing the required parameter `consumer_key` when calling `create_external_tool_courses`")
        # verify the required parameter 'shared_secret' is set
        if ('shared_secret' not in params) or (params['shared_secret'] is None):
            raise ValueError("Missing the required parameter `shared_secret` when calling `create_external_tool_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'privacy_level' in params:
            form_params.append(('privacy_level', params['privacy_level']))
        if 'consumer_key' in params:
            form_params.append(('consumer_key', params['consumer_key']))
        if 'shared_secret' in params:
            form_params.append(('shared_secret', params['shared_secret']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'url' in params:
            form_params.append(('url', params['url']))
        if 'domain' in params:
            form_params.append(('domain', params['domain']))
        if 'icon_url' in params:
            form_params.append(('icon_url', params['icon_url']))
        if 'text' in params:
            form_params.append(('text', params['text']))
        if 'not_selectable' in params:
            form_params.append(('not_selectable', params['not_selectable']))
        if 'custom_fields' in params:
            form_params.append(('custom_fields', params['custom_fields']))
        if 'account_navigation_url' in params:
            form_params.append(('account_navigation[url]', params['account_navigation_url']))
        if 'account_navigation_enabled' in params:
            form_params.append(('account_navigation[enabled]', params['account_navigation_enabled']))
        if 'account_navigation_text' in params:
            form_params.append(('account_navigation[text]', params['account_navigation_text']))
        if 'user_navigation_url' in params:
            form_params.append(('user_navigation[url]', params['user_navigation_url']))
        if 'user_navigation_enabled' in params:
            form_params.append(('user_navigation[enabled]', params['user_navigation_enabled']))
        if 'user_navigation_text' in params:
            form_params.append(('user_navigation[text]', params['user_navigation_text']))
        if 'course_navigation_url' in params:
            form_params.append(('course_navigation[url]', params['course_navigation_url']))
        if 'course_navigation_enabled' in params:
            form_params.append(('course_navigation[enabled]', params['course_navigation_enabled']))
        if 'course_navigation_text' in params:
            form_params.append(('course_navigation[text]', params['course_navigation_text']))
        if 'course_navigation_visibility' in params:
            form_params.append(('course_navigation[visibility]', params['course_navigation_visibility']))
        if 'course_navigation_default' in params:
            form_params.append(('course_navigation[default]', params['course_navigation_default']))
        if 'editor_button_url' in params:
            form_params.append(('editor_button[url]', params['editor_button_url']))
        if 'editor_button_enabled' in params:
            form_params.append(('editor_button[enabled]', params['editor_button_enabled']))
        if 'editor_button_icon_url' in params:
            form_params.append(('editor_button[icon_url]', params['editor_button_icon_url']))
        if 'editor_button_selection_width' in params:
            form_params.append(('editor_button[selection_width]', params['editor_button_selection_width']))
        if 'editor_button_selection_height' in params:
            form_params.append(('editor_button[selection_height]', params['editor_button_selection_height']))
        if 'resource_selection_url' in params:
            form_params.append(('resource_selection[url]', params['resource_selection_url']))
        if 'resource_selection_enabled' in params:
            form_params.append(('resource_selection[enabled]', params['resource_selection_enabled']))
        if 'resource_selection_icon_url' in params:
            form_params.append(('resource_selection[icon_url]', params['resource_selection_icon_url']))
        if 'resource_selection_selection_width' in params:
            form_params.append(('resource_selection[selection_width]', params['resource_selection_selection_width']))
        if 'resource_selection_selection_height' in params:
            form_params.append(('resource_selection[selection_height]', params['resource_selection_selection_height']))
        if 'config_type' in params:
            form_params.append(('config_type', params['config_type']))
        if 'config_xml' in params:
            form_params.append(('config_xml', params['config_xml']))
        if 'config_url' in params:
            form_params.append(('config_url', params['config_url']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_external_tool_accounts
    def delete_external_tool_accounts(self, account_id, external_tool_id, **kwargs):
        """
        Delete an external tool
        Remove the specified external tool

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_external_tool_accounts_with_http_info(account_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_tool_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_external_tool_accounts`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `delete_external_tool_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_external_tool_courses
    def delete_external_tool_courses(self, course_id, external_tool_id, **kwargs):
        """
        Delete an external tool
        Remove the specified external tool

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_external_tool_courses_with_http_info(course_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_tool_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_external_tool_courses`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `delete_external_tool_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: edit_external_tool_accounts
    def edit_external_tool_accounts(self, account_id, external_tool_id, **kwargs):
        """
        Edit an external tool
        Update the specified external tool. Uses same parameters as create

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_external_tool_accounts_with_http_info(account_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_external_tool_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `edit_external_tool_accounts`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `edit_external_tool_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: edit_external_tool_courses
    def edit_external_tool_courses(self, course_id, external_tool_id, **kwargs):
        """
        Edit an external tool
        Update the specified external tool. Uses same parameters as create

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_external_tool_courses_with_http_info(course_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_external_tool_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `edit_external_tool_courses`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `edit_external_tool_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_sessionless_launch_url_for_external_tool_accounts
    def get_sessionless_launch_url_for_external_tool_accounts(self, account_id, **kwargs):
        """
        Get a sessionless launch url for an external tool.
        Returns a sessionless launch url for an external tool.  Either the id or url must be provided.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sessionless_launch_url_for_external_tool_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: The external id of the tool to launch.
        :param str url: The LTI launch url for the external tool.
        :param str assignment_id: The assignment id for an assignment launch.
        :param str launch_type: The type of launch to perform on the external tool.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'url', 'assignment_id', 'launch_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sessionless_launch_url_for_external_tool_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_sessionless_launch_url_for_external_tool_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools/sessionless_launch'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'url' in params:
            query_params['url'] = params['url']
        if 'assignment_id' in params:
            query_params['assignment_id'] = params['assignment_id']
        if 'launch_type' in params:
            query_params['launch_type'] = params['launch_type']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_sessionless_launch_url_for_external_tool_courses
    def get_sessionless_launch_url_for_external_tool_courses(self, course_id, **kwargs):
        """
        Get a sessionless launch url for an external tool.
        Returns a sessionless launch url for an external tool.  Either the id or url must be provided.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_sessionless_launch_url_for_external_tool_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: The external id of the tool to launch.
        :param str url: The LTI launch url for the external tool.
        :param str assignment_id: The assignment id for an assignment launch.
        :param str launch_type: The type of launch to perform on the external tool.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'url', 'assignment_id', 'launch_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sessionless_launch_url_for_external_tool_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_sessionless_launch_url_for_external_tool_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools/sessionless_launch'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'url' in params:
            query_params['url'] = params['url']
        if 'assignment_id' in params:
            query_params['assignment_id'] = params['assignment_id']
        if 'launch_type' in params:
            query_params['launch_type'] = params['launch_type']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_external_tool_accounts
    def get_single_external_tool_accounts(self, account_id, external_tool_id, **kwargs):
        """
        Get a single external tool
        Returns the specified external tool.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_external_tool_accounts_with_http_info(account_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_external_tool_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_single_external_tool_accounts`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `get_single_external_tool_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_external_tool_courses
    def get_single_external_tool_courses(self, course_id, external_tool_id, **kwargs):
        """
        Get a single external tool
        Returns the specified external tool.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_external_tool_courses_with_http_info(course_id, external_tool_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str external_tool_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'external_tool_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_external_tool_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_external_tool_courses`")
        # verify the required parameter 'external_tool_id' is set
        if ('external_tool_id' not in params) or (params['external_tool_id'] is None):
            raise ValueError("Missing the required parameter `external_tool_id` when calling `get_single_external_tool_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools/{external_tool_id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'external_tool_id' in params:
            path_params['external_tool_id'] = params['external_tool_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_external_tools_accounts
    def list_external_tools_accounts(self, account_id, **kwargs):
        """
        List external tools
        Returns the paginated list of external tools for the current context. See the get request docs for a single tool for a list of properties on an external tool.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_external_tools_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str search_term: The partial name of the tools to match and return.
        :param bool selectable: If true, then only tools that are meant to be selectable are returned
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'search_term', 'selectable']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_external_tools_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_external_tools_accounts`")

        resource_path = '/v1/accounts/{account_id}/external_tools'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'selectable' in params:
            query_params['selectable'] = params['selectable']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_external_tools_courses
    def list_external_tools_courses(self, course_id, **kwargs):
        """
        List external tools
        Returns the paginated list of external tools for the current context. See the get request docs for a single tool for a list of properties on an external tool.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_external_tools_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str search_term: The partial name of the tools to match and return.
        :param bool selectable: If true, then only tools that are meant to be selectable are returned
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'search_term', 'selectable']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_external_tools_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_external_tools_courses`")

        resource_path = '/v1/courses/{course_id}/external_tools'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'selectable' in params:
            query_params['selectable'] = params['selectable']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
