# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ContentExport(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, created_at=None, export_type=None, attachment=None, progress_url=None, user_id=None, workflow_state=None):
        """
        ContentExport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'created_at': 'Datetime',
            'export_type': 'str',
            'attachment': 'File',
            'progress_url': 'str',
            'user_id': 'int',
            'workflow_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'created_at': 'created_at',
            'export_type': 'export_type',
            'attachment': 'attachment',
            'progress_url': 'progress_url',
            'user_id': 'user_id',
            'workflow_state': 'workflow_state'
        }

        self._id = id
        self._created_at = created_at
        self._export_type = export_type
        self._attachment = attachment
        self._progress_url = progress_url
        self._user_id = user_id
        self._workflow_state = workflow_state

    @property
    def id(self):
        """
        Gets the id of this ContentExport.
        the unique identifier for the export

        :return: The id of this ContentExport.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ContentExport.
        the unique identifier for the export

        :param id: The id of this ContentExport.
        :type: int
        """

        self._id = id

    @property
    def created_at(self):
        """
        Gets the created_at of this ContentExport.
        the date and time this export was requested

        :return: The created_at of this ContentExport.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this ContentExport.
        the date and time this export was requested

        :param created_at: The created_at of this ContentExport.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def export_type(self):
        """
        Gets the export_type of this ContentExport.
        the type of content migration: 'common_cartridge' or 'qti'

        :return: The export_type of this ContentExport.
        :rtype: str
        """
        return self._export_type

    @export_type.setter
    def export_type(self, export_type):
        """
        Sets the export_type of this ContentExport.
        the type of content migration: 'common_cartridge' or 'qti'

        :param export_type: The export_type of this ContentExport.
        :type: str
        """

        self._export_type = export_type

    @property
    def attachment(self):
        """
        Gets the attachment of this ContentExport.
        attachment api object for the export package (not present until the export completes)

        :return: The attachment of this ContentExport.
        :rtype: File
        """
        return self._attachment

    @attachment.setter
    def attachment(self, attachment):
        """
        Sets the attachment of this ContentExport.
        attachment api object for the export package (not present until the export completes)

        :param attachment: The attachment of this ContentExport.
        :type: File
        """

        self._attachment = attachment

    @property
    def progress_url(self):
        """
        Gets the progress_url of this ContentExport.
        The api endpoint for polling the current progress

        :return: The progress_url of this ContentExport.
        :rtype: str
        """
        return self._progress_url

    @progress_url.setter
    def progress_url(self, progress_url):
        """
        Sets the progress_url of this ContentExport.
        The api endpoint for polling the current progress

        :param progress_url: The progress_url of this ContentExport.
        :type: str
        """

        self._progress_url = progress_url

    @property
    def user_id(self):
        """
        Gets the user_id of this ContentExport.
        The ID of the user who started the export

        :return: The user_id of this ContentExport.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ContentExport.
        The ID of the user who started the export

        :param user_id: The user_id of this ContentExport.
        :type: int
        """

        self._user_id = user_id

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this ContentExport.
        Current state of the content migration: created exporting exported failed

        :return: The workflow_state of this ContentExport.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this ContentExport.
        Current state of the content migration: created exporting exported failed

        :param workflow_state: The workflow_state of this ContentExport.
        :type: str
        """

        self._workflow_state = workflow_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
