# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class AssignmentEvent(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, title=None, start_at=None, end_at=None, description=None, context_code=None, workflow_state=None, url=None, html_url=None, all_day_date=None, all_day=None, created_at=None, updated_at=None, assignment=None):
        """
        AssignmentEvent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'description': 'str',
            'context_code': 'str',
            'workflow_state': 'str',
            'url': 'str',
            'html_url': 'str',
            'all_day_date': 'Datetime',
            'all_day': 'bool',
            'created_at': 'Datetime',
            'updated_at': 'Datetime',
            'assignment': 'Assignment'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'description': 'description',
            'context_code': 'context_code',
            'workflow_state': 'workflow_state',
            'url': 'url',
            'html_url': 'html_url',
            'all_day_date': 'all_day_date',
            'all_day': 'all_day',
            'created_at': 'created_at',
            'updated_at': 'updated_at',
            'assignment': 'assignment'
        }

        self._id = id
        self._title = title
        self._start_at = start_at
        self._end_at = end_at
        self._description = description
        self._context_code = context_code
        self._workflow_state = workflow_state
        self._url = url
        self._html_url = html_url
        self._all_day_date = all_day_date
        self._all_day = all_day
        self._created_at = created_at
        self._updated_at = updated_at
        self._assignment = assignment

    @property
    def id(self):
        """
        Gets the id of this AssignmentEvent.
        A synthetic ID for the assignment

        :return: The id of this AssignmentEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AssignmentEvent.
        A synthetic ID for the assignment

        :param id: The id of this AssignmentEvent.
        :type: str
        """

        self._id = id

    @property
    def title(self):
        """
        Gets the title of this AssignmentEvent.
        The title of the assignment

        :return: The title of this AssignmentEvent.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this AssignmentEvent.
        The title of the assignment

        :param title: The title of this AssignmentEvent.
        :type: str
        """

        self._title = title

    @property
    def start_at(self):
        """
        Gets the start_at of this AssignmentEvent.
        The due_at timestamp of the assignment

        :return: The start_at of this AssignmentEvent.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this AssignmentEvent.
        The due_at timestamp of the assignment

        :param start_at: The start_at of this AssignmentEvent.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this AssignmentEvent.
        The due_at timestamp of the assignment

        :return: The end_at of this AssignmentEvent.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this AssignmentEvent.
        The due_at timestamp of the assignment

        :param end_at: The end_at of this AssignmentEvent.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def description(self):
        """
        Gets the description of this AssignmentEvent.
        The HTML description of the assignment

        :return: The description of this AssignmentEvent.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AssignmentEvent.
        The HTML description of the assignment

        :param description: The description of this AssignmentEvent.
        :type: str
        """

        self._description = description

    @property
    def context_code(self):
        """
        Gets the context_code of this AssignmentEvent.
        the context code of the (course) calendar this assignment belongs to

        :return: The context_code of this AssignmentEvent.
        :rtype: str
        """
        return self._context_code

    @context_code.setter
    def context_code(self, context_code):
        """
        Sets the context_code of this AssignmentEvent.
        the context code of the (course) calendar this assignment belongs to

        :param context_code: The context_code of this AssignmentEvent.
        :type: str
        """

        self._context_code = context_code

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this AssignmentEvent.
        Current state of the assignment ('published' or 'deleted')

        :return: The workflow_state of this AssignmentEvent.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this AssignmentEvent.
        Current state of the assignment ('published' or 'deleted')

        :param workflow_state: The workflow_state of this AssignmentEvent.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def url(self):
        """
        Gets the url of this AssignmentEvent.
        URL for this assignment (note that updating/deleting should be done via the Assignments API)

        :return: The url of this AssignmentEvent.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this AssignmentEvent.
        URL for this assignment (note that updating/deleting should be done via the Assignments API)

        :param url: The url of this AssignmentEvent.
        :type: str
        """

        self._url = url

    @property
    def html_url(self):
        """
        Gets the html_url of this AssignmentEvent.
        URL for a user to view this assignment

        :return: The html_url of this AssignmentEvent.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this AssignmentEvent.
        URL for a user to view this assignment

        :param html_url: The html_url of this AssignmentEvent.
        :type: str
        """

        self._html_url = html_url

    @property
    def all_day_date(self):
        """
        Gets the all_day_date of this AssignmentEvent.
        The due date of this assignment

        :return: The all_day_date of this AssignmentEvent.
        :rtype: Datetime
        """
        return self._all_day_date

    @all_day_date.setter
    def all_day_date(self, all_day_date):
        """
        Sets the all_day_date of this AssignmentEvent.
        The due date of this assignment

        :param all_day_date: The all_day_date of this AssignmentEvent.
        :type: Datetime
        """

        self._all_day_date = all_day_date

    @property
    def all_day(self):
        """
        Gets the all_day of this AssignmentEvent.
        Boolean indicating whether this is an all-day event (e.g. assignment due at midnight)

        :return: The all_day of this AssignmentEvent.
        :rtype: bool
        """
        return self._all_day

    @all_day.setter
    def all_day(self, all_day):
        """
        Sets the all_day of this AssignmentEvent.
        Boolean indicating whether this is an all-day event (e.g. assignment due at midnight)

        :param all_day: The all_day of this AssignmentEvent.
        :type: bool
        """

        self._all_day = all_day

    @property
    def created_at(self):
        """
        Gets the created_at of this AssignmentEvent.
        When the assignment was created

        :return: The created_at of this AssignmentEvent.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this AssignmentEvent.
        When the assignment was created

        :param created_at: The created_at of this AssignmentEvent.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this AssignmentEvent.
        When the assignment was last updated

        :return: The updated_at of this AssignmentEvent.
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this AssignmentEvent.
        When the assignment was last updated

        :param updated_at: The updated_at of this AssignmentEvent.
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def assignment(self):
        """
        Gets the assignment of this AssignmentEvent.
        The full assignment JSON data (See the Assignments API)

        :return: The assignment of this AssignmentEvent.
        :rtype: Assignment
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """
        Sets the assignment of this AssignmentEvent.
        The full assignment JSON data (See the Assignments API)

        :param assignment: The assignment of this AssignmentEvent.
        :type: Assignment
        """

        self._assignment = assignment

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
