# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Report(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, report=None, file_url=None, status=None, parameters=None, progress=None):
        """
        Report - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'report': 'str',
            'file_url': 'str',
            'status': 'str',
            'parameters': 'ReportParameters',
            'progress': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'report': 'report',
            'file_url': 'file_url',
            'status': 'status',
            'parameters': 'parameters',
            'progress': 'progress'
        }

        self._id = id
        self._report = report
        self._file_url = file_url
        self._status = status
        self._parameters = parameters
        self._progress = progress

    @property
    def id(self):
        """
        Gets the id of this Report.
        The unique identifier for the report.

        :return: The id of this Report.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Report.
        The unique identifier for the report.

        :param id: The id of this Report.
        :type: int
        """

        self._id = id

    @property
    def report(self):
        """
        Gets the report of this Report.
        The type of report.

        :return: The report of this Report.
        :rtype: str
        """
        return self._report

    @report.setter
    def report(self, report):
        """
        Sets the report of this Report.
        The type of report.

        :param report: The report of this Report.
        :type: str
        """

        self._report = report

    @property
    def file_url(self):
        """
        Gets the file_url of this Report.
        The url to the report download.

        :return: The file_url of this Report.
        :rtype: str
        """
        return self._file_url

    @file_url.setter
    def file_url(self, file_url):
        """
        Sets the file_url of this Report.
        The url to the report download.

        :param file_url: The file_url of this Report.
        :type: str
        """

        self._file_url = file_url

    @property
    def status(self):
        """
        Gets the status of this Report.
        The status of the report

        :return: The status of this Report.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this Report.
        The status of the report

        :param status: The status of this Report.
        :type: str
        """

        self._status = status

    @property
    def parameters(self):
        """
        Gets the parameters of this Report.
        The report parameters

        :return: The parameters of this Report.
        :rtype: ReportParameters
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this Report.
        The report parameters

        :param parameters: The parameters of this Report.
        :type: ReportParameters
        """

        self._parameters = parameters

    @property
    def progress(self):
        """
        Gets the progress of this Report.
        The progress of the report

        :return: The progress of this Report.
        :rtype: str
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this Report.
        The progress of the report

        :param progress: The progress of this Report.
        :type: str
        """

        self._progress = progress

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
