# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class AccountNotification(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, subject=None, message=None, start_at=None, end_at=None, icon=None, roles=None, role_ids=None):
        """
        AccountNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'subject': 'str',
            'message': 'str',
            'start_at': 'Datetime',
            'end_at': 'Datetime',
            'icon': 'list[str]',
            'roles': 'list[str]',
            'role_ids': 'list[int]'
        }

        self.attribute_map = {
            'subject': 'subject',
            'message': 'message',
            'start_at': 'start_at',
            'end_at': 'end_at',
            'icon': 'icon',
            'roles': 'roles',
            'role_ids': 'role_ids'
        }

        self._subject = subject
        self._message = message
        self._start_at = start_at
        self._end_at = end_at
        self._icon = icon
        self._roles = roles
        self._role_ids = role_ids

    @property
    def subject(self):
        """
        Gets the subject of this AccountNotification.
        The subject of the notifications

        :return: The subject of this AccountNotification.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this AccountNotification.
        The subject of the notifications

        :param subject: The subject of this AccountNotification.
        :type: str
        """

        self._subject = subject

    @property
    def message(self):
        """
        Gets the message of this AccountNotification.
        The message to be sent in the notification.

        :return: The message of this AccountNotification.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this AccountNotification.
        The message to be sent in the notification.

        :param message: The message of this AccountNotification.
        :type: str
        """

        self._message = message

    @property
    def start_at(self):
        """
        Gets the start_at of this AccountNotification.
        When to send out the notification.

        :return: The start_at of this AccountNotification.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this AccountNotification.
        When to send out the notification.

        :param start_at: The start_at of this AccountNotification.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def end_at(self):
        """
        Gets the end_at of this AccountNotification.
        When to expire the notification.

        :return: The end_at of this AccountNotification.
        :rtype: Datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this AccountNotification.
        When to expire the notification.

        :param end_at: The end_at of this AccountNotification.
        :type: Datetime
        """

        self._end_at = end_at

    @property
    def icon(self):
        """
        Gets the icon of this AccountNotification.
        The icon to display with the message.  Defaults to warning.

        :return: The icon of this AccountNotification.
        :rtype: list[str]
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """
        Sets the icon of this AccountNotification.
        The icon to display with the message.  Defaults to warning.

        :param icon: The icon of this AccountNotification.
        :type: list[str]
        """

        self._icon = icon

    @property
    def roles(self):
        """
        Gets the roles of this AccountNotification.
        (Deprecated) The roles to send the notification to.  If roles is not passed it defaults to all roles

        :return: The roles of this AccountNotification.
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """
        Sets the roles of this AccountNotification.
        (Deprecated) The roles to send the notification to.  If roles is not passed it defaults to all roles

        :param roles: The roles of this AccountNotification.
        :type: list[str]
        """

        self._roles = roles

    @property
    def role_ids(self):
        """
        Gets the role_ids of this AccountNotification.
        The roles to send the notification to.  If roles is not passed it defaults to all roles

        :return: The role_ids of this AccountNotification.
        :rtype: list[int]
        """
        return self._role_ids

    @role_ids.setter
    def role_ids(self, role_ids):
        """
        Sets the role_ids of this AccountNotification.
        The roles to send the notification to.  If roles is not passed it defaults to all roles

        :param role_ids: The role_ids of this AccountNotification.
        :type: list[int]
        """

        self._role_ids = role_ids

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
