<%!
    from datetime import datetime, date, timedelta
    import re

    from time import time

    import sickrage
    from core.updaters import tz_updater
    from core.tv.show import TVShow
    from core.helpers import pretty_filesize

    # resource module is unix only
    has_resource_module = True
    try:
        import resource
    except ImportError:
        has_resource_module = False
%>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="robots" content="noindex, nofollow">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width">

        <!-- These values come from css/dark.css and css/light.css -->
        % if sickrage.srConfig.THEME_NAME == "dark":
        <meta name="theme-color" content="#15528F">
        % elif sickrage.srConfig.THEME_NAME == "light":
        <meta name="theme-color" content="#333333">
        % endif

        <title>SickRage - BRANCH:[${sickrage.srCore.VERSION}] - ${title}</title>

        <!--[if lt IE 9]>
            <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
            <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
        <meta name="msapplication-TileColor" content="#FFFFFF">
        <meta name="msapplication-TileImage" content="${srRoot}/images/ico/favicon-144.png">
        <meta name="msapplication-config" content="${srRoot}/css/browserconfig.xml">


        <meta data-var="srRoot" data-content="${srRoot}">
        <meta data-var="themeSpinner" data-content="${('', '-dark')[sickrage.srConfig.THEME_NAME == 'dark']}">
        <meta data-var="anonURL" data-content="${sickrage.srConfig.ANON_REDIRECT}">

        <meta data-var="sickrage.ANIME_SPLIT_HOME" data-content="${sickrage.srConfig.ANIME_SPLIT_HOME}">
        <meta data-var="sickrage.COMING_EPS_LAYOUT" data-content="${sickrage.srConfig.COMING_EPS_LAYOUT}">
        <meta data-var="sickrage.COMING_EPS_SORT" data-content="${sickrage.srConfig.COMING_EPS_SORT}">
        <meta data-var="sickrage.DATE_PRESET" data-content="${sickrage.srConfig.DATE_PRESET}">
        <meta data-var="sickrage.FILTER_ROW" data-content="${sickrage.srConfig.FILTER_ROW}">
        <meta data-var="sickrage.FUZZY_DATING" data-content="${sickrage.srConfig.FUZZY_DATING}">
        <meta data-var="sickrage.HISTORY_LAYOUT" data-content="${sickrage.srConfig.HISTORY_LAYOUT}">
        <meta data-var="sickrage.HOME_LAYOUT" data-content="${sickrage.srConfig.HOME_LAYOUT}">
        <meta data-var="sickrage.POSTER_SORTBY" data-content="${sickrage.srConfig.POSTER_SORTBY}">
        <meta data-var="sickrage.POSTER_SORTDIR" data-content="${sickrage.srConfig.POSTER_SORTDIR}">
        <meta data-var="sickrage.ROOT_DIRS" data-content="${sickrage.srConfig.ROOT_DIRS}">
        <meta data-var="sickrage.SORT_ARTICLE" data-content="${sickrage.srConfig.SORT_ARTICLE}">
        <meta data-var="sickrage.TIME_PRESET" data-content="${sickrage.srConfig.TIME_PRESET}">
        <meta data-var="sickrage.TRIM_ZERO" data-content="${sickrage.srConfig.TRIM_ZERO}">
        <%block name="metas" />

        <link rel="shortcut icon" href="${srRoot}/images/ico/favicon.ico">
        <link rel="icon" sizes="16x16 32x32 64x64" href="${srRoot}/images/ico/favicon.ico">
        <link rel="icon" type="image/png" sizes="196x196" href="${srRoot}/images/ico/favicon-196.png">
        <link rel="icon" type="image/png" sizes="160x160" href="${srRoot}/images/ico/favicon-160.png">
        <link rel="icon" type="image/png" sizes="96x96" href="${srRoot}/images/ico/favicon-96.png">
        <link rel="icon" type="image/png" sizes="64x64" href="${srRoot}/images/ico/favicon-64.png">
        <link rel="icon" type="image/png" sizes="32x32" href="${srRoot}/images/ico/favicon-32.png">
        <link rel="icon" type="image/png" sizes="16x16" href="${srRoot}/images/ico/favicon-16.png">
        <link rel="apple-touch-icon" sizes="152x152" href="${srRoot}/images/ico/favicon-152.png">
        <link rel="apple-touch-icon" sizes="144x144" href="${srRoot}/images/ico/favicon-144.png">
        <link rel="apple-touch-icon" sizes="120x120" href="${srRoot}/images/ico/favicon-120.png">
        <link rel="apple-touch-icon" sizes="114x114" href="${srRoot}/images/ico/favicon-114.png">
        <link rel="apple-touch-icon" sizes="76x76" href="${srRoot}/images/ico/favicon-76.png">
        <link rel="apple-touch-icon" sizes="72x72" href="${srRoot}/images/ico/favicon-72.png">
        <link rel="apple-touch-icon" href="${srRoot}/images/ico/favicon-57.png">

        <link rel="stylesheet" type="text/css" href="${srRoot}/css/lib/bootstrap.min.css?${srPID}"/>
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/browser.css?${srPID}" />
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/lib/jquery-ui-1.10.4.custom.min.css?${srPID}" />
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/lib/jquery.qtip-2.2.1.min.css?${srPID}"/>
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/style.css?${srPID}"/>
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/${sickrage.srConfig.THEME_NAME}.css?${srPID}"/>
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/print.css?${srPID}" />
        % if current_user:
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/lib/pnotify.custom.min.css?${srPID}" />
        <link rel="stylesheet" type="text/css" href="${srRoot}/css/country-flags.css?${srPID}"/>
        % endif
        <%block name="css" />
    </head>
    <body>
        <nav class="navbar navbar-default navbar-fixed-top hidden-print" role="navigation">
            <div class="container-fluid">
                <span class="navbar-header">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="${srRoot}/home/" title="SiCKRAGE"><img alt="SiCKRAGE" src="${srRoot}/images/sickrage.png" style="height: 50px;" class="img-responsive pull-left" /></a>
                </span>
            % if current_user:
                <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                    <ul class="nav navbar-nav navbar-right">
                        <li id="NAVhome" class="navbar-split dropdown${('', ' active')[topmenu == 'home']}">
                            <a href="${srRoot}/home/" class="dropdown-toggle" aria-haspopup="true" data-toggle="dropdown" data-hover="dropdown"><span>Shows</span>
                            <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a href="${srRoot}/home/"><i class="menu-icon-home"></i>&nbsp;Show List</a></li>
                                <li><a href="${srRoot}/home/addShows/"><i class="menu-icon-addshow"></i>&nbsp;Add Shows</a></li>
                                <li><a href="${srRoot}/home/postprocess/"><i class="menu-icon-postprocess"></i>&nbsp;Manual Post-Processing</a></li>
                                % if sickrage.srConfig.SHOWS_RECENT:
                                    <li role="separator" class="divider"></li>
                                % for recentShow in sickrage.srConfig.SHOWS_RECENT:
                                        <li><a href="${srRoot}/home/displayShow/?show=${recentShow[b'indexerid']}"><i class="menu-icon-addshow"></i>&nbsp;${recentShow[b'name']|trim,h}</a></li>
                                    % endfor
                                % endif
                            </ul>
                            <div style="clear:both;"></div>
                        </li>

                        <li id="NAVschedule"${('', ' class="active"')[topmenu == 'schedule']}>
                            <a href="${srRoot}/schedule/">Schedule</a>
                        </li>

                        <li id="NAVhistory"${('', ' class="active"')[topmenu == 'history']}>
                            <a href="${srRoot}/history/">History</a>
                        </li>

                        <li id="NAVmanage" class="navbar-split dropdown${('', ' active')[topmenu == 'manage']}">
                            <a href="${srRoot}/manage/episodeStatuses/" class="dropdown-toggle" aria-haspopup="true" data-toggle="dropdown" data-hover="dropdown"><span>Manage</span>
                            <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a href="${srRoot}/manage/"><i class="menu-icon-manage"></i>&nbsp;Mass Update</a></li>
                                <li><a href="${srRoot}/manage/backlogOverview/"><i class="menu-icon-backlog-view"></i>&nbsp;Backlog Overview</a></li>
                                <li><a href="${srRoot}/manage/manageSearches/"><i class="menu-icon-manage-searches"></i>&nbsp;Manage Searches</a></li>
                                <li><a href="${srRoot}/manage/episodeStatuses/"><i class="menu-icon-backlog"></i>&nbsp;Episode Status Management</a></li>
                                % if sickrage.srConfig.USE_PLEX and sickrage.srConfig.PLEX_SERVER_HOST != "":
                                <li><a href="${srRoot}/home/updatePLEX/"><i class="menu-icon-backlog-view"></i>&nbsp;Update PLEX</a></li>
                            % endif
                                % if sickrage.srConfig.USE_KODI and sickrage.srConfig.KODI_HOST != "":
                                <li><a href="${srRoot}/home/updateKODI/"><i class="menu-icon-kodi"></i>&nbsp;Update KODI</a></li>
                            % endif
                                % if sickrage.srConfig.USE_EMBY and sickrage.srConfig.EMBY_HOST != "" and sickrage.srConfig.EMBY_APIKEY != "":
                                <li><a href="${srRoot}/home/updateEMBY/"><i class="menu-icon-backlog-view"></i>&nbsp;Update Emby</a></li>
                            % endif
                                % if sickrage.srConfig.USE_TORRENTS and sickrage.srConfig.TORRENT_METHOD != 'blackhole' and (sickrage.srConfig.ENABLE_HTTPS and sickrage.srConfig.TORRENT_HOST[:5] == 'https' or not sickrage.srConfig.ENABLE_HTTPS and sickrage.srConfig.TORRENT_HOST[:5] == 'http:'):
                                <li><a href="${srRoot}/manage/manageTorrents/"><i class="menu-icon-bittorrent"></i>&nbsp;Manage Torrents</a></li>
                            % endif
                                % if sickrage.srConfig.USE_FAILED_DOWNLOADS:
                                <li><a href="${srRoot}/manage/failedDownloads/"><i class="menu-icon-failed-download"></i>&nbsp;Failed Downloads</a></li>
                            % endif
                                % if sickrage.srConfig.USE_SUBTITLES:
                                <li><a href="${srRoot}/manage/subtitleMissed/"><i class="menu-icon-backlog"></i>&nbsp;Missed Subtitle Management</a></li>
                            % endif
                            </ul>
                            <div style="clear:both;"></div>
                        </li>

                        <li id="NAVconfig" class="navbar-split dropdown${('', ' active')[topmenu == 'config']}">
                            <a href="${srRoot}/config/" class="dropdown-toggle" aria-haspopup="true" data-toggle="dropdown" data-hover="dropdown"><span class="visible-xs-inline">Config</span><img src="${srRoot}/images/menu/system18.png" class="navbaricon hidden-xs" />
                            <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a href="${srRoot}/config/"><i class="menu-icon-help"></i>&nbsp;Help &amp; Info</a></li>
                                <li><a href="${srRoot}/config/general/"><i class="menu-icon-config"></i>&nbsp;General</a></li>
                                <li><a href="${srRoot}/config/backuprestore/"><i class="menu-icon-config"></i>&nbsp;Backup &amp; Restore</a></li>
                                <li><a href="${srRoot}/config/search/"><i class="menu-icon-config"></i>&nbsp;Search Settings</a></li>
                                <li><a href="${srRoot}/config/providers/"><i class="menu-icon-config"></i>&nbsp;Search Providers</a></li>
                                <li><a href="${srRoot}/config/subtitles/"><i class="menu-icon-config"></i>&nbsp;Subtitles Settings</a></li>
                                <li><a href="${srRoot}/config/postProcessing/"><i class="menu-icon-config"></i>&nbsp;Post Processing</a></li>
                                <li><a href="${srRoot}/config/notifications/"><i class="menu-icon-config"></i>&nbsp;Notifications</a></li>
                                <li><a href="${srRoot}/config/anime/"><i class="menu-icon-config"></i>&nbsp;Anime</a></li>
                            </ul>
                            <div style="clear:both;"></div>
                        </li>

                        <%
                            if sickrage.srConfig.NEWS_UNREAD:
                                newsBadge = ' <span class="badge">'+str(sickrage.srConfig.NEWS_UNREAD)+'</span>'
                            else:
                                newsBadge = ''

                            numCombined = numErrors + numWarnings + sickrage.srConfig.NEWS_UNREAD
                            if numCombined:
                                if numErrors:
                                    toolsBadgeClass = ' btn-danger'
                                elif numWarnings:
                                    toolsBadgeClass = ' btn-warning'
                                else:
                                    toolsBadgeClass = ''

                                toolsBadge = ' <span class="badge'+toolsBadgeClass+'">'+str(numCombined)+'</span>'
                            else:
                                toolsBadge = ''
                        %>
                        <li id="NAVsystem" class="navbar-split dropdown${('', ' active')[topmenu == 'system']}">
                            <a href="${srRoot}/home/status/" class="dropdown-toggle" aria-haspopup="true" data-toggle="dropdown" data-hover="dropdown"><span class="visible-xs-inline">Tools</span><img src="${srRoot}/images/menu/system18-2.png" class="navbaricon hidden-xs" />${toolsBadge}
                            <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu">
                                <li><a href="${srRoot}/news/"><i class="menu-icon-help"></i>&nbsp;News${newsBadge}</a></li>
                                <li><a href="${srRoot}/IRC/"><i class="menu-icon-help"></i>&nbsp;IRC</a></li>
                                <li><a href="${srRoot}/changes/"><i class="menu-icon-help"></i>&nbsp;Changelog</a></li>
                                <li><a href="http://sickragetv.herokuapp.com/donate" rel="noreferrer"
                                       onclick="window.open('${sickrage.srConfig.ANON_REDIRECT}' + this.href); return false;"><i
                                        class="menu-icon-help"></i>&nbsp;Support SickRage</a></li>
                                <li role="separator" class="divider"></li>
                                %if numErrors:
                                    <li><a href="${srRoot}/errorlogs/"><i class="menu-icon-viewlog-errors"></i>&nbsp;View Errors <span class="badge btn-danger">${numErrors}</span></a></li>
                                %endif
                                %if numWarnings:
                                    <li><a href="${srRoot}/errorlogs/?level=${sickrage.srLogger.WARNING}"><i
                                            class="menu-icon-viewlog-errors"></i>&nbsp;View Warnings <span
                                            class="badge btn-warning">${numWarnings}</span></a></li>
                                %endif
                                <li><a href="${srRoot}/errorlogs/viewlog/"><i class="menu-icon-viewlog"></i>&nbsp;View Log</a></li>
                                <li role="separator" class="divider"></li>
                                <li><a href="${srRoot}/home/updateCheck?pid=${srPID}"><i class="menu-icon-update"></i>&nbsp;Check For Updates</a></li>
                                <li><a href="${srRoot}/home/restart/?pid=${srPID}" class="confirm restart"><i class="menu-icon-restart"></i>&nbsp;Restart</a></li>
                                <li><a href="${srRoot}/home/shutdown/?pid=${srPID}" class="confirm shutdown"><i class="menu-icon-shutdown"></i>&nbsp;Shutdown</a></li>
                                % if current_user != True:
                                    <li><a href="${srRoot}/logout" class="confirm logout"><i class="menu-icon-shutdown"></i>&nbsp;Logout</a></li>
                                % endif
                                <li role="separator" class="divider"></li>
                                <li><a href="${srRoot}/home/status/"><i class="menu-icon-help"></i>&nbsp;Server Status</a></li>
                            </ul>
                            <div style="clear:both;"></div>
                        </li>
                    </ul>
            % endif
                </div><!-- /.navbar-collapse -->
            </div><!-- /.container-fluid -->
        </nav>

        % if not submenu is UNDEFINED:
        <div id="SubMenu" class="hidden-print">
            <span>
            <% first = True %>
            % for menuItem in submenu:
                % if 'requires' not in menuItem or menuItem[b'requires']:
                    <% icon_class = '' if 'icon' not in menuItem else ' ' + menuItem[b'icon'] %>
                      % if type(menuItem[b'path']) == dict:
                          ${("</span><span>", "")[bool(first)]}<b>${menuItem[b'title']}</b>
                          <%
                              first = False
                              inner_first = True
                          %>
                          % for cur_link in menuItem[b'path']:
                              ${("&middot; ", "")[bool(inner_first)]}<a class="inner" href="${srRoot}/${menuItem[b'path'][cur_link]}">${cur_link}</a>
                              <% inner_first = False %>
                          % endfor
                      % else:
                          <a href="${srRoot}/${menuItem[b'path']}" class="btn${('', (' confirm ' + menuItem.get('class', '')))['confirm' in menuItem]}">${('', '<span class="pull-left ' + icon_class + '"></span> ')[bool(icon_class)]}${menuItem[b'title']}</a>
                          <% first = False %>
                      % endif
                % endif
            % endfor
            </span>
        </div>
        % endif

            % if sickrage.srCore.NEWEST_VERSION_STRING and current_user:
        <div class="alert alert-success upgrade-notification hidden-print" role="alert">
            <span>${sickrage.srCore.NEWEST_VERSION_STRING}</span>
        </div>
        % endif

        <div id="contentWrapper">
            <div id="content">
                <%block name="content" />
            </div> <!-- /content -->
        </div> <!-- /contentWrapper -->
    % if current_user:
        <footer>
            <div class="footer clearfix">
            <%
                stats = TVShow.overall_stats()
                ep_downloaded = stats[b'episodes'][b'downloaded']
                ep_snatched = stats[b'episodes'][b'snatched']
                ep_total = stats[b'episodes'][b'total']
                ep_percentage = '' if ep_total == 0 else '(<span class="footerhighlight">%s%%</span>)' % re.sub(r'(\d+)(\.\d)\d+', r'\1\2', str((float(ep_downloaded)/float(ep_total))*100))
            %>
                <span class="footerhighlight">${stats[b'shows'][b'total']}</span> Shows (<span class="footerhighlight">${stats[b'shows'][b'active']}</span> Active)
                | <span class="footerhighlight">${ep_downloaded}</span>

                % if ep_snatched:
                <span class="footerhighlight"><a href="${srRoot}/manage/episodeStatuses?whichStatus=2" title="View overview of snatched episodes">+${ep_snatched}</a></span> Snatched
                % endif

                &nbsp;/&nbsp;<span class="footerhighlight">${ep_total}</span> Episodes Downloaded ${ep_percentage}
                | Daily Search: <span
                    class="footerhighlight">${str(sickrage.srCore.SCHEDULER.get_job('DAILYSEARCHER').next_run_time).split('.')[0]}</span>
                | Backlog Search: <span
                    class="footerhighlight">${str(sickrage.srCore.SCHEDULER.get_job('BACKLOG').next_run_time).split('.')[0]}</span>

                <div>
                    % if has_resource_module:
                        Memory used: <span
                            class="footerhighlight">${pretty_filesize(resource.getrusage(resource.RUSAGE_SELF).ru_maxrss)}</span>
                        |
                    % endif
                    Load time: <span class="footerhighlight">${"%.4f" % (time() - srStartTime)}s</span> / Mako: <span
                        class="footerhighlight">${"%.4f" % (time() - makoStartTime)}s</span> |
                    Branch: <span class="footerhighlight">${sickrage.srCore.VERSION}</span> |
                    Now: <span class="footerhighlight">${datetime.now(tz_updater.sr_timezone)}</span>
                </div>
            </div>
        </footer>
        <script type="text/javascript" src="${srRoot}/js/_bower.min.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.cookie.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.cookiejar.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.json-2.2.min.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.selectboxes.min.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.tokeninput.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.tablesorter-2.17.7.min.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.tablesorter.widgets-2.17.7.min.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.tablesorter.widget-columnSelector-2.17.7.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.qtip-2.2.1.min.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.ui.touch-punch-0.2.2.min.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/isotope.pkgd.min.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.confirm.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/formwizard.js?${srPID}"></script><!-- Can't be added to bower -->
        <script type="text/javascript" src="${srRoot}/js/lib/pnotify.custom.min.js?${srPID}"></script><!-- Needs to be removed -->
        <script type="text/javascript" src="${srRoot}/js/new/parsers.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/new/meta.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/new/core.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/lib/jquery.scrolltopcontrol-1.1.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/browser.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/ajaxNotifications.js?${srPID}"></script>
        <script type="text/javascript" src="${srRoot}/js/confirmations.js?${srPID}"></script>
    % endif
        <%block name="scripts" />
    </body>
</html>
