/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.cache;

import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCache;
import org.jboss.resteasy.client.jaxrs.cache.MapCache;

public class LightweightBrowserCache
implements BrowserCache {
    protected long maxBytes = 2000000L;
    protected BrowserCache internalCache = null;
    protected AtomicLong bytes = new AtomicLong(0L);

    public LightweightBrowserCache() {
        this(new MapCache());
    }

    public LightweightBrowserCache(BrowserCache cache) {
        this.internalCache = cache;
    }

    public BrowserCache getInternalCache() {
        return this.internalCache;
    }

    public void setInternalCache(BrowserCache internalCache) {
        this.internalCache = internalCache;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    @Override
    public BrowserCache.Entry getAny(String key) {
        return this.internalCache.getAny(key);
    }

    @Override
    public BrowserCache.Entry remove(String key, MediaType type) {
        BrowserCache.Entry entry = this.internalCache.remove(key, type);
        if (entry != null) {
            this.bytes.addAndGet(-1 * entry.getCached().length);
        }
        return entry;
    }

    public long getByteCount() {
        return this.bytes.get();
    }

    @Override
    public BrowserCache.Entry get(String key, MediaType accept) {
        return this.internalCache.get(key, accept);
    }

    @Override
    public BrowserCache.Entry put(String key, MediaType mediaType, MultivaluedMap<String, String> headers, byte[] cached, int expires, String etag, String lastModified) {
        BrowserCache.Entry previousValue = this.internalCache.get(key, mediaType);
        int sizeDiff = -1;
        sizeDiff = previousValue == null ? cached.length : cached.length - previousValue.getCached().length;
        if (this.bytes.addAndGet(sizeDiff) > this.maxBytes) {
            this.clear();
            this.bytes.addAndGet(sizeDiff);
        }
        return this.internalCache.put(key, mediaType, headers, cached, expires, etag, lastModified);
    }

    @Override
    public void clear() {
        this.internalCache.clear();
        this.bytes.set(0L);
    }
}

