/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest;

import com.google.common.base.Strings;
import com.google.common.io.Closer;
import com.google.common.net.UrlEscapers;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.objectweb.proactive.utils.StackTraceUtil;
import org.ow2.proactive.authentication.ConnectionInfo;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive.db.SortParameter;
import org.ow2.proactive.scheduler.common.JobFilterCriteria;
import org.ow2.proactive.scheduler.common.JobSortParameter;
import org.ow2.proactive.scheduler.common.Page;
import org.ow2.proactive.scheduler.common.SchedulerConstants;
import org.ow2.proactive.scheduler.common.SchedulerEvent;
import org.ow2.proactive.scheduler.common.SchedulerEventListener;
import org.ow2.proactive.scheduler.common.SchedulerStatus;
import org.ow2.proactive.scheduler.common.SortSpecifierContainer;
import org.ow2.proactive.scheduler.common.TaskDescriptor;
import org.ow2.proactive.scheduler.common.exception.JobAlreadyFinishedException;
import org.ow2.proactive.scheduler.common.exception.JobCreationException;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.exception.SubmissionClosedException;
import org.ow2.proactive.scheduler.common.exception.UnknownJobException;
import org.ow2.proactive.scheduler.common.exception.UnknownTaskException;
import org.ow2.proactive.scheduler.common.job.CompletedJobsCount;
import org.ow2.proactive.scheduler.common.job.CompletedTasksCount;
import org.ow2.proactive.scheduler.common.job.FilteredStatistics;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflow;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsCumulatedCoreTime;
import org.ow2.proactive.scheduler.common.job.FilteredTopWorkflowsNumberOfNodes;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobIdDataAndError;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobLabelInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobResult;
import org.ow2.proactive.scheduler.common.job.JobState;
import org.ow2.proactive.scheduler.common.job.JobStatus;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.WorkflowDuration;
import org.ow2.proactive.scheduler.common.job.factories.Job2XMLTransformer;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskResult;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatesPage;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.usage.JobUsage;
import org.ow2.proactive.scheduler.job.JobIdImpl;
import org.ow2.proactive.scheduler.job.SchedulerUserInfo;
import org.ow2.proactive.scheduler.rest.ClientBase;
import org.ow2.proactive.scheduler.rest.ExceptionUtility;
import org.ow2.proactive.scheduler.rest.ISchedulerClient;
import org.ow2.proactive.scheduler.rest.SchedulerEventReceiver;
import org.ow2.proactive.scheduler.rest.SessionHandler;
import org.ow2.proactive.scheduler.rest.data.DataUtility;
import org.ow2.proactive.scheduler.rest.data.JobInfoImpl;
import org.ow2.proactive.scheduler.rest.data.TaskResultImpl;
import org.ow2.proactive.scheduler.rest.data.TaskStateImpl;
import org.ow2.proactive.scheduler.rest.readers.OctetStreamReader;
import org.ow2.proactive.scheduler.rest.readers.TaskResultReader;
import org.ow2.proactive.scheduler.rest.readers.WildCardTypeReader;
import org.ow2.proactive.scheduler.signal.SignalApiException;
import org.ow2.proactive.scheduler.task.TaskIdImpl;
import org.ow2.proactive_grid_cloud_portal.common.SchedulerRestInterface;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.common.dto.PermissionForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.SchedulerRestClient;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedJobsCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.CompletedTasksCountData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.FilteredStatisticsData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobValidationData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestMapPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerStatusData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskInfoData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.WorkflowUrlData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.RestException;

public class SchedulerClient
extends ClientBase
implements ISchedulerClient {
    private static final long RETRY_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private SchedulerRestClient schedulerRestClient;
    private String sid;
    private ConnectionInfo connectionInfo;
    private boolean initialized = false;
    private SchedulerEventReceiver schedulerEventReceiver;
    public static final String ASC_SUFFIX = "_a";
    public static final String DESC_SUFFIX = "_d";
    private static final Logger logger = Logger.getLogger(SchedulerClient.class);

    private SchedulerClient() {
    }

    public static ISchedulerClient createInstance() {
        SchedulerClient client = new SchedulerClient();
        return (ISchedulerClient)Proxy.newProxyInstance(ISchedulerClient.class.getClassLoader(), new Class[]{ISchedulerClient.class}, (InvocationHandler)new SessionHandler(client));
    }

    private String createJobSortParamsString(List<SortParameter<JobSortParameter>> jobSortParameters) {
        if (jobSortParameters == null) {
            return "";
        }
        return jobSortParameters.stream().map(jobSortParameter -> {
            String jobParameterName = ((JobSortParameter)jobSortParameter.getParameter()).name();
            if (jobSortParameter.getSortOrder().isAscending()) {
                return jobParameterName + ASC_SUFFIX;
            }
            return jobParameterName + DESC_SUFFIX;
        }).collect(Collectors.joining(","));
    }

    @Override
    public void init(ConnectionInfo connectionInfo) throws Exception {
        CloseableHttpClient client = new org.ow2.proactive.http.HttpClientBuilder().insecure(connectionInfo.isInsecure()).useSystemProperties().build();
        SchedulerRestClient restApiClient = new SchedulerRestClient(connectionInfo.getUrl(), (ClientHttpEngine)new ApacheHttpClient4Engine((HttpClient)client));
        ResteasyProviderFactory factory = ResteasyProviderFactory.getInstance();
        factory.register((Object)new WildCardTypeReader());
        factory.register((Object)new OctetStreamReader());
        factory.register((Object)new TaskResultReader());
        SchedulerRestClient.registerGzipEncoding((ResteasyProviderFactory)factory);
        this.setApiClient(restApiClient);
        this.connectionInfo = connectionInfo;
        this.initialized = true;
        this.renewSession();
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SchedulerClient not initialized.");
        }
    }

    public List<JobUsage> getAccountUsage(String user, Date start, Date end) throws NotConnectedException, PermissionException {
        List<JobUsage> jobUsages = null;
        try {
            List jobUsageDataList = this.restApi().getUsageOnAccount(this.sid, user, start, end);
            jobUsages = DataUtility.toJobUsages(jobUsageDataList);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return jobUsages;
    }

    public List<JobUsage> getMyAccountUsage(Date startDate, Date endDate) throws NotConnectedException, PermissionException {
        List<JobUsage> jobUsages = null;
        try {
            List jobUsageDataList = this.restApi().getUsageOnMyAccount(this.sid, startDate, endDate);
            jobUsages = DataUtility.toJobUsages(jobUsageDataList);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return jobUsages;
    }

    public void changeJobPriority(JobId jobId, JobPriority priority) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException {
        this.changeJobPriority(jobId.value(), priority);
    }

    public void changeJobPriority(String jobId, JobPriority priority) throws NotConnectedException, UnknownJobException, PermissionException, JobAlreadyFinishedException {
        try {
            this.restApi().schedulerChangeJobPriorityByName(this.sid, jobId, priority.name());
        }
        catch (Exception e) {
            ExceptionUtility.throwJAFEOrUJEOrNCEOrPE(e);
        }
    }

    public void disconnect() throws NotConnectedException, PermissionException {
        try {
            this.restApi().disconnect(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        this.initialized = false;
    }

    public boolean freeze() throws NotConnectedException, PermissionException {
        boolean success = false;
        try {
            success = this.restApi().freezeScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return success;
    }

    public JobResult getJobResult(JobId jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        return this.getJobResult(jobId.value());
    }

    public JobResult getJobResult(String jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        JobResult jobResult = null;
        try {
            JobResultData jobResultData = this.restApi().jobResult(this.sid, jobId);
            if (jobResultData != null) {
                jobResult = DataUtility.toJobResult(jobResultData);
            }
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return jobResult;
    }

    public JobState getJobState(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        JobState jobState = null;
        try {
            JobStateData jobStateData = this.restApi().listJobs(this.sid, jobId);
            jobState = DataUtility.toJobState(jobStateData);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return jobState;
    }

    public JobState getJobState(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getJobState(jobId.value());
    }

    public TaskState getTaskState(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        TaskStateImpl taskState = null;
        try {
            TaskStateData taskStateData = this.restApi().jobTask(this.sid, jobId.toString(), taskName);
            taskState = new TaskStateImpl(taskStateData);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return taskState;
    }

    public Page<JobInfo> getJobs(int index, int range, JobFilterCriteria criteria, List<SortParameter<JobSortParameter>> jobSortParameters) throws NotConnectedException, PermissionException {
        Page jobInfos = null;
        try {
            String sortParams = this.createJobSortParamsString(jobSortParameters);
            RestMapPage userJobsAllRevisions = this.restApi().revisionAndJobsInfo(this.sid, index, range, criteria.isMyJobsOnly(), criteria.isPending(), criteria.isRunning(), criteria.isFinished(), criteria.isWithIssuesOnly(), criteria.isChildJobs(), criteria.getJobName(), criteria.getProjectName(), criteria.getBucketName(), criteria.getSubmissionMode(), criteria.getLabel(), criteria.getUserName(), criteria.getTenant(), criteria.getParentId(), sortParams, criteria.getStatus() != null ? criteria.getStatus().toString() : "", criteria.getSubmittedTimeLessThan(), criteria.getSubmittedTimeGreater());
            List userJobs = (List)userJobsAllRevisions.getMap().values().iterator().next();
            jobInfos = new Page(DataUtility.toJobInfos(userJobs), userJobs.size());
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return jobInfos;
    }

    public List<JobInfo> getJobsInfoList(List<String> jobsId) throws PermissionException, NotConnectedException {
        ArrayList<JobInfo> jobsInfoList = null;
        try {
            List userJobDataList = this.restApi().jobsInfoList(this.sid, jobsId);
            jobsInfoList = new ArrayList<JobInfo>(DataUtility.toJobInfos(userJobDataList));
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return jobsInfoList;
    }

    public String getJobServerLogs(String jobId) throws UnknownJobException, NotConnectedException, PermissionException {
        String jobServerLog = "";
        try {
            jobServerLog = this.restApi().jobServerLog(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return jobServerLog;
    }

    public SchedulerStatus getStatus() throws NotConnectedException, PermissionException {
        SchedulerStatus status = null;
        try {
            SchedulerStatusData schedulerStatus = this.restApi().getSchedulerStatus(this.sid);
            status = SchedulerStatus.valueOf((String)schedulerStatus.name());
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return status;
    }

    public TaskResult getTaskResult(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        TaskResultImpl taskResult = null;
        try {
            String value;
            TaskResultData taskResultData = this.restApi().taskResult(this.sid, jobId, taskName);
            taskResult = (TaskResultImpl)DataUtility.toTaskResult(JobIdImpl.makeJobId((String)jobId), taskResultData);
            if (taskResult.value() == null && (value = this.restApi().valueOfTaskResult(this.sid, jobId, taskName)) != null) {
                taskResult.setValue((Serializable)((Object)value));
            }
        }
        catch (Throwable t) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(ExceptionUtility.exception(t));
        }
        return taskResult;
    }

    public TaskResult getTaskResult(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.getTaskResult(jobId.value(), taskName);
    }

    public List<TaskResult> getTaskResultsByTag(JobId jobId, String taskTag) throws NotConnectedException, UnknownJobException, PermissionException {
        List taskStates = this.getJobState(jobId).getTasksByTag(taskTag);
        ArrayList<TaskResult> results = new ArrayList<TaskResult>(taskStates.size());
        for (TaskState currentState : taskStates) {
            String taskName = currentState.getTaskInfo().getName();
            try {
                TaskResult currentResult = this.getTaskResult(jobId, taskName);
                results.add(currentResult);
            }
            catch (UnknownTaskException ex) {
                logger.warn((Object)"Unknown task.", (Throwable)ex);
            }
        }
        return results;
    }

    public List<TaskResult> getTaskResultsByTag(String jobId, String taskTag) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.getTaskResultsByTag(JobIdImpl.makeJobId((String)jobId), taskTag);
    }

    public String getTaskServerLogs(String jobId, String taskName) throws UnknownJobException, UnknownTaskException, NotConnectedException, PermissionException {
        String taskLogs = "";
        try {
            taskLogs = this.restApi().taskLog(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return taskLogs;
    }

    public String getTaskServerLogsByTag(String jobId, String tag) throws UnknownJobException, NotConnectedException, PermissionException {
        String taskLogs = "";
        try {
            taskLogs = this.restApi().taskLogByTag(this.sid, jobId, tag);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return taskLogs;
    }

    public List<SchedulerUserInfo> getUsers() throws NotConnectedException, PermissionException {
        List<SchedulerUserInfo> schedulerUserInfos = null;
        try {
            List users = this.restApi().getUsers(this.sid);
            schedulerUserInfos = DataUtility.toSchedulerUserInfos(users);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return schedulerUserInfos;
    }

    public List<SchedulerUserInfo> getUsersWithJobs() throws NotConnectedException, PermissionException {
        List<SchedulerUserInfo> schedulerUserInfos = null;
        try {
            List usersWithJobs = this.restApi().getUsersWithJobs(this.sid);
            schedulerUserInfos = DataUtility.toSchedulerUserInfos(usersWithJobs);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return schedulerUserInfos;
    }

    public FilteredStatistics getFilteredStatistics(String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            FilteredStatisticsData usersWithJobs = this.restApi().getFilteredStatistics(this.sid, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
            return DataUtility.toFilteredStatistics(usersWithJobs);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<FilteredTopWorkflow> getTopWorkflowsWithIssues(int numberOfWorkflows, String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            List filteredWorkflows = this.restApi().getTopWorkflowsWithIssues(this.sid, numberOfWorkflows, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
            return new ArrayList<FilteredTopWorkflow>(DataUtility.toFilteredTopWorkflowsWithIssues(filteredWorkflows));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<FilteredTopWorkflowsCumulatedCoreTime> getTopWorkflowsCumulatedCoreTime(int numberOfWorkflows, String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            List filteredWorkflows = this.restApi().getTopWorkflowsCumulatedCoreTime(this.sid, numberOfWorkflows, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
            return new ArrayList<FilteredTopWorkflowsCumulatedCoreTime>(DataUtility.toFilteredTopCumulatedCoreTime(filteredWorkflows));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<FilteredTopWorkflowsNumberOfNodes> getTopWorkflowsNumberOfNodes(int numberOfWorkflows, String workflowName, String bucketName, boolean myJobs, long startDate, long endDate, boolean inParallel) throws NotConnectedException, PermissionException {
        try {
            List filteredWorkflows = this.restApi().getTopWorkflowsNumberOfNodes(this.sid, numberOfWorkflows, startDate, endDate, myJobs, workflowName, bucketName, inParallel);
            return new ArrayList<FilteredTopWorkflowsNumberOfNodes>(DataUtility.tFilteredTopWorkflowsNumberOfNodes(filteredWorkflows));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<WorkflowDuration> getTopExecutionTimeWorkflows(int numberOfWorkflows, String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            List filteredWorkflows = this.restApi().getTopExecutionTimeWorkflows(this.sid, numberOfWorkflows, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
            return new ArrayList<WorkflowDuration>(DataUtility.toWorkflowsDuration(filteredWorkflows));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<WorkflowDuration> getTopPendingTimeWorkflows(int numberOfWorkflows, String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            List filteredWorkflows = this.restApi().getTopPendingTimeWorkflows(this.sid, numberOfWorkflows, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
            return new ArrayList<WorkflowDuration>(DataUtility.toWorkflowsDuration(filteredWorkflows));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public Map<String, Integer> getSubmissionModeCount(String workflowName, String bucketName, Boolean myJobs, long startDate, long endDate) throws NotConnectedException, PermissionException {
        try {
            return this.restApi().getSubmissionModeCount(this.sid, startDate, endDate, myJobs.booleanValue(), workflowName, bucketName);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public CompletedJobsCount getCompletedJobs(Boolean myJobs, String workflowName, String bucketName, long startDate, long endDate, int numberOfIntervals) throws NotConnectedException, PermissionException {
        try {
            CompletedJobsCountData completedJob = this.restApi().getCompletedJobs(this.sid, myJobs.booleanValue(), workflowName, bucketName, startDate, endDate, numberOfIntervals);
            return DataUtility.toCompletedJobsCount(completedJob);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public CompletedTasksCount getCompletedTasks(Boolean myTasks, String taskName, long startDate, long endDate, int numberOfIntervals) throws NotConnectedException, PermissionException {
        try {
            CompletedTasksCountData completedTask = this.restApi().getCompletedTasks(this.sid, myTasks.booleanValue(), taskName, startDate, endDate, numberOfIntervals);
            return DataUtility.toCompletedTasksCount(completedTask);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public Set<String> getSubmissionModeValues() throws NotConnectedException, PermissionException {
        try {
            return this.restApi().getSubmissionModeValues(this.sid);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.initialized) {
            try {
                isConnected = this.restApi().isConnected(this.sid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return isConnected;
    }

    public String getCurrentPolicy() throws NotConnectedException, PermissionException {
        return this.getCurrentPolicy();
    }

    public Map getJobsToSchedule() throws NotConnectedException, PermissionException {
        return this.getJobsToSchedule();
    }

    @Override
    public List<TaskDescriptor> getTasksToSchedule() throws NotConnectedException, PermissionException {
        return this.getTasksToSchedule();
    }

    public boolean kill() throws NotConnectedException, PermissionException {
        boolean isKilled = false;
        try {
            isKilled = this.restApi().killScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isKilled;
    }

    public boolean killJob(JobId jobId) throws NotConnectedException, PermissionException {
        return this.killJob(jobId.value());
    }

    public boolean killJob(String jobId) throws NotConnectedException, PermissionException {
        boolean isJobKilled = false;
        try {
            isJobKilled = this.restApi().killJob(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isJobKilled;
    }

    public boolean killJobs(List<String> jobsId) throws NotConnectedException, PermissionException {
        boolean isJobKilled = false;
        try {
            isJobKilled = this.restApi().killJobs(this.sid, jobsId);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isJobKilled;
    }

    public boolean killTask(JobId jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.killTask(jobId.value(), taskName);
    }

    public boolean killTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        boolean isTaskKilled = false;
        try {
            isTaskKilled = this.restApi().killTask(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return isTaskKilled;
    }

    public boolean linkResourceManager(String rmUrl) throws NotConnectedException, PermissionException {
        boolean isLinked = false;
        try {
            isLinked = this.restApi().linkRm(this.sid, rmUrl);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isLinked;
    }

    public boolean pause() throws NotConnectedException, PermissionException {
        boolean isSchedulerPaused = false;
        try {
            isSchedulerPaused = this.restApi().pauseScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isSchedulerPaused;
    }

    public boolean pauseJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.pauseJob(jobId.value());
    }

    public boolean pauseJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        boolean isJobPaused = false;
        try {
            isJobPaused = this.restApi().pauseJob(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return isJobPaused;
    }

    public boolean restartAllInErrorTasks(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        boolean isAllInErrorTasksRestarted = false;
        try {
            isAllInErrorTasksRestarted = this.restApi().restartAllInErrorTasks(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return isAllInErrorTasksRestarted;
    }

    public boolean preemptTask(JobId jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.preemptTask(jobId.value(), taskName, restartDelay);
    }

    public boolean preemptTask(String jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        boolean isTaskPreempted = false;
        try {
            isTaskPreempted = this.restApi().preemptTask(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return isTaskPreempted;
    }

    public boolean removeJob(JobId jobId) throws NotConnectedException, PermissionException {
        return this.removeJob(jobId.value());
    }

    public boolean removeJobs(List<JobId> jobIds) throws NotConnectedException, PermissionException {
        boolean isAllJobsRemoved = false;
        try {
            isAllJobsRemoved = this.restApi().removeJobs(this.sid, jobIds.stream().map(JobId::value).collect(Collectors.toList()), 0L);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
        }
        return isAllJobsRemoved;
    }

    public boolean removeJobs(long olderThan) throws NotConnectedException, PermissionException {
        boolean isAllJobsRemoved = false;
        try {
            isAllJobsRemoved = this.restApi().removeJobs(this.sid, null, olderThan);
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
        }
        return isAllJobsRemoved;
    }

    public boolean removeJob(String jobId) throws NotConnectedException, PermissionException {
        boolean isJobRemoved = false;
        try {
            isJobRemoved = this.restApi().removeJob(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isJobRemoved;
    }

    public boolean restartTask(JobId jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        return this.restartTask(jobId.value(), taskName, restartDelay);
    }

    public boolean restartTask(String jobId, String taskName, int restartDelay) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        boolean isTaskRestarted = false;
        try {
            isTaskRestarted = this.restApi().restartTask(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return isTaskRestarted;
    }

    public boolean finishInErrorTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        boolean result = false;
        try {
            result = this.restApi().finishInErrorTask(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return result;
    }

    public boolean restartInErrorTask(String jobId, String taskName) throws NotConnectedException, UnknownJobException, UnknownTaskException, PermissionException {
        boolean result = false;
        try {
            result = this.restApi().restartInErrorTask(this.sid, jobId, taskName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return result;
    }

    public boolean resume() throws NotConnectedException, PermissionException {
        boolean isResumed = false;
        try {
            isResumed = this.restApi().resumeScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isResumed;
    }

    public boolean resumeJob(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.resumeJob(jobId.value());
    }

    public boolean resumeJob(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        boolean isJobResumed = false;
        try {
            isJobResumed = this.restApi().resumeJob(this.sid, jobId);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return isJobResumed;
    }

    public boolean shutdown() throws NotConnectedException, PermissionException {
        boolean isShutdown = false;
        try {
            isShutdown = this.restApi().shutdownScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isShutdown;
    }

    public boolean start() throws NotConnectedException, PermissionException {
        boolean success = false;
        try {
            success = this.restApi().startScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return success;
    }

    public boolean stop() throws NotConnectedException, PermissionException {
        boolean isStopped = false;
        try {
            isStopped = this.restApi().stopScheduler(this.sid);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return isStopped;
    }

    public JobId submit(Job job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        JobIdData jobIdData = null;
        try {
            Map<String, String> genericInformation = SchedulerClient.setSubmissionModeToGenericInfo(job.getGenericInformation());
            InputStream is = new Job2XMLTransformer().jobToxml((TaskFlowJob)job);
            jobIdData = this.restApiClient().submitXml(this.sid, is, null, genericInformation);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPEOrSCEOrJCE(e);
        }
        return DataUtility.jobId(jobIdData);
    }

    public List<JobIdDataAndError> submit(List<Job> jobs) throws NotConnectedException {
        ArrayList<JobIdDataAndError> jobIdDataAndErrors = new ArrayList<JobIdDataAndError>(jobs.size());
        for (Job job : jobs) {
            try {
                job.setGenericInformation(new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(job.getGenericInformation())));
                InputStream is = new Job2XMLTransformer().jobToxml((TaskFlowJob)job);
                JobIdData jobIdData = this.restApiClient().submitXml(this.sid, is);
                jobIdDataAndErrors.add(new JobIdDataAndError(jobIdData.getId(), jobIdData.getReadableName()));
            }
            catch (Exception e) {
                jobIdDataAndErrors.add(new JobIdDataAndError(e.getMessage(), StackTraceUtil.getStackTrace((Throwable)e)));
            }
        }
        return jobIdDataAndErrors;
    }

    @Override
    public JobId submit(File job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        JobIdData jobIdData = null;
        Map<String, String> genericInfos = SchedulerClient.setSubmissionModeToGenericInfo(null);
        try (FileInputStream is = new FileInputStream(job);){
            jobIdData = this.restApiClient().submitXml(this.sid, (InputStream)is, null, genericInfos);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPEOrSCEOrJCE(e);
        }
        return DataUtility.jobId(jobIdData);
    }

    public JobId reSubmit(JobId currentJobId, Map<String, String> jobVariables, Map<String, String> jobGenericInfos, String sessionId) throws NotConnectedException {
        JobIdData jobIdData;
        try {
            jobGenericInfos = new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(jobGenericInfos));
            jobIdData = this.restApiClient().reSubmit(this.sid, currentJobId.value(), jobVariables, jobGenericInfos);
        }
        catch (NotConnectedRestException e) {
            throw new NotConnectedException((Throwable)e);
        }
        return DataUtility.jobId(jobIdData);
    }

    @Override
    public JobId submit(File job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submit(job, variables, null);
    }

    @Override
    public JobId submit(File job, Map<String, String> variables, Map<String, String> genericInfos) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        JobIdData jobIdData = null;
        genericInfos = new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(genericInfos));
        try (FileInputStream is = new FileInputStream(job);){
            jobIdData = this.restApiClient().submitXml(this.sid, (InputStream)is, variables, genericInfos);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPEOrSCEOrJCE(e);
        }
        return DataUtility.jobId(jobIdData);
    }

    @Override
    public JobId submit(URL job) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submit(job, null, null);
    }

    @Override
    public JobId submit(URL job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submit(job, variables, null);
    }

    @Override
    public JobId submit(Map<String, String> genericInfos, URL job, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submit(job, variables, genericInfos, null);
    }

    @Override
    public JobId submit(URL job, Map<String, String> variables, Map<String, String> requestHeaderParams) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submit(job, variables, null, requestHeaderParams);
    }

    @Override
    public JobId submit(URL job, Map<String, String> variables, Map<String, String> genericInfos, Map<String, String> requestHeaderParams) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        JobIdData jobIdData = null;
        try {
            URLConnection urlConnection = job.openConnection();
            if (requestHeaderParams != null) {
                for (Map.Entry<String, String> requestHeaderEntry : requestHeaderParams.entrySet()) {
                    urlConnection.addRequestProperty(requestHeaderEntry.getKey(), requestHeaderEntry.getValue());
                }
            }
            InputStream is = urlConnection.getInputStream();
            genericInfos = new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(genericInfos));
            jobIdData = this.restApiClient().submitXml(this.sid, is, variables, genericInfos);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPEOrSCEOrJCE(e);
        }
        return DataUtility.jobId(jobIdData);
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submitFromCatalog(catalogRestURL, bucketName, workflowName, null);
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submitFromCatalog(catalogRestURL, bucketName, workflowName, variables, null);
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String bucketName, String workflowName, Map<String, String> variables, Map<String, String> genericInfo) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        String objectUrl = catalogRestURL + "/buckets/" + UrlEscapers.urlPathSegmentEscaper().escape(bucketName) + "/resources/" + UrlEscapers.urlPathSegmentEscaper().escape(workflowName) + "/raw";
        return this.submitFromCatalog(objectUrl, variables, genericInfo);
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submitFromCatalog(catalogRestURL, calledWorkflow, new HashMap<String, String>());
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow, Map<String, String> variables) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        return this.submitFromCatalog(catalogRestURL, this.getBucketFromCalledWorkflow(calledWorkflow), this.getNameFromCalledWorkflow(calledWorkflow), variables, null);
    }

    @Override
    public JobId submitFromCatalog(String catalogRestURL, String calledWorkflow, Map<String, String> variables, Map<String, String> genericInfo) throws NotConnectedException, PermissionException, SubmissionClosedException, JobCreationException {
        Optional<String> revision = this.getRevisionFromCalledWorkflow(calledWorkflow);
        String objectUrl = catalogRestURL + "/buckets/" + UrlEscapers.urlPathSegmentEscaper().escape(this.getBucketFromCalledWorkflow(calledWorkflow)) + "/resources/" + UrlEscapers.urlPathSegmentEscaper().escape(this.getNameFromCalledWorkflow(calledWorkflow)) + revision.map(r -> "/revisions/" + UrlEscapers.urlPathSegmentEscaper().escape(r)).orElse("") + "/raw";
        return this.submitFromCatalog(objectUrl, variables, genericInfo);
    }

    @Override
    public List<JobIdDataAndError> multipleSubmitFromUrls(List<WorkflowUrlData> workflowUrlDataList) throws NotConnectedException, PermissionException {
        List answer = null;
        try {
            workflowUrlDataList.forEach(workflowUrlData -> workflowUrlData.setGenericInformation(new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(workflowUrlData.getGenericInformation()))));
            answer = this.restApiClient().submitMultipleUrl(this.sid, workflowUrlDataList);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return answer;
    }

    @Override
    public boolean isJobFinished(JobId jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        return this.isJobFinished(jobId.toString());
    }

    @Override
    public boolean isJobFinished(String jobId) throws NotConnectedException, UnknownJobException, PermissionException {
        boolean answer = false;
        try {
            answer = !this.getJobInfo(jobId).getStatus().isJobAlive();
        }
        catch (SchedulerException e) {
            ExceptionUtility.throwUJEOrNCEOrPE((Exception)((Object)e));
        }
        return answer;
    }

    @Override
    public JobResult waitForJob(JobId jobId, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        return this.waitForJob(jobId.value(), timeout);
    }

    @Override
    public JobResult waitForJob(String jobId, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        timeout += System.currentTimeMillis();
        while (System.currentTimeMillis() < timeout) {
            if (this.isJobFinished(jobId)) {
                JobResult result = this.getJobResult(jobId);
                if (result == null) {
                    throw new IllegalStateException("Result for job " + jobId + " not found");
                }
                return result;
            }
            if (System.currentTimeMillis() + RETRY_INTERVAL >= timeout) break;
            this.sleep(RETRY_INTERVAL);
        }
        throw new TimeoutException(String.format("Timeout waiting for the job: job-id=%s", jobId));
    }

    @Override
    public boolean isTaskFinished(String jobId, String taskName) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException {
        boolean finished = false;
        try {
            TaskStateData taskStateData = this.restApi().jobTask(this.sid, jobId, taskName);
            TaskState taskState = DataUtility.taskState(taskStateData);
            finished = !taskState.getStatus().isTaskAlive();
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
        return finished;
    }

    @Override
    public TaskResult waitForTask(String jobId, String taskName, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        timeout += System.currentTimeMillis();
        while (System.currentTimeMillis() < timeout) {
            if (this.isTaskFinished(jobId, taskName)) {
                return this.getTaskResult(jobId, taskName);
            }
            if (System.currentTimeMillis() + RETRY_INTERVAL >= timeout) break;
            this.sleep(RETRY_INTERVAL);
        }
        throw new TimeoutException(String.format("Timeout waiting for the task: job-id=%s, task-id=%s", jobId, taskName));
    }

    @Override
    public List<JobResult> waitForAllJobs(List<String> jobIds, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        long timestamp = 0L;
        ArrayList<JobResult> results = new ArrayList<JobResult>(jobIds.size());
        for (String jobId : jobIds) {
            timestamp = System.currentTimeMillis();
            results.add(this.waitForJob(jobId, timeout));
            timeout -= System.currentTimeMillis() - timestamp;
        }
        return results;
    }

    @Override
    public Map.Entry<String, JobResult> waitForAnyJob(List<String> jobIds, long timeout) throws NotConnectedException, UnknownJobException, PermissionException, TimeoutException {
        timeout += System.currentTimeMillis();
        while (System.currentTimeMillis() < timeout) {
            for (String jobId : jobIds) {
                if (!this.isJobFinished(jobId)) continue;
                return this.toEntry(jobId, this.getJobResult(jobId));
            }
            if (System.currentTimeMillis() + RETRY_INTERVAL >= timeout) break;
            this.sleep(RETRY_INTERVAL);
        }
        throw new TimeoutException(String.format("Timeout waiting for any job: jobIds=%s.", String.valueOf(jobIds)));
    }

    @Override
    public Map.Entry<String, TaskResult> waitForAnyTask(String jobId, List<String> taskNames, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        timeout += System.currentTimeMillis();
        while (System.currentTimeMillis() < timeout) {
            for (String taskName : taskNames) {
                if (!this.isTaskFinished(jobId, taskName)) continue;
                return this.toEntry(taskName, this.getTaskResult(jobId, taskName));
            }
            if (System.currentTimeMillis() + RETRY_INTERVAL >= timeout) break;
            this.sleep(RETRY_INTERVAL);
        }
        throw new TimeoutException(String.format("Timeout waiting for any task: job-id=%s, task-ids=%s.", jobId, String.valueOf(taskNames)));
    }

    @Override
    public List<Map.Entry<String, TaskResult>> waitForAllTasks(String jobId, List<String> taskNames, long timeout) throws UnknownJobException, NotConnectedException, PermissionException, UnknownTaskException, TimeoutException {
        long timestamp = 0L;
        ArrayList<Map.Entry<String, TaskResult>> taskResults = new ArrayList<Map.Entry<String, TaskResult>>(taskNames.size());
        for (String taskName : taskNames) {
            timestamp = System.currentTimeMillis();
            Map.Entry<String, TaskResult> taskResultEntry = this.toEntry(taskName, this.waitForTask(jobId, taskName, timeout));
            taskResults.add(taskResultEntry);
            timeout -= System.currentTimeMillis() - timestamp;
        }
        return taskResults;
    }

    @Override
    public boolean pushFile(String spacename, String pathname, String filename, String file) throws NotConnectedException, PermissionException {
        boolean uploaded = false;
        try (FileInputStream inputStream = new FileInputStream(file);){
            uploaded = this.restApiClient().pushFile(this.sid, spacename, pathname, filename, (InputStream)inputStream);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return uploaded;
    }

    @Override
    public void pullFile(String space, String pathname, String outputFile) throws NotConnectedException, PermissionException {
        try {
            this.restApiClient().pullFile(this.sid, space, pathname, outputFile);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
    }

    @Override
    public boolean deleteFile(String space, String pathname) throws NotConnectedException, PermissionException {
        boolean deleted = false;
        try {
            deleted = this.restApi().deleteFile(this.sid, space, pathname);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
        return deleted;
    }

    public List<String> getUserSpaceURIs() throws NotConnectedException, PermissionException {
        try {
            return this.restApi().userspaceURIs(this.sid);
        }
        catch (Exception error) {
            throw ExceptionUtility.throwNCEOrPE(error);
        }
    }

    public List<String> getGlobalSpaceURIs() throws NotConnectedException, PermissionException {
        try {
            return this.restApi().globalspaceURIs(this.sid);
        }
        catch (Exception error) {
            throw ExceptionUtility.throwNCEOrPE(error);
        }
    }

    public void renewSession() throws NotConnectedException {
        Closer closer = Closer.create();
        try {
            LoginForm loginForm = new LoginForm();
            loginForm.setUsername(Strings.isNullOrEmpty((String)this.connectionInfo.getDomain()) ? this.connectionInfo.getLogin() : this.connectionInfo.getDomain() + "\\" + this.connectionInfo.getLogin());
            loginForm.setPassword(this.connectionInfo.getPassword());
            if (this.connectionInfo.getCredentialFile() != null) {
                FileInputStream inputStream = new FileInputStream(this.connectionInfo.getCredentialFile());
                closer.register((Closeable)inputStream);
                loginForm.setCredential((InputStream)inputStream);
            }
            this.sid = this.restApi().loginOrRenewSession(this.sid, loginForm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void setSession(String sid) {
        this.sid = sid;
    }

    @Override
    public String getSession() {
        return this.sid;
    }

    public void addEventListener(SchedulerEventListener listener, boolean myEventsOnly, SchedulerEvent ... events) throws NotConnectedException, PermissionException {
        try {
            this.removeEventListener();
            this.schedulerEventReceiver = new SchedulerEventReceiver.Builder().restServerUrl(this.connectionInfo.getUrl()).insecure(this.connectionInfo.isInsecure()).sessionId(this.sid).schedulerEventListener(listener).myEventsOnly(myEventsOnly).selectedEvents(events).build();
            this.schedulerEventReceiver.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeEventListener() throws NotConnectedException, PermissionException {
        if (this.schedulerEventReceiver != null) {
            this.schedulerEventReceiver.stop();
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private SchedulerRestInterface restApi() {
        this.checkInitialized();
        return this.schedulerRestClient.getScheduler();
    }

    private void setApiClient(SchedulerRestClient schedulerRestClient) {
        this.schedulerRestClient = schedulerRestClient;
    }

    private SchedulerRestClient restApiClient() {
        return this.schedulerRestClient;
    }

    private <K, V> Map.Entry<K, V> toEntry(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    public void putThirdPartyCredential(String key, String value) throws SchedulerException {
        try {
            this.restApi().putThirdPartyCredential(this.sid, key, value);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public Set<String> thirdPartyCredentialsKeySet() throws SchedulerException {
        try {
            return this.restApi().thirdPartyCredentialsKeySet(this.sid);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public void removeThirdPartyCredential(String key) throws SchedulerException {
        try {
            this.restApi().removeThirdPartyCredential(this.sid, key);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public Page<TaskId> getTaskIds(String taskTag, long from, long to, boolean mytasks, Set<TaskStatus> taskStatuses, int offset, int limit) throws SchedulerException {
        RestPage page = null;
        try {
            page = this.restApi().getTaskStates(this.sid, from, to, mytasks, TaskStatus.statusesToString(taskStatuses), offset, limit, null);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
        ArrayList<TaskId> lTaskIds = new ArrayList<TaskId>(page.getList().size());
        for (TaskStateData taskStateData : page.getList()) {
            TaskInfoData taskInfo = taskStateData.getTaskInfo();
            TaskIdData taskIdData = taskInfo.getTaskId();
            JobIdImpl jobId = new JobIdImpl(taskInfo.getJobId().getId(), taskInfo.getJobId().getReadableName());
            TaskId taskId = TaskIdImpl.createTaskId((JobId)jobId, (String)taskIdData.getReadableName(), (long)taskIdData.getId());
            lTaskIds.add(taskId);
        }
        return new Page(lTaskIds, page.getSize());
    }

    public Page<TaskState> getTaskStates(String taskTag, long from, long to, boolean mytasks, Set<TaskStatus> statusFilter, int offset, int limit, SortSpecifierContainer sortParams) throws SchedulerException {
        RestPage page = null;
        SortSpecifierContainer sortContainer = new SortSpecifierContainer(sortParams.toString());
        try {
            page = this.restApi().getTaskStates(this.sid, from, to, mytasks, TaskStatus.statusFilterString(statusFilter), offset, limit, sortContainer);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
        ArrayList<TaskStateImpl> lTaskStates = new ArrayList<TaskStateImpl>(page.getList().size());
        for (TaskStateData taskStateData : page.getList()) {
            lTaskStates.add(new TaskStateImpl(taskStateData));
        }
        return new Page(lTaskStates, page.getSize());
    }

    public JobInfo getJobInfo(String jobId) throws SchedulerException {
        JobInfoData jobInfoData = null;
        try {
            jobInfoData = this.restApi().jobInfo(this.sid, jobId);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
        JobInfoImpl jobInfoImpl = new JobInfoImpl();
        JobId newJobId = JobIdImpl.makeJobId((String)jobId);
        jobInfoImpl.setJobId(newJobId);
        jobInfoImpl.setJobOwner(jobInfoData.getJobOwner());
        jobInfoImpl.setTenant(jobInfoData.getTenant());
        jobInfoImpl.setDomain(jobInfoData.getDomain());
        jobInfoImpl.setProjectName(jobInfoData.getProjectName());
        jobInfoImpl.setBucketName(jobInfoData.getBucketName());
        jobInfoImpl.setNumberOfNodes(jobInfoData.getNumberOfNodes());
        jobInfoImpl.setNumberOfNodesInParallel(jobInfoData.getNumberOfNodesInParallel());
        jobInfoImpl.setRemovedTime(jobInfoData.getRemovedTime());
        jobInfoImpl.setStartTime(jobInfoData.getStartTime());
        jobInfoImpl.setFinishedTime(jobInfoData.getFinishedTime());
        jobInfoImpl.setInErrorTime(jobInfoData.getInErrorTime());
        jobInfoImpl.setSubmittedTime(jobInfoData.getSubmittedTime());
        jobInfoImpl.setCumulatedCoreTime(jobInfoData.getCumulatedCoreTime());
        jobInfoImpl.setNumberOfFinishedTasks(jobInfoData.getNumberOfFinishedTasks());
        jobInfoImpl.setNumberOfPendingTasks(jobInfoData.getNumberOfPendingTasks());
        jobInfoImpl.setNumberOfRunningTasks(jobInfoData.getNumberOfRunningTasks());
        jobInfoImpl.setNumberOfInErrorTasks(jobInfoData.getNumberOfInErrorTasks());
        jobInfoImpl.setNumberOfFaultyTasks(jobInfoData.getNumberOfFaultyTasks());
        jobInfoImpl.setNumberOfFailedTasks(jobInfoData.getNumberOfFailedTasks());
        jobInfoImpl.setTotalNumberOfTasks(jobInfoData.getTotalNumberOfTasks());
        jobInfoImpl.setJobPriority(JobPriority.findPriority((String)jobInfoData.getPriority().toString()));
        jobInfoImpl.setJobStatus(JobStatus.findStatus((String)jobInfoData.getStatus().toString()));
        if (jobInfoData.isToBeRemoved()) {
            jobInfoImpl.setToBeRemoved();
        }
        jobInfoImpl.setPreciousTasks(jobInfoData.getPreciousTasks());
        jobInfoImpl.setGenericInformation(jobInfoData.getGenericInformation());
        jobInfoImpl.setVariables(jobInfoData.getVariables());
        jobInfoImpl.setDetailedVariables(jobInfoData.getDetailedVariables());
        jobInfoImpl.setSignals(jobInfoData.getSignals());
        jobInfoImpl.setDetailedSignals(jobInfoData.getDetailedSignals());
        jobInfoImpl.setVisualizationConnectionStrings(jobInfoData.getVisualizationConnectionStrings());
        jobInfoImpl.setVisualizationIcons(jobInfoData.getVisualizationIcons());
        jobInfoImpl.setAttachedServices(jobInfoData.getAttachedServices());
        jobInfoImpl.setExternalEndpointUrls(jobInfoData.getExternalEndpointUrls());
        jobInfoImpl.setParentId(jobInfoData.getParentId());
        jobInfoImpl.setChildrenCount(jobInfoData.getChildrenCount());
        jobInfoImpl.setResultMapPresent(jobInfoData.isResultMapPresent());
        jobInfoImpl.setLabel(jobInfoData.getLabel());
        jobInfoImpl.setSubmissionMode(jobInfoData.getSubmissionMode());
        return jobInfoImpl;
    }

    public boolean changeStartAt(JobId jobId, String startAt) throws NotConnectedException, UnknownJobException, PermissionException {
        boolean isJobStartAtChanged = false;
        try {
            isJobStartAtChanged = this.restApi().changeStartAt(this.sid, jobId.value(), startAt);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return isJobStartAtChanged;
    }

    public String getJobContent(JobId jobId) throws SchedulerException {
        try {
            return this.restApi().getJobContent(this.sid, jobId.value());
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public void enableRemoteVisualization(String jobId, String taskName, String connectionString) throws NotConnectedException, PermissionException, UnknownJobException, UnknownTaskException {
        try {
            this.restApi().enableRemoteVisualization(this.sid, jobId, taskName, connectionString);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPEOrUTE(e);
        }
    }

    public void registerService(String jobId, int serviceInstanceid, boolean enableActions) throws NotConnectedException, PermissionException, UnknownJobException {
        try {
            this.restApi().registerService(this.sid, jobId, serviceInstanceid, enableActions);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
    }

    public void detachService(String jobId, int serviceInstanceid) throws NotConnectedException, PermissionException, UnknownJobException {
        try {
            this.restApi().detachService(this.sid, jobId, serviceInstanceid);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
    }

    public Map<Object, Object> getPortalConfiguration() throws SchedulerException {
        try {
            return this.restApi().getPortalConfiguration(this.sid);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public String getCurrentUser() throws NotConnectedException {
        String connectedUser = this.restApi().getLoginFromSessionId(this.sid);
        if ("".equals(connectedUser)) {
            throw new NotConnectedException("Session " + this.sid + " is not connected");
        }
        return connectedUser;
    }

    public UserData getCurrentUserData() throws NotConnectedException {
        UserData connectedUserData = this.restApi().getUserDataFromSessionId(this.sid);
        if (connectedUserData == null) {
            throw new NotConnectedException("Session " + this.sid + " is not connected");
        }
        return connectedUserData;
    }

    public Subject getSubject() throws NotConnectedException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getSchedulerProperties() throws SchedulerException {
        try {
            return this.restApi().getSchedulerPropertiesFromSessionId(this.sid);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public TaskStatesPage getTaskPaginated(String jobId, int offset, int limit) throws NotConnectedException, UnknownJobException, PermissionException {
        TaskStatesPage taskStatesPage = null;
        try {
            int size = this.restApi().getJobTaskStates(this.sid, jobId).getList().size();
            List taskStates = this.restApi().getJobTaskStatesPaginated(this.sid, jobId, offset, limit).getList().stream().map(DataUtility::taskState).collect(Collectors.toList());
            taskStatesPage = new TaskStatesPage();
            taskStatesPage.setSize(size);
            taskStatesPage.setTaskStates(taskStates);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return taskStatesPage;
    }

    public TaskStatesPage getTaskPaginated(String jobId, String statusFilter, int offset, int limit) throws NotConnectedException, UnknownJobException, PermissionException {
        TaskStatesPage taskStatesPage = null;
        try {
            int size = this.restApi().getJobTaskStates(this.sid, jobId).getList().size();
            List taskStates = this.restApi().getJobTaskStatesFilteredPaginated(this.sid, jobId, offset, limit, statusFilter).getList().stream().map(DataUtility::taskState).collect(Collectors.toList());
            taskStatesPage = new TaskStatesPage();
            taskStatesPage.setSize(size);
            taskStatesPage.setTaskStates(taskStates);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return taskStatesPage;
    }

    public List<TaskResult> getPreciousTaskResults(String jobId) throws NotConnectedException, PermissionException, UnknownJobException {
        List taskStates = this.getJobState(jobId).getTasks().stream().filter(Task::isPreciousResult).collect(Collectors.toList());
        ArrayList<TaskResult> results = new ArrayList<TaskResult>(taskStates.size());
        for (TaskState currentState : taskStates) {
            String taskName = currentState.getTaskInfo().getName();
            try {
                TaskResult currentResult = this.getTaskResult(jobId, taskName);
                results.add(currentResult);
            }
            catch (UnknownTaskException ex) {
                logger.warn((Object)"Unknown task.", (Throwable)ex);
            }
        }
        return results;
    }

    public Map<Long, Map<String, Serializable>> getJobResultMaps(List<String> jobsId) throws NotConnectedException, UnknownJobException, PermissionException {
        HashMap<Long, Map<String, Serializable>> result = new HashMap<Long, Map<String, Serializable>>();
        try {
            Map map = this.restApi().jobResultMaps(this.sid, jobsId);
            for (Map.Entry entry : map.entrySet()) {
                HashMap resultMap = new HashMap();
                for (Map.Entry entryInEntry : ((Map)entry.getValue()).entrySet()) {
                    resultMap.put(entryInEntry.getKey(), entryInEntry.getValue());
                }
                result.put((Long)entry.getKey(), resultMap);
            }
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
        return result;
    }

    public Map<Long, List<String>> getPreciousTaskNames(List<String> jobsId) throws SchedulerException {
        try {
            return this.restApi().getPreciousTaskNames(this.sid, jobsId);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public boolean checkPermission(String method) throws SecurityException {
        try {
            return this.restApi().checkPermissionMethod(this.sid, method);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public boolean checkJobPermissionMethod(String jobId, String method) throws SchedulerException {
        try {
            return this.restApi().checkJobPermissionMethod(this.sid, method, jobId);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public List<String> checkJobsPermissionMethod(List<String> jobIds, String method) throws SchedulerException {
        try {
            return this.restApi().checkJobsPermissionMethod(this.sid, method, jobIds);
        }
        catch (RestException e) {
            throw RestException.unwrapRestException((RestException)e);
        }
    }

    public Set<String> addJobSignal(String jobId, String signal, Map<String, String> updatedVariables) throws NotConnectedException, UnknownJobException, PermissionException, SignalApiException {
        Set<String> result = new HashSet<String>();
        try {
            result = this.restApi().addJobSignalWithVariables(this.sid, signal, jobId, updatedVariables);
        }
        catch (Exception e) {
            ExceptionUtility.throwSAEorUJEOrNCEOrPE(e);
        }
        return result;
    }

    public List<JobVariable> validateJobSignal(String jobId, String signal, Map<String, String> updatedVariables) throws NotConnectedException, UnknownJobException, PermissionException, SignalApiException {
        LinkedList<JobVariable> jobVariables = new LinkedList<JobVariable>();
        try {
            JobValidationData data = this.restApi().validateJobSignal(this.sid, signal, jobId, updatedVariables);
            data.getUpdatedVariables().forEach((k, v) -> jobVariables.add(new JobVariable(k, v)));
            data.getUpdatedAdvanced().forEach((k, v) -> jobVariables.stream().filter(jobVariable -> jobVariable.getName().equals(k)).findFirst().get().setAdvanced(v.booleanValue()));
            data.getUpdatedHidden().forEach((k, v) -> jobVariables.stream().filter(jobVariable -> jobVariable.getName().equals(k)).findFirst().get().setHidden(v.booleanValue()));
            data.getUpdatedDescriptions().forEach((k, v) -> jobVariables.stream().filter(jobVariable -> jobVariable.getName().equals(k)).findFirst().get().setDescription(v));
            data.getUpdatedGroups().forEach((k, v) -> jobVariables.stream().filter(jobVariable -> jobVariable.getName().equals(k)).findFirst().get().setGroup(v));
            data.getUpdatedModels().forEach((k, v) -> jobVariables.stream().filter(jobVariable -> jobVariable.getName().equals(k)).findFirst().get().setModel(v));
        }
        catch (Exception e) {
            ExceptionUtility.throwSAEorUJEOrNCEOrPE(e);
        }
        return jobVariables;
    }

    private HttpClientBuilder getHttpClientBuilder() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
    }

    private JobId submitFromCatalog(String objectUrl, Map<String, String> variables, Map<String, String> genericInfos) throws SubmissionClosedException, JobCreationException, NotConnectedException, PermissionException {
        JobIdData jobIdData = null;
        try {
            genericInfos = new LinkedHashMap<String, String>(SchedulerClient.setSubmissionModeToGenericInfo(genericInfos));
            jobIdData = this.restApiClient().submitUrl(this.sid, objectUrl, variables, genericInfos);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPEOrSCEOrJCE(e);
        }
        return DataUtility.jobId(jobIdData);
    }

    private String getBucketFromCalledWorkflow(String calledWorkflow) {
        try {
            return calledWorkflow.split("/")[0];
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Impossible to parse the PA:CATALOG_OBJECT: %s, parsing error when getting the workflow bucket", calledWorkflow), e);
        }
    }

    private String getNameFromCalledWorkflow(String calledWorkflow) {
        try {
            return calledWorkflow.split("/")[1];
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Impossible to parse the PA:CATALOG_OBJECT: %s, parsing error when getting the workflow name", calledWorkflow), e);
        }
    }

    private Optional<String> getRevisionFromCalledWorkflow(String calledWorkflow) {
        try {
            return Optional.of(calledWorkflow.split("/")[2]);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Map<String, String> setSubmissionModeToGenericInfo(Map<String, String> genericInformation) {
        LinkedHashMap<String, String> newGenericInformation;
        LinkedHashMap<String, String> linkedHashMap = newGenericInformation = genericInformation == null ? new LinkedHashMap<String, String>() : new LinkedHashMap<String, String>(genericInformation);
        if (!newGenericInformation.containsKey(SchedulerConstants.SUBMISSION_MODE)) {
            newGenericInformation.put(SchedulerConstants.SUBMISSION_MODE, SchedulerConstants.SUBMISSION_MODE_WORKFLOW_API);
        }
        return newGenericInformation;
    }

    public Map<String, Map<String, Boolean>> checkJobsPermissionMethods(List<String> jobIds, List<String> methods) throws UnknownJobException, NotConnectedException {
        Map<String, Map<String, Boolean>> answer = new HashMap<String, Map<String, Boolean>>(jobIds.size());
        try {
            PermissionForm permissionForm = new PermissionForm();
            permissionForm.setJobids(jobIds);
            permissionForm.setMethods(methods);
            answer = this.restApi().checkJobsPermissionMethods(this.sid, permissionForm);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCE(e);
        }
        return answer;
    }

    public void addExternalEndpointUrl(String jobId, String endpointName, String externalEndpointUrl, String endpointIconUri) throws NotConnectedException, PermissionException, UnknownJobException {
        try {
            if (endpointName == null) {
                throw new IllegalArgumentException("endpointName cannot be null");
            }
            if (externalEndpointUrl == null) {
                throw new IllegalArgumentException("externalEndpointUrl cannot be null");
            }
            this.restApi().addExternalEndpointUrl(this.sid, jobId, endpointName, externalEndpointUrl, endpointIconUri);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
    }

    public void removeExternalEndpointUrl(String jobId, String endpointName) throws NotConnectedException, PermissionException, UnknownJobException {
        try {
            this.restApi().removeExternalEndpointUrl(this.sid, jobId, endpointName);
        }
        catch (Exception e) {
            ExceptionUtility.throwUJEOrNCEOrPE(e);
        }
    }

    public List<JobLabelInfo> getLabels() throws PermissionException, NotConnectedException {
        try {
            return DataUtility.toJobLabelsInfo(this.restApi().getLabels(this.sid));
        }
        catch (RestException e) {
            ExceptionUtility.throwNCEOrPE((Exception)((Object)e));
            return null;
        }
    }

    public List<JobLabelInfo> createLabels(List<String> labels) throws NotConnectedException, PermissionException {
        try {
            return DataUtility.toJobLabelsInfo(this.restApi().createLabels(this.sid, labels));
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
            return null;
        }
    }

    public List<JobLabelInfo> setLabels(List<String> labels) throws NotConnectedException, PermissionException {
        try {
            return DataUtility.toJobLabelsInfo(this.restApi().setLabels(this.sid, labels));
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
            return null;
        }
    }

    public JobLabelInfo updateLabel(String labelId, String newLabel) throws NotConnectedException, PermissionException {
        try {
            return DataUtility.toJobLabelInfo(this.restApi().updateLabel(this.sid, labelId, newLabel));
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
            return null;
        }
    }

    public void deleteLabel(String labelId) throws NotConnectedException, PermissionException {
        try {
            this.restApi().deleteLabel(this.sid, labelId);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
    }

    public void setLabelOnJobs(String labelId, List<String> jobIds) throws NotConnectedException, PermissionException {
        try {
            this.restApi().setLabelOnJobs(this.sid, labelId, jobIds);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
    }

    public void removeJobLabels(List<String> jobIds) throws NotConnectedException, PermissionException {
        try {
            this.restApi().removeJobLabels(this.sid, jobIds);
        }
        catch (Exception e) {
            ExceptionUtility.throwNCEOrPE(e);
        }
    }
}

