# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """How to authenticate users who access local diagnostics APIs."""

    AAD = "AAD"
    """Use AAD SSO to authenticate the user (this requires internet access)."""
    PASSWORD = "Password"
    """Use locally stored passwords to authenticate the user."""


class BillingSku(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The SKU of the packet core control plane resource. The SKU list may change over time when a new
    SKU gets added or an exiting SKU gets removed.
    """

    G0 = "G0"
    """100 Mbps, 20 active SIMs plan, 2 RANs"""
    G1 = "G1"
    """1 Gbps, 100 active SIMs plan, 5 RANs"""
    G2 = "G2"
    """2 Gbps, 200 active SIMs plan, 10 RANs"""
    G5 = "G5"
    """5 Gbps, 500 active SIMs plan"""
    G10 = "G10"
    """10 Gbps, 1000 active SIMs plan"""


class CertificateProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The certificate's provisioning state."""

    NOT_PROVISIONED = "NotProvisioned"
    """The certificate has not been provisioned."""
    PROVISIONED = "Provisioned"
    """The certificate has been provisioned."""
    FAILED = "Failed"
    """The certificate failed to be provisioned. The "reason" property explains why."""


class CoreNetworkType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The core network technology generation (5G core, EPC / 4G core or EPC / 4G + 5G core)."""

    FIVE_GC = "5GC"
    """5G core"""
    EPC = "EPC"
    """EPC / 4G core"""
    EPC5_GC = "EPC + 5GC"
    """Combined EPC / 4G and 5G core"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DesiredInstallationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The desired installation state of the packet core."""

    UNINSTALLED = "Uninstalled"
    """Don't install the packet core."""
    INSTALLED = "Installed"
    """Install the packet core."""


class DiagnosticsPackageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the diagnostics package collection."""

    NOT_STARTED = "NotStarted"
    COLLECTING = "Collecting"
    COLLECTED = "Collected"
    ERROR = "Error"


class InstallationReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for the installation state of the packet core."""

    NO_SLICES = "NoSlices"
    """The mobile network does not have any applicable configured slices."""
    NO_PACKET_CORE_DATA_PLANE = "NoPacketCoreDataPlane"
    """There is no configured data plane for this packet core."""
    NO_ATTACHED_DATA_NETWORKS = "NoAttachedDataNetworks"
    """The packet core has no attached data networks."""


class InstallationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The installation state of the packet core."""

    UNINSTALLED = "Uninstalled"
    """The packet core is uninstalled."""
    INSTALLING = "Installing"
    """The packet core is installing."""
    INSTALLED = "Installed"
    """The packet core is installed."""
    UPDATING = "Updating"
    """The packet core is updating its configuration."""
    UPGRADING = "Upgrading"
    """The packet core is upgrading to a different software version."""
    UNINSTALLING = "Uninstalling"
    """The packet core is uninstalling."""
    REINSTALLING = "Reinstalling"
    """The packet core is reinstalling."""
    ROLLING_BACK = "RollingBack"
    """The packet core is rolling back to its previous version."""
    FAILED = "Failed"
    """The packet core is in failed state."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (currently only UserAssigned allowed)."""

    NONE = "None"
    USER_ASSIGNED = "UserAssigned"


class NaptEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether network address and port translation is enabled."""

    ENABLED = "Enabled"
    """NAPT is enabled"""
    DISABLED = "Disabled"
    """NAPT is disabled"""


class ObsoleteVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether this version is obsolete."""

    OBSOLETE = "Obsolete"
    """This version is obsolete for use in new packet core control plane deployments."""
    NOT_OBSOLETE = "NotObsolete"
    """This version is not obsolete for use in new packet core control plane deployments."""


class PacketCaptureStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the packet capture session."""

    NOT_STARTED = "NotStarted"
    RUNNING = "Running"
    STOPPED = "Stopped"
    ERROR = "Error"


class PduSessionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PDU session type (IPv4/IPv6)."""

    I_PV4 = "IPv4"
    I_PV6 = "IPv6"


class PlatformType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The platform type where packet core is deployed. The contents of this enum can change."""

    AKS_HCI = "AKS-HCI"
    """If this option is chosen, you must set one of "azureStackEdgeDevice", "connectedCluster" or
    #: "customLocation". If multiple are set, they must be consistent with each other."""
    THREE_P_AZURE_STACK_HCI = "3P-AZURE-STACK-HCI"
    """If this option is chosen, you must set one of "azureStackHciCluster", "connectedCluster" or
    #: "customLocation". If multiple are set, they must be consistent with each other."""


class PreemptionCapability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preemption capability."""

    NOT_PREEMPT = "NotPreempt"
    """Cannot preempt"""
    MAY_PREEMPT = "MayPreempt"
    """May preempt"""


class PreemptionVulnerability(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Preemption vulnerability."""

    NOT_PREEMPTABLE = "NotPreemptable"
    """Cannot be preempted"""
    PREEMPTABLE = "Preemptable"
    """May be preempted"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    UNKNOWN = "Unknown"
    SUCCEEDED = "Succeeded"
    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"


class RecommendedVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether this is the recommended version to use for new packet core control plane
    deployments.
    """

    RECOMMENDED = "Recommended"
    """This is the recommended version to use for new packet core control plane deployments."""
    NOT_RECOMMENDED = "NotRecommended"
    """This is not the recommended version to use for new packet core control plane deployments."""


class ReinstallRequired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether a reinstall of the packet core is required to pick up the latest configuration changes."""

    REQUIRED = "Required"
    """A reinstall of the packet core is required."""
    NOT_REQUIRED = "NotRequired"
    """A reinstall of the packet core is not required."""


class SdfDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Service data flow direction."""

    UPLINK = "Uplink"
    """Traffic flowing from the UE to the data network."""
    DOWNLINK = "Downlink"
    """Traffic flowing from the data network to the UE."""
    BIDIRECTIONAL = "Bidirectional"
    """Traffic flowing both to and from the UE."""


class SimState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the SIM resource."""

    DISABLED = "Disabled"
    """The SIM is disabled because not all configuration required for enabling is present."""
    ENABLED = "Enabled"
    """The SIM is enabled."""
    INVALID = "Invalid"
    """The SIM cannot be enabled because some of the associated configuration is invalid."""


class SiteProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource e.g. SIM/SIM policy on a site."""

    NOT_APPLICABLE = "NotApplicable"
    """The resource should not be provisioned on this site."""
    ADDING = "Adding"
    """The resource is being added to this site."""
    UPDATING = "Updating"
    """The resource is being updated on this site."""
    DELETING = "Deleting"
    """The resource is being deleted from this site."""
    PROVISIONED = "Provisioned"
    """The resource is provisioned on this site."""
    FAILED = "Failed"
    """The resource failed to be provisioned on this site."""


class TrafficControlPermission(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Traffic control permission."""

    ENABLED = "Enabled"
    """Traffic matching this rule is allowed to flow."""
    BLOCKED = "Blocked"
    """Traffic matching this rule is not allowed to flow."""


class VersionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of this packet core control plane version."""

    UNKNOWN = "Unknown"
    """The state of this version is unknown."""
    PREVIEW = "Preview"
    """This version is a preview and is not suitable for production use."""
    VALIDATING = "Validating"
    """This version is currently being validated."""
    VALIDATION_FAILED = "ValidationFailed"
    """This version failed validation."""
    ACTIVE = "Active"
    """This version is active and suitable for production use."""
    DEPRECATED = "Deprecated"
    """This version is deprecated and is no longer supported."""
