use std::convert::Infallible;
use std::fmt;

use axum::extract::FromRequestParts;
use axum::http::header;
use axum::http::request::Parts;

#[derive(Clone, Debug, PartialEq, Eq)]
pub struct RawContentType(String);

impl fmt::Display for RawContentType {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        self.0.fmt(f)
    }
}

impl AsRef<str> for RawContentType {
    fn as_ref(&self) -> &str {
        &self.0
    }
}

impl<S: Send + Sync> FromRequestParts<S> for RawContentType {
    type Rejection = Infallible;

    async fn from_request_parts(parts: &mut Parts, _: &S) -> Result<Self, Self::Rejection> {
        let mime = parts
            .headers
            .get(header::CONTENT_TYPE)
            .and_then(|v| v.to_str().ok())
            .unwrap_or("")
            .to_owned();

        Ok(Self(mime))
    }
}
