//! Implements the sentry event protocol.

mod base;
mod breadcrumb;
mod breakdowns;
mod client_report;
mod clientsdk;
mod constants;
mod contexts;
mod debugmeta;
mod device_class;
mod event;
mod exception;
mod fingerprint;
mod logentry;
mod measurements;
mod mechanism;
mod metrics;
mod metrics_summary;
mod nel;
mod ourlog;
mod relay_info;
mod replay;
mod request;
mod security_report;
mod session;
mod span;
mod stacktrace;
mod tags;
mod templateinfo;
mod thread;
mod transaction;
mod types;
mod user;
mod user_report;
mod utils;

#[doc(inline)]
pub use relay_base_schema::{events::*, spans::*};

pub use self::breadcrumb::*;
pub use self::breakdowns::*;
pub use self::client_report::*;
pub use self::clientsdk::*;
pub use self::constants::*;
pub use self::contexts::*;
pub use self::debugmeta::*;
pub use self::device_class::*;
pub use self::event::*;
pub use self::exception::*;
pub use self::fingerprint::*;
pub use self::logentry::*;
pub use self::measurements::*;
pub use self::mechanism::*;
pub use self::metrics::*;
pub use self::metrics_summary::*;
pub use self::nel::*;
pub use self::ourlog::*;
pub use self::relay_info::*;
pub use self::replay::*;
pub use self::request::*;
pub use self::security_report::*;
pub use self::session::*;
pub use self::span::*;
pub use self::stacktrace::*;
pub use self::tags::*;
pub use self::templateinfo::*;
pub use self::thread::*;
pub use self::transaction::*;
pub use self::types::*;
pub use self::user::*;
pub use self::user_report::*;
