import numpy as np
from flopy.mbase import Package

class ModflowPbc(Package):
    'Periodic boundary condition class'
    def __init__(self, model, layer_row_column_shead_ehead=None, cosines=None, extension ='pbc', unitnumber=30):
        Package.__init__(self, model, extension, 'PBC', unitnumber) # Call ancestor's init to set self.parent, extension, name and unit number
        self.heading = '# PBC for MODFLOW, generated by Flopy.'
        self.mxactp = 0
        self.mxactp, self.layer_row_column_shead_ehead = self.assign_layer_row_column_data(layer_row_column_shead_ehead, 5)
        self.mxcos, self.cosines = self.assign_layer_row_column_data(cosines, 3)
        '''self.mxcos = 0
        if (cosines != None):
            error_message = 'cosines must have 3 columns'
            if (not isinstance(cosines, list)):
                cosines = [cosines]
            for a in cosines:
                a = np.atleast_2d(a)
                nr, nc = a.shape
                assert nc == 3, error_message
                if (nr > self.mxcos):
                    self.mxcos = nr
            self.cosines = cosines'''
        self.np = 0
        self.parent.add_package(self)
    def __repr__( self ):
        return 'Periodic boundary condition class'
    def ncells( self):
        # Returns the  maximum number of cells that have recharge (developped for MT3DMS SSM package)
        return self.mxactp
    def write_file(self):
        f_pbc = open(self.fn_path, 'w')
        f_pbc.write('%s\n' % self.heading)
        f_pbc.write('%10i%10i\n' % (self.mxactp, self.mxcos))
        for n in range(self.parent.get_package('DIS').nper):
            if (n < len(self.layer_row_column_shead_ehead)):
                a = self.layer_row_column_shead_ehead[n]
                itmp = a.shape[0]
            else:
                itmp = -1
            if (n < len(self.cosines)):
                c = self.cosines[n]
                ctmp = c.shape[0]
            else:
                ctmp = -1
            f_pbc.write('%10i%10i%10i\n' % (itmp, ctmp, self.np))
            if (n < len(self.layer_row_column_shead_ehead)):
                for b in a:
                    f_pbc.write('%10i%10i%10i%10f%10f\n' % (b[0], b[1], b[2], b[3], b[4]) )
            if (n < len(self.cosines)):
                for d in c:
                    f_pbc.write('%10f%10f%10f\n' % (d[0], d[1], d[2]) )
        f_pbc.close()

