/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class CommandResultHolder {
    private static final Log logger = LogFactory.getLog(CommandResultHolder.class);
    private static final String poisonResult = "CommandResultHolder.POISON";
    protected static final String CMD_TIMED_OUT_MSG = "ERROR: Command timed out";
    protected static final String CMD_NULL_RESULT_MSG = "ERROR: Got a null result";
    private final String queueId;
    private final SingleEntryAsyncQueue<String> holder;

    public CommandResultHolder(String queueId, int timeoutInSeconds) {
        this.holder = new SingleEntryAsyncQueue(timeoutInSeconds);
        this.holder.setPoison(poisonResult);
        this.queueId = queueId;
    }

    public String getResult() {
        String result;
        if (logger.isDebugEnabled()) {
            logger.debug(this.hdr() + "called");
        }
        if (null == (result = this.holder.pollToGetContentUntilTimeout())) {
            result = CMD_TIMED_OUT_MSG;
        } else if (this.holder.isPoison(result)) {
            result = CMD_NULL_RESULT_MSG;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder(this.hdr() + "-> " + result);
            if (CMD_TIMED_OUT_MSG.equals(result)) {
                msg.append(" after ").append(this.holder.getTimeoutInSeconds()).append(" seconds.");
            }
            logger.debug(msg.toString());
        }
        return result;
    }

    public boolean putResult(String res) {
        return this.holder.putContent(res);
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public String peek() {
        return this.holder.peek();
    }

    public void poisonPollers() {
        this.holder.poisonPollers();
    }

    private String hdr() {
        return "\t" + CommandQueue.getIdentification("commandResultHolder", this.queueId) + " getResult() ";
    }
}

