# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Submission(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, assignment_id=None, assignment=None, course=None, attempt=None, body=None, grade=None, grade_matches_current_submission=None, html_url=None, preview_url=None, score=None, submission_comments=None, submission_type=None, submitted_at=None, url=None, user_id=None, grader_id=None, user=None, late=None, assignment_visible=None, excused=None):
        """
        Submission - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'assignment_id': 'int',
            'assignment': 'str',
            'course': 'str',
            'attempt': 'int',
            'body': 'str',
            'grade': 'str',
            'grade_matches_current_submission': 'bool',
            'html_url': 'str',
            'preview_url': 'str',
            'score': 'float',
            'submission_comments': 'list[SubmissionComment]',
            'submission_type': 'str',
            'submitted_at': 'Datetime',
            'url': 'str',
            'user_id': 'int',
            'grader_id': 'int',
            'user': 'str',
            'late': 'bool',
            'assignment_visible': 'bool',
            'excused': 'bool'
        }

        self.attribute_map = {
            'assignment_id': 'assignment_id',
            'assignment': 'assignment',
            'course': 'course',
            'attempt': 'attempt',
            'body': 'body',
            'grade': 'grade',
            'grade_matches_current_submission': 'grade_matches_current_submission',
            'html_url': 'html_url',
            'preview_url': 'preview_url',
            'score': 'score',
            'submission_comments': 'submission_comments',
            'submission_type': 'submission_type',
            'submitted_at': 'submitted_at',
            'url': 'url',
            'user_id': 'user_id',
            'grader_id': 'grader_id',
            'user': 'user',
            'late': 'late',
            'assignment_visible': 'assignment_visible',
            'excused': 'excused'
        }

        self._assignment_id = assignment_id
        self._assignment = assignment
        self._course = course
        self._attempt = attempt
        self._body = body
        self._grade = grade
        self._grade_matches_current_submission = grade_matches_current_submission
        self._html_url = html_url
        self._preview_url = preview_url
        self._score = score
        self._submission_comments = submission_comments
        self._submission_type = submission_type
        self._submitted_at = submitted_at
        self._url = url
        self._user_id = user_id
        self._grader_id = grader_id
        self._user = user
        self._late = late
        self._assignment_visible = assignment_visible
        self._excused = excused

    @property
    def assignment_id(self):
        """
        Gets the assignment_id of this Submission.
        The submission's assignment id

        :return: The assignment_id of this Submission.
        :rtype: int
        """
        return self._assignment_id

    @assignment_id.setter
    def assignment_id(self, assignment_id):
        """
        Sets the assignment_id of this Submission.
        The submission's assignment id

        :param assignment_id: The assignment_id of this Submission.
        :type: int
        """

        self._assignment_id = assignment_id

    @property
    def assignment(self):
        """
        Gets the assignment of this Submission.
        The submission's assignment (see the assignments API) (optional)

        :return: The assignment of this Submission.
        :rtype: str
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment):
        """
        Sets the assignment of this Submission.
        The submission's assignment (see the assignments API) (optional)

        :param assignment: The assignment of this Submission.
        :type: str
        """

        self._assignment = assignment

    @property
    def course(self):
        """
        Gets the course of this Submission.
        The submission's course (see the course API) (optional)

        :return: The course of this Submission.
        :rtype: str
        """
        return self._course

    @course.setter
    def course(self, course):
        """
        Sets the course of this Submission.
        The submission's course (see the course API) (optional)

        :param course: The course of this Submission.
        :type: str
        """

        self._course = course

    @property
    def attempt(self):
        """
        Gets the attempt of this Submission.
        This is the submission attempt number.

        :return: The attempt of this Submission.
        :rtype: int
        """
        return self._attempt

    @attempt.setter
    def attempt(self, attempt):
        """
        Sets the attempt of this Submission.
        This is the submission attempt number.

        :param attempt: The attempt of this Submission.
        :type: int
        """

        self._attempt = attempt

    @property
    def body(self):
        """
        Gets the body of this Submission.
        The content of the submission, if it was submitted directly in a text field.

        :return: The body of this Submission.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this Submission.
        The content of the submission, if it was submitted directly in a text field.

        :param body: The body of this Submission.
        :type: str
        """

        self._body = body

    @property
    def grade(self):
        """
        Gets the grade of this Submission.
        The grade for the submission, translated into the assignment grading scheme (so a letter grade, for example).

        :return: The grade of this Submission.
        :rtype: str
        """
        return self._grade

    @grade.setter
    def grade(self, grade):
        """
        Sets the grade of this Submission.
        The grade for the submission, translated into the assignment grading scheme (so a letter grade, for example).

        :param grade: The grade of this Submission.
        :type: str
        """

        self._grade = grade

    @property
    def grade_matches_current_submission(self):
        """
        Gets the grade_matches_current_submission of this Submission.
        A boolean flag which is false if the student has re-submitted since the submission was last graded.

        :return: The grade_matches_current_submission of this Submission.
        :rtype: bool
        """
        return self._grade_matches_current_submission

    @grade_matches_current_submission.setter
    def grade_matches_current_submission(self, grade_matches_current_submission):
        """
        Sets the grade_matches_current_submission of this Submission.
        A boolean flag which is false if the student has re-submitted since the submission was last graded.

        :param grade_matches_current_submission: The grade_matches_current_submission of this Submission.
        :type: bool
        """

        self._grade_matches_current_submission = grade_matches_current_submission

    @property
    def html_url(self):
        """
        Gets the html_url of this Submission.
        URL to the submission. This will require the user to log in.

        :return: The html_url of this Submission.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this Submission.
        URL to the submission. This will require the user to log in.

        :param html_url: The html_url of this Submission.
        :type: str
        """

        self._html_url = html_url

    @property
    def preview_url(self):
        """
        Gets the preview_url of this Submission.
        URL to the submission preview. This will require the user to log in.

        :return: The preview_url of this Submission.
        :rtype: str
        """
        return self._preview_url

    @preview_url.setter
    def preview_url(self, preview_url):
        """
        Sets the preview_url of this Submission.
        URL to the submission preview. This will require the user to log in.

        :param preview_url: The preview_url of this Submission.
        :type: str
        """

        self._preview_url = preview_url

    @property
    def score(self):
        """
        Gets the score of this Submission.
        The raw score

        :return: The score of this Submission.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this Submission.
        The raw score

        :param score: The score of this Submission.
        :type: float
        """

        self._score = score

    @property
    def submission_comments(self):
        """
        Gets the submission_comments of this Submission.
        Associated comments for a submission (optional)

        :return: The submission_comments of this Submission.
        :rtype: list[SubmissionComment]
        """
        return self._submission_comments

    @submission_comments.setter
    def submission_comments(self, submission_comments):
        """
        Sets the submission_comments of this Submission.
        Associated comments for a submission (optional)

        :param submission_comments: The submission_comments of this Submission.
        :type: list[SubmissionComment]
        """

        self._submission_comments = submission_comments

    @property
    def submission_type(self):
        """
        Gets the submission_type of this Submission.
        The types of submission ex: ('online_text_entry'|'online_url'|'online_upload'|'media_recording')

        :return: The submission_type of this Submission.
        :rtype: str
        """
        return self._submission_type

    @submission_type.setter
    def submission_type(self, submission_type):
        """
        Sets the submission_type of this Submission.
        The types of submission ex: ('online_text_entry'|'online_url'|'online_upload'|'media_recording')

        :param submission_type: The submission_type of this Submission.
        :type: str
        """

        self._submission_type = submission_type

    @property
    def submitted_at(self):
        """
        Gets the submitted_at of this Submission.
        The timestamp when the assignment was submitted

        :return: The submitted_at of this Submission.
        :rtype: Datetime
        """
        return self._submitted_at

    @submitted_at.setter
    def submitted_at(self, submitted_at):
        """
        Sets the submitted_at of this Submission.
        The timestamp when the assignment was submitted

        :param submitted_at: The submitted_at of this Submission.
        :type: Datetime
        """

        self._submitted_at = submitted_at

    @property
    def url(self):
        """
        Gets the url of this Submission.
        The URL of the submission (for 'online_url' submissions).

        :return: The url of this Submission.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Submission.
        The URL of the submission (for 'online_url' submissions).

        :param url: The url of this Submission.
        :type: str
        """

        self._url = url

    @property
    def user_id(self):
        """
        Gets the user_id of this Submission.
        The id of the user who created the submission

        :return: The user_id of this Submission.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this Submission.
        The id of the user who created the submission

        :param user_id: The user_id of this Submission.
        :type: int
        """

        self._user_id = user_id

    @property
    def grader_id(self):
        """
        Gets the grader_id of this Submission.
        The id of the user who graded the submission

        :return: The grader_id of this Submission.
        :rtype: int
        """
        return self._grader_id

    @grader_id.setter
    def grader_id(self, grader_id):
        """
        Sets the grader_id of this Submission.
        The id of the user who graded the submission

        :param grader_id: The grader_id of this Submission.
        :type: int
        """

        self._grader_id = grader_id

    @property
    def user(self):
        """
        Gets the user of this Submission.
        The submissions user (see user API) (optional)

        :return: The user of this Submission.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this Submission.
        The submissions user (see user API) (optional)

        :param user: The user of this Submission.
        :type: str
        """

        self._user = user

    @property
    def late(self):
        """
        Gets the late of this Submission.
        Whether the submission was made after the applicable due date

        :return: The late of this Submission.
        :rtype: bool
        """
        return self._late

    @late.setter
    def late(self, late):
        """
        Sets the late of this Submission.
        Whether the submission was made after the applicable due date

        :param late: The late of this Submission.
        :type: bool
        """

        self._late = late

    @property
    def assignment_visible(self):
        """
        Gets the assignment_visible of this Submission.
        Whether the assignment is visible to the user who submitted the assignment. Submissions where `assignment_visible` is false no longer count towards the student's grade and the assignment can no longer be accessed by the student. `assignment_visible` becomes false for submissions that do not have a grade and whose assignment is no longer assigned to the student's section.

        :return: The assignment_visible of this Submission.
        :rtype: bool
        """
        return self._assignment_visible

    @assignment_visible.setter
    def assignment_visible(self, assignment_visible):
        """
        Sets the assignment_visible of this Submission.
        Whether the assignment is visible to the user who submitted the assignment. Submissions where `assignment_visible` is false no longer count towards the student's grade and the assignment can no longer be accessed by the student. `assignment_visible` becomes false for submissions that do not have a grade and whose assignment is no longer assigned to the student's section.

        :param assignment_visible: The assignment_visible of this Submission.
        :type: bool
        """

        self._assignment_visible = assignment_visible

    @property
    def excused(self):
        """
        Gets the excused of this Submission.
        Whether the assignment is excused.  Excused assignments have no impact on a user's grade.

        :return: The excused of this Submission.
        :rtype: bool
        """
        return self._excused

    @excused.setter
    def excused(self, excused):
        """
        Sets the excused of this Submission.
        Whether the assignment is excused.  Excused assignments have no impact on a user's grade.

        :param excused: The excused of this Submission.
        :type: bool
        """

        self._excused = excused

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
