# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Role(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, label=None, role=None, base_role_type=None, account=None, workflow_state=None, permissions=None):
        """
        Role - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'label': 'str',
            'role': 'str',
            'base_role_type': 'str',
            'account': 'Account',
            'workflow_state': 'str',
            'permissions': 'dict'
        }

        self.attribute_map = {
            'label': 'label',
            'role': 'role',
            'base_role_type': 'base_role_type',
            'account': 'account',
            'workflow_state': 'workflow_state',
            'permissions': 'permissions'
        }

        self._label = label
        self._role = role
        self._base_role_type = base_role_type
        self._account = account
        self._workflow_state = workflow_state
        self._permissions = permissions

    @property
    def label(self):
        """
        Gets the label of this Role.
        The label of the role.

        :return: The label of this Role.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this Role.
        The label of the role.

        :param label: The label of this Role.
        :type: str
        """

        self._label = label

    @property
    def role(self):
        """
        Gets the role of this Role.
        The label of the role. (Deprecated alias for 'label')

        :return: The role of this Role.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this Role.
        The label of the role. (Deprecated alias for 'label')

        :param role: The role of this Role.
        :type: str
        """

        self._role = role

    @property
    def base_role_type(self):
        """
        Gets the base_role_type of this Role.
        The role type that is being used as a base for this role. For account-level roles, this is 'AccountMembership'. For course-level roles, it is an enrollment type.

        :return: The base_role_type of this Role.
        :rtype: str
        """
        return self._base_role_type

    @base_role_type.setter
    def base_role_type(self, base_role_type):
        """
        Sets the base_role_type of this Role.
        The role type that is being used as a base for this role. For account-level roles, this is 'AccountMembership'. For course-level roles, it is an enrollment type.

        :param base_role_type: The base_role_type of this Role.
        :type: str
        """

        self._base_role_type = base_role_type

    @property
    def account(self):
        """
        Gets the account of this Role.
        JSON representation of the account the role is in.

        :return: The account of this Role.
        :rtype: Account
        """
        return self._account

    @account.setter
    def account(self, account):
        """
        Sets the account of this Role.
        JSON representation of the account the role is in.

        :param account: The account of this Role.
        :type: Account
        """

        self._account = account

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this Role.
        The state of the role: 'active', 'inactive', or 'built_in'

        :return: The workflow_state of this Role.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this Role.
        The state of the role: 'active', 'inactive', or 'built_in'

        :param workflow_state: The workflow_state of this Role.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def permissions(self):
        """
        Gets the permissions of this Role.
        A dictionary of permissions keyed by name (see permissions input parameter in the 'Create a role' API).

        :return: The permissions of this Role.
        :rtype: dict
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """
        Sets the permissions of this Role.
        A dictionary of permissions keyed by name (see permissions input parameter in the 'Create a role' API).

        :param permissions: The permissions of this Role.
        :type: dict
        """

        self._permissions = permissions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
