# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizSubmission(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, quiz_id=None, user_id=None, submission_id=None, started_at=None, finished_at=None, end_at=None, attempt=None, extra_attempts=None, extra_time=None, manually_unlocked=None, time_spent=None, score=None, score_before_regrade=None, kept_score=None, fudge_points=None, has_seen_results=None, workflow_state=None):
        """
        QuizSubmission - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'quiz_id': 'int',
            'user_id': 'int',
            'submission_id': 'int',
            'started_at': 'datetime',
            'finished_at': 'datetime',
            'end_at': 'datetime',
            'attempt': 'int',
            'extra_attempts': 'int',
            'extra_time': 'int',
            'manually_unlocked': 'bool',
            'time_spent': 'int',
            'score': 'int',
            'score_before_regrade': 'int',
            'kept_score': 'int',
            'fudge_points': 'int',
            'has_seen_results': 'bool',
            'workflow_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'quiz_id': 'quiz_id',
            'user_id': 'user_id',
            'submission_id': 'submission_id',
            'started_at': 'started_at',
            'finished_at': 'finished_at',
            'end_at': 'end_at',
            'attempt': 'attempt',
            'extra_attempts': 'extra_attempts',
            'extra_time': 'extra_time',
            'manually_unlocked': 'manually_unlocked',
            'time_spent': 'time_spent',
            'score': 'score',
            'score_before_regrade': 'score_before_regrade',
            'kept_score': 'kept_score',
            'fudge_points': 'fudge_points',
            'has_seen_results': 'has_seen_results',
            'workflow_state': 'workflow_state'
        }

        self._id = id
        self._quiz_id = quiz_id
        self._user_id = user_id
        self._submission_id = submission_id
        self._started_at = started_at
        self._finished_at = finished_at
        self._end_at = end_at
        self._attempt = attempt
        self._extra_attempts = extra_attempts
        self._extra_time = extra_time
        self._manually_unlocked = manually_unlocked
        self._time_spent = time_spent
        self._score = score
        self._score_before_regrade = score_before_regrade
        self._kept_score = kept_score
        self._fudge_points = fudge_points
        self._has_seen_results = has_seen_results
        self._workflow_state = workflow_state

    @property
    def id(self):
        """
        Gets the id of this QuizSubmission.
        The ID of the quiz submission.

        :return: The id of this QuizSubmission.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizSubmission.
        The ID of the quiz submission.

        :param id: The id of this QuizSubmission.
        :type: int
        """

        self._id = id

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizSubmission.
        The ID of the Quiz the quiz submission belongs to.

        :return: The quiz_id of this QuizSubmission.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizSubmission.
        The ID of the Quiz the quiz submission belongs to.

        :param quiz_id: The quiz_id of this QuizSubmission.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def user_id(self):
        """
        Gets the user_id of this QuizSubmission.
        The ID of the Student that made the quiz submission.

        :return: The user_id of this QuizSubmission.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this QuizSubmission.
        The ID of the Student that made the quiz submission.

        :param user_id: The user_id of this QuizSubmission.
        :type: int
        """

        self._user_id = user_id

    @property
    def submission_id(self):
        """
        Gets the submission_id of this QuizSubmission.
        The ID of the Submission the quiz submission represents.

        :return: The submission_id of this QuizSubmission.
        :rtype: int
        """
        return self._submission_id

    @submission_id.setter
    def submission_id(self, submission_id):
        """
        Sets the submission_id of this QuizSubmission.
        The ID of the Submission the quiz submission represents.

        :param submission_id: The submission_id of this QuizSubmission.
        :type: int
        """

        self._submission_id = submission_id

    @property
    def started_at(self):
        """
        Gets the started_at of this QuizSubmission.
        The time at which the student started the quiz submission.

        :return: The started_at of this QuizSubmission.
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """
        Sets the started_at of this QuizSubmission.
        The time at which the student started the quiz submission.

        :param started_at: The started_at of this QuizSubmission.
        :type: datetime
        """

        self._started_at = started_at

    @property
    def finished_at(self):
        """
        Gets the finished_at of this QuizSubmission.
        The time at which the student submitted the quiz submission.

        :return: The finished_at of this QuizSubmission.
        :rtype: datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """
        Sets the finished_at of this QuizSubmission.
        The time at which the student submitted the quiz submission.

        :param finished_at: The finished_at of this QuizSubmission.
        :type: datetime
        """

        self._finished_at = finished_at

    @property
    def end_at(self):
        """
        Gets the end_at of this QuizSubmission.
        The time at which the quiz submission will be overdue, and be flagged as a late submission.

        :return: The end_at of this QuizSubmission.
        :rtype: datetime
        """
        return self._end_at

    @end_at.setter
    def end_at(self, end_at):
        """
        Sets the end_at of this QuizSubmission.
        The time at which the quiz submission will be overdue, and be flagged as a late submission.

        :param end_at: The end_at of this QuizSubmission.
        :type: datetime
        """

        self._end_at = end_at

    @property
    def attempt(self):
        """
        Gets the attempt of this QuizSubmission.
        For quizzes that allow multiple attempts, this field specifies the quiz submission attempt number.

        :return: The attempt of this QuizSubmission.
        :rtype: int
        """
        return self._attempt

    @attempt.setter
    def attempt(self, attempt):
        """
        Sets the attempt of this QuizSubmission.
        For quizzes that allow multiple attempts, this field specifies the quiz submission attempt number.

        :param attempt: The attempt of this QuizSubmission.
        :type: int
        """

        self._attempt = attempt

    @property
    def extra_attempts(self):
        """
        Gets the extra_attempts of this QuizSubmission.
        Number of times the student was allowed to re-take the quiz over the multiple-attempt limit.

        :return: The extra_attempts of this QuizSubmission.
        :rtype: int
        """
        return self._extra_attempts

    @extra_attempts.setter
    def extra_attempts(self, extra_attempts):
        """
        Sets the extra_attempts of this QuizSubmission.
        Number of times the student was allowed to re-take the quiz over the multiple-attempt limit.

        :param extra_attempts: The extra_attempts of this QuizSubmission.
        :type: int
        """

        self._extra_attempts = extra_attempts

    @property
    def extra_time(self):
        """
        Gets the extra_time of this QuizSubmission.
        Amount of extra time allowed for the quiz submission, in minutes.

        :return: The extra_time of this QuizSubmission.
        :rtype: int
        """
        return self._extra_time

    @extra_time.setter
    def extra_time(self, extra_time):
        """
        Sets the extra_time of this QuizSubmission.
        Amount of extra time allowed for the quiz submission, in minutes.

        :param extra_time: The extra_time of this QuizSubmission.
        :type: int
        """

        self._extra_time = extra_time

    @property
    def manually_unlocked(self):
        """
        Gets the manually_unlocked of this QuizSubmission.
        The student can take the quiz even if it's locked for everyone else

        :return: The manually_unlocked of this QuizSubmission.
        :rtype: bool
        """
        return self._manually_unlocked

    @manually_unlocked.setter
    def manually_unlocked(self, manually_unlocked):
        """
        Sets the manually_unlocked of this QuizSubmission.
        The student can take the quiz even if it's locked for everyone else

        :param manually_unlocked: The manually_unlocked of this QuizSubmission.
        :type: bool
        """

        self._manually_unlocked = manually_unlocked

    @property
    def time_spent(self):
        """
        Gets the time_spent of this QuizSubmission.
        Amount of time spent, in seconds.

        :return: The time_spent of this QuizSubmission.
        :rtype: int
        """
        return self._time_spent

    @time_spent.setter
    def time_spent(self, time_spent):
        """
        Sets the time_spent of this QuizSubmission.
        Amount of time spent, in seconds.

        :param time_spent: The time_spent of this QuizSubmission.
        :type: int
        """

        self._time_spent = time_spent

    @property
    def score(self):
        """
        Gets the score of this QuizSubmission.
        The score of the quiz submission, if graded.

        :return: The score of this QuizSubmission.
        :rtype: int
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this QuizSubmission.
        The score of the quiz submission, if graded.

        :param score: The score of this QuizSubmission.
        :type: int
        """

        self._score = score

    @property
    def score_before_regrade(self):
        """
        Gets the score_before_regrade of this QuizSubmission.
        The original score of the quiz submission prior to any re-grading.

        :return: The score_before_regrade of this QuizSubmission.
        :rtype: int
        """
        return self._score_before_regrade

    @score_before_regrade.setter
    def score_before_regrade(self, score_before_regrade):
        """
        Sets the score_before_regrade of this QuizSubmission.
        The original score of the quiz submission prior to any re-grading.

        :param score_before_regrade: The score_before_regrade of this QuizSubmission.
        :type: int
        """

        self._score_before_regrade = score_before_regrade

    @property
    def kept_score(self):
        """
        Gets the kept_score of this QuizSubmission.
        For quizzes that allow multiple attempts, this is the score that will be used, which might be the score of the latest, or the highest, quiz submission.

        :return: The kept_score of this QuizSubmission.
        :rtype: int
        """
        return self._kept_score

    @kept_score.setter
    def kept_score(self, kept_score):
        """
        Sets the kept_score of this QuizSubmission.
        For quizzes that allow multiple attempts, this is the score that will be used, which might be the score of the latest, or the highest, quiz submission.

        :param kept_score: The kept_score of this QuizSubmission.
        :type: int
        """

        self._kept_score = kept_score

    @property
    def fudge_points(self):
        """
        Gets the fudge_points of this QuizSubmission.
        Number of points the quiz submission's score was fudged by.

        :return: The fudge_points of this QuizSubmission.
        :rtype: int
        """
        return self._fudge_points

    @fudge_points.setter
    def fudge_points(self, fudge_points):
        """
        Sets the fudge_points of this QuizSubmission.
        Number of points the quiz submission's score was fudged by.

        :param fudge_points: The fudge_points of this QuizSubmission.
        :type: int
        """

        self._fudge_points = fudge_points

    @property
    def has_seen_results(self):
        """
        Gets the has_seen_results of this QuizSubmission.
        Whether the student has viewed their results to the quiz.

        :return: The has_seen_results of this QuizSubmission.
        :rtype: bool
        """
        return self._has_seen_results

    @has_seen_results.setter
    def has_seen_results(self, has_seen_results):
        """
        Sets the has_seen_results of this QuizSubmission.
        Whether the student has viewed their results to the quiz.

        :param has_seen_results: The has_seen_results of this QuizSubmission.
        :type: bool
        """

        self._has_seen_results = has_seen_results

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this QuizSubmission.
        The current state of the quiz submission. Possible values: ['untaken'|'pending_review'|'complete'|'settings_only'|'preview'].

        :return: The workflow_state of this QuizSubmission.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this QuizSubmission.
        The current state of the quiz submission. Possible values: ['untaken'|'pending_review'|'complete'|'settings_only'|'preview'].

        :param workflow_state: The workflow_state of this QuizSubmission.
        :type: str
        """

        self._workflow_state = workflow_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
