# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizStatisticsAnswerPointBiserial(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, answer_id=None, point_biserial=None, correct=None, distractor=None):
        """
        QuizStatisticsAnswerPointBiserial - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'answer_id': 'int',
            'point_biserial': 'float',
            'correct': 'bool',
            'distractor': 'bool'
        }

        self.attribute_map = {
            'answer_id': 'answer_id',
            'point_biserial': 'point_biserial',
            'correct': 'correct',
            'distractor': 'distractor'
        }

        self._answer_id = answer_id
        self._point_biserial = point_biserial
        self._correct = correct
        self._distractor = distractor

    @property
    def answer_id(self):
        """
        Gets the answer_id of this QuizStatisticsAnswerPointBiserial.
        ID of the answer the point biserial is for.

        :return: The answer_id of this QuizStatisticsAnswerPointBiserial.
        :rtype: int
        """
        return self._answer_id

    @answer_id.setter
    def answer_id(self, answer_id):
        """
        Sets the answer_id of this QuizStatisticsAnswerPointBiserial.
        ID of the answer the point biserial is for.

        :param answer_id: The answer_id of this QuizStatisticsAnswerPointBiserial.
        :type: int
        """

        self._answer_id = answer_id

    @property
    def point_biserial(self):
        """
        Gets the point_biserial of this QuizStatisticsAnswerPointBiserial.
        The point biserial value for this answer. Value ranges between -1 and 1.

        :return: The point_biserial of this QuizStatisticsAnswerPointBiserial.
        :rtype: float
        """
        return self._point_biserial

    @point_biserial.setter
    def point_biserial(self, point_biserial):
        """
        Sets the point_biserial of this QuizStatisticsAnswerPointBiserial.
        The point biserial value for this answer. Value ranges between -1 and 1.

        :param point_biserial: The point_biserial of this QuizStatisticsAnswerPointBiserial.
        :type: float
        """

        self._point_biserial = point_biserial

    @property
    def correct(self):
        """
        Gets the correct of this QuizStatisticsAnswerPointBiserial.
        Convenience attribute that denotes whether this is the correct answer as opposed to being a distractor. This is mutually exclusive with the `distractor` value

        :return: The correct of this QuizStatisticsAnswerPointBiserial.
        :rtype: bool
        """
        return self._correct

    @correct.setter
    def correct(self, correct):
        """
        Sets the correct of this QuizStatisticsAnswerPointBiserial.
        Convenience attribute that denotes whether this is the correct answer as opposed to being a distractor. This is mutually exclusive with the `distractor` value

        :param correct: The correct of this QuizStatisticsAnswerPointBiserial.
        :type: bool
        """

        self._correct = correct

    @property
    def distractor(self):
        """
        Gets the distractor of this QuizStatisticsAnswerPointBiserial.
        Convenience attribute that denotes whether this is a distractor answer and not the correct one. This is mutually exclusive with the `correct` value

        :return: The distractor of this QuizStatisticsAnswerPointBiserial.
        :rtype: bool
        """
        return self._distractor

    @distractor.setter
    def distractor(self, distractor):
        """
        Sets the distractor of this QuizStatisticsAnswerPointBiserial.
        Convenience attribute that denotes whether this is a distractor answer and not the correct one. This is mutually exclusive with the `correct` value

        :param distractor: The distractor of this QuizStatisticsAnswerPointBiserial.
        :type: bool
        """

        self._distractor = distractor

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
