# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class QuizreportsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: abort_generation_of_report_or_remove_previously_generated_one
    def abort_generation_of_report_or_remove_previously_generated_one(self, course_id, quiz_id, id, **kwargs):
        """
        Abort the generation of a report, or remove a previously generated one
        This API allows you to cancel a previous request you issued for a report to be generated. Or in the case of an already generated report, you'd like to remove it, perhaps to generate it another time with an updated version that provides new features.  You must check the report's generation status before attempting to use this interface. See the \"workflow_state\" property of the QuizReport's Progress object for more information. Only when the progress reports itself in a \"queued\" state can the generation be aborted.  *Responses*  - <code>204 No Content</code> if your request was accepted - <code>422 Unprocessable Entity</code> if the report is not being generated   or can not be aborted at this stage

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.abort_generation_of_report_or_remove_previously_generated_one_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method abort_generation_of_report_or_remove_previously_generated_one" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `abort_generation_of_report_or_remove_previously_generated_one`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `abort_generation_of_report_or_remove_previously_generated_one`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `abort_generation_of_report_or_remove_previously_generated_one`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/reports/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_quiz_report
    def create_quiz_report(self, course_id, quiz_id, quiz_report_report_type, **kwargs):
        """
        Create a quiz report
        Create and return a new report for this quiz. If a previously generated report matches the arguments and is still current (i.e. there have been no new submissions), it will be returned.  *Responses*  * <code>400 Bad Request</code> if the specified report type is invalid * <code>409 Conflict</code> if a quiz report of the specified type is already being   generated

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_quiz_report_with_http_info(course_id, quiz_id, quiz_report_report_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str quiz_report_report_type: The type of report to be generated. (required)
        :param bool quiz_report_includes_all_versions: Whether the report should consider all submissions or only the most recent. Defaults to false, ignored for item_analysis.
        :param Object include: Whether the output should include documents for the file and/or progress objects associated with this report. (Note: JSON-API only)
        :return: QuizReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'quiz_report_report_type', 'quiz_report_includes_all_versions', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_quiz_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_quiz_report`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `create_quiz_report`")
        # verify the required parameter 'quiz_report_report_type' is set
        if ('quiz_report_report_type' not in params) or (params['quiz_report_report_type'] is None):
            raise ValueError("Missing the required parameter `quiz_report_report_type` when calling `create_quiz_report`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/reports'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'quiz_report_report_type' in params:
            form_params.append(('quiz_report[report_type]', params['quiz_report_report_type']))
        if 'quiz_report_includes_all_versions' in params:
            form_params.append(('quiz_report[includes_all_versions]', params['quiz_report_includes_all_versions']))
        if 'include' in params:
            form_params.append(('include', params['include']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QuizReport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_quiz_report
    def get_quiz_report(self, course_id, quiz_id, id, **kwargs):
        """
        Get a quiz report
        Returns the data for a single quiz report.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quiz_report_with_http_info(course_id, quiz_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param str id: ID (required)
        :param Object include: Whether the output should include documents for the file and/or progress objects associated with this report. (Note: JSON-API only)
        :return: QuizReport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quiz_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_quiz_report`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `get_quiz_report`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_quiz_report`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/reports/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QuizReport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: retrieve_all_quiz_reports
    def retrieve_all_quiz_reports(self, course_id, quiz_id, **kwargs):
        """
        Retrieve all quiz reports
        Returns a list of all available reports.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.retrieve_all_quiz_reports_with_http_info(course_id, quiz_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str quiz_id: ID (required)
        :param bool includes_all_versions: Whether to retrieve reports that consider all the submissions or only the most recent. Defaults to false, ignored for item_analysis reports.
        :return: list[QuizReport_]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'quiz_id', 'includes_all_versions']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_all_quiz_reports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `retrieve_all_quiz_reports`")
        # verify the required parameter 'quiz_id' is set
        if ('quiz_id' not in params) or (params['quiz_id'] is None):
            raise ValueError("Missing the required parameter `quiz_id` when calling `retrieve_all_quiz_reports`")

        resource_path = '/v1/courses/{course_id}/quizzes/{quiz_id}/reports'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'quiz_id' in params:
            path_params['quiz_id'] = params['quiz_id']

        query_params = {}
        if 'includes_all_versions' in params:
            query_params['includes_all_versions'] = params['includes_all_versions']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[QuizReport_]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
