# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class QuizQuestion(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, quiz_id=None, position=None, question_name=None, question_type=None, question_text=None, points_possible=None, correct_comments=None, incorrect_comments=None, neutral_comments=None, answers=None):
        """
        QuizQuestion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'quiz_id': 'int',
            'position': 'int',
            'question_name': 'str',
            'question_type': 'str',
            'question_text': 'str',
            'points_possible': 'int',
            'correct_comments': 'str',
            'incorrect_comments': 'str',
            'neutral_comments': 'str',
            'answers': 'list[Answer]'
        }

        self.attribute_map = {
            'id': 'id',
            'quiz_id': 'quiz_id',
            'position': 'position',
            'question_name': 'question_name',
            'question_type': 'question_type',
            'question_text': 'question_text',
            'points_possible': 'points_possible',
            'correct_comments': 'correct_comments',
            'incorrect_comments': 'incorrect_comments',
            'neutral_comments': 'neutral_comments',
            'answers': 'answers'
        }

        self._id = id
        self._quiz_id = quiz_id
        self._position = position
        self._question_name = question_name
        self._question_type = question_type
        self._question_text = question_text
        self._points_possible = points_possible
        self._correct_comments = correct_comments
        self._incorrect_comments = incorrect_comments
        self._neutral_comments = neutral_comments
        self._answers = answers

    @property
    def id(self):
        """
        Gets the id of this QuizQuestion.
        The ID of the quiz question.

        :return: The id of this QuizQuestion.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QuizQuestion.
        The ID of the quiz question.

        :param id: The id of this QuizQuestion.
        :type: int
        """

        self._id = id

    @property
    def quiz_id(self):
        """
        Gets the quiz_id of this QuizQuestion.
        The ID of the Quiz the question belongs to.

        :return: The quiz_id of this QuizQuestion.
        :rtype: int
        """
        return self._quiz_id

    @quiz_id.setter
    def quiz_id(self, quiz_id):
        """
        Sets the quiz_id of this QuizQuestion.
        The ID of the Quiz the question belongs to.

        :param quiz_id: The quiz_id of this QuizQuestion.
        :type: int
        """

        self._quiz_id = quiz_id

    @property
    def position(self):
        """
        Gets the position of this QuizQuestion.
        The order in which the question will be retrieved and displayed.

        :return: The position of this QuizQuestion.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this QuizQuestion.
        The order in which the question will be retrieved and displayed.

        :param position: The position of this QuizQuestion.
        :type: int
        """

        self._position = position

    @property
    def question_name(self):
        """
        Gets the question_name of this QuizQuestion.
        The name of the question.

        :return: The question_name of this QuizQuestion.
        :rtype: str
        """
        return self._question_name

    @question_name.setter
    def question_name(self, question_name):
        """
        Sets the question_name of this QuizQuestion.
        The name of the question.

        :param question_name: The question_name of this QuizQuestion.
        :type: str
        """

        self._question_name = question_name

    @property
    def question_type(self):
        """
        Gets the question_type of this QuizQuestion.
        The type of the question.

        :return: The question_type of this QuizQuestion.
        :rtype: str
        """
        return self._question_type

    @question_type.setter
    def question_type(self, question_type):
        """
        Sets the question_type of this QuizQuestion.
        The type of the question.

        :param question_type: The question_type of this QuizQuestion.
        :type: str
        """

        self._question_type = question_type

    @property
    def question_text(self):
        """
        Gets the question_text of this QuizQuestion.
        The text of the question.

        :return: The question_text of this QuizQuestion.
        :rtype: str
        """
        return self._question_text

    @question_text.setter
    def question_text(self, question_text):
        """
        Sets the question_text of this QuizQuestion.
        The text of the question.

        :param question_text: The question_text of this QuizQuestion.
        :type: str
        """

        self._question_text = question_text

    @property
    def points_possible(self):
        """
        Gets the points_possible of this QuizQuestion.
        The maximum amount of points possible received for getting this question correct.

        :return: The points_possible of this QuizQuestion.
        :rtype: int
        """
        return self._points_possible

    @points_possible.setter
    def points_possible(self, points_possible):
        """
        Sets the points_possible of this QuizQuestion.
        The maximum amount of points possible received for getting this question correct.

        :param points_possible: The points_possible of this QuizQuestion.
        :type: int
        """

        self._points_possible = points_possible

    @property
    def correct_comments(self):
        """
        Gets the correct_comments of this QuizQuestion.
        The comments to display if the student answers the question correctly.

        :return: The correct_comments of this QuizQuestion.
        :rtype: str
        """
        return self._correct_comments

    @correct_comments.setter
    def correct_comments(self, correct_comments):
        """
        Sets the correct_comments of this QuizQuestion.
        The comments to display if the student answers the question correctly.

        :param correct_comments: The correct_comments of this QuizQuestion.
        :type: str
        """

        self._correct_comments = correct_comments

    @property
    def incorrect_comments(self):
        """
        Gets the incorrect_comments of this QuizQuestion.
        The comments to display if the student answers incorrectly.

        :return: The incorrect_comments of this QuizQuestion.
        :rtype: str
        """
        return self._incorrect_comments

    @incorrect_comments.setter
    def incorrect_comments(self, incorrect_comments):
        """
        Sets the incorrect_comments of this QuizQuestion.
        The comments to display if the student answers incorrectly.

        :param incorrect_comments: The incorrect_comments of this QuizQuestion.
        :type: str
        """

        self._incorrect_comments = incorrect_comments

    @property
    def neutral_comments(self):
        """
        Gets the neutral_comments of this QuizQuestion.
        The comments to display regardless of how the student answered.

        :return: The neutral_comments of this QuizQuestion.
        :rtype: str
        """
        return self._neutral_comments

    @neutral_comments.setter
    def neutral_comments(self, neutral_comments):
        """
        Sets the neutral_comments of this QuizQuestion.
        The comments to display regardless of how the student answered.

        :param neutral_comments: The neutral_comments of this QuizQuestion.
        :type: str
        """

        self._neutral_comments = neutral_comments

    @property
    def answers(self):
        """
        Gets the answers of this QuizQuestion.
        An array of available answers to display to the student.

        :return: The answers of this QuizQuestion.
        :rtype: list[Answer]
        """
        return self._answers

    @answers.setter
    def answers(self, answers):
        """
        Sets the answers of this QuizQuestion.
        An array of available answers to display to the student.

        :param answers: The answers of this QuizQuestion.
        :type: list[Answer]
        """

        self._answers = answers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
