# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class PollSession(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, poll_id=None, course_id=None, course_section_id=None, is_published=None, has_public_results=None, created_at=None, results=None, poll_submissions=None):
        """
        PollSession - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'poll_id': 'int',
            'course_id': 'int',
            'course_section_id': 'int',
            'is_published': 'bool',
            'has_public_results': 'bool',
            'created_at': 'datetime',
            'results': 'object',
            'poll_submissions': 'PollSubmission'
        }

        self.attribute_map = {
            'id': 'id',
            'poll_id': 'poll_id',
            'course_id': 'course_id',
            'course_section_id': 'course_section_id',
            'is_published': 'is_published',
            'has_public_results': 'has_public_results',
            'created_at': 'created_at',
            'results': 'results',
            'poll_submissions': 'poll_submissions'
        }

        self._id = id
        self._poll_id = poll_id
        self._course_id = course_id
        self._course_section_id = course_section_id
        self._is_published = is_published
        self._has_public_results = has_public_results
        self._created_at = created_at
        self._results = results
        self._poll_submissions = poll_submissions

    @property
    def id(self):
        """
        Gets the id of this PollSession.
        The unique identifier for the poll session.

        :return: The id of this PollSession.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PollSession.
        The unique identifier for the poll session.

        :param id: The id of this PollSession.
        :type: int
        """

        self._id = id

    @property
    def poll_id(self):
        """
        Gets the poll_id of this PollSession.
        The id of the Poll this poll session is associated with

        :return: The poll_id of this PollSession.
        :rtype: int
        """
        return self._poll_id

    @poll_id.setter
    def poll_id(self, poll_id):
        """
        Sets the poll_id of this PollSession.
        The id of the Poll this poll session is associated with

        :param poll_id: The poll_id of this PollSession.
        :type: int
        """

        self._poll_id = poll_id

    @property
    def course_id(self):
        """
        Gets the course_id of this PollSession.
        The id of the Course this poll session is associated with

        :return: The course_id of this PollSession.
        :rtype: int
        """
        return self._course_id

    @course_id.setter
    def course_id(self, course_id):
        """
        Sets the course_id of this PollSession.
        The id of the Course this poll session is associated with

        :param course_id: The course_id of this PollSession.
        :type: int
        """

        self._course_id = course_id

    @property
    def course_section_id(self):
        """
        Gets the course_section_id of this PollSession.
        The id of the Course Section this poll session is associated with

        :return: The course_section_id of this PollSession.
        :rtype: int
        """
        return self._course_section_id

    @course_section_id.setter
    def course_section_id(self, course_section_id):
        """
        Sets the course_section_id of this PollSession.
        The id of the Course Section this poll session is associated with

        :param course_section_id: The course_section_id of this PollSession.
        :type: int
        """

        self._course_section_id = course_section_id

    @property
    def is_published(self):
        """
        Gets the is_published of this PollSession.
        Specifies whether or not this poll session has been published for students to participate in.

        :return: The is_published of this PollSession.
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """
        Sets the is_published of this PollSession.
        Specifies whether or not this poll session has been published for students to participate in.

        :param is_published: The is_published of this PollSession.
        :type: bool
        """

        self._is_published = is_published

    @property
    def has_public_results(self):
        """
        Gets the has_public_results of this PollSession.
        Specifies whether the results are viewable by students.

        :return: The has_public_results of this PollSession.
        :rtype: bool
        """
        return self._has_public_results

    @has_public_results.setter
    def has_public_results(self, has_public_results):
        """
        Sets the has_public_results of this PollSession.
        Specifies whether the results are viewable by students.

        :param has_public_results: The has_public_results of this PollSession.
        :type: bool
        """

        self._has_public_results = has_public_results

    @property
    def created_at(self):
        """
        Gets the created_at of this PollSession.
        The time at which the poll session was created.

        :return: The created_at of this PollSession.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this PollSession.
        The time at which the poll session was created.

        :param created_at: The created_at of this PollSession.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def results(self):
        """
        Gets the results of this PollSession.
        The results of the submissions of the poll. Each key is the poll choice id, and the value is the count of submissions.

        :return: The results of this PollSession.
        :rtype: object
        """
        return self._results

    @results.setter
    def results(self, results):
        """
        Sets the results of this PollSession.
        The results of the submissions of the poll. Each key is the poll choice id, and the value is the count of submissions.

        :param results: The results of this PollSession.
        :type: object
        """

        self._results = results

    @property
    def poll_submissions(self):
        """
        Gets the poll_submissions of this PollSession.
        If the poll session has public results, this will return an array of all submissions, viewable by both students and teachers. If the results are not public, for students it will return their submission only.

        :return: The poll_submissions of this PollSession.
        :rtype: PollSubmission
        """
        return self._poll_submissions

    @poll_submissions.setter
    def poll_submissions(self, poll_submissions):
        """
        Sets the poll_submissions of this PollSession.
        If the poll session has public results, this will return an array of all submissions, viewable by both students and teachers. If the results are not public, for students it will return their submission only.

        :param poll_submissions: The poll_submissions of this PollSession.
        :type: PollSubmission
        """

        self._poll_submissions = poll_submissions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
