# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ModuleItem(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, module_id=None, position=None, title=None, indent=None, type=None, content_id=None, html_url=None, url=None, page_url=None, external_url=None, new_tab=None, completion_requirement=None, content_details=None):
        """
        ModuleItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'module_id': 'int',
            'position': 'int',
            'title': 'str',
            'indent': 'int',
            'type': 'str',
            'content_id': 'int',
            'html_url': 'str',
            'url': 'str',
            'page_url': 'str',
            'external_url': 'str',
            'new_tab': 'bool',
            'completion_requirement': 'CompletionRequirement',
            'content_details': 'ContentDetails'
        }

        self.attribute_map = {
            'id': 'id',
            'module_id': 'module_id',
            'position': 'position',
            'title': 'title',
            'indent': 'indent',
            'type': 'type',
            'content_id': 'content_id',
            'html_url': 'html_url',
            'url': 'url',
            'page_url': 'page_url',
            'external_url': 'external_url',
            'new_tab': 'new_tab',
            'completion_requirement': 'completion_requirement',
            'content_details': 'content_details'
        }

        self._id = id
        self._module_id = module_id
        self._position = position
        self._title = title
        self._indent = indent
        self._type = type
        self._content_id = content_id
        self._html_url = html_url
        self._url = url
        self._page_url = page_url
        self._external_url = external_url
        self._new_tab = new_tab
        self._completion_requirement = completion_requirement
        self._content_details = content_details

    @property
    def id(self):
        """
        Gets the id of this ModuleItem.
        the unique identifier for the module item

        :return: The id of this ModuleItem.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ModuleItem.
        the unique identifier for the module item

        :param id: The id of this ModuleItem.
        :type: int
        """

        self._id = id

    @property
    def module_id(self):
        """
        Gets the module_id of this ModuleItem.
        the id of the Module this item appears in

        :return: The module_id of this ModuleItem.
        :rtype: int
        """
        return self._module_id

    @module_id.setter
    def module_id(self, module_id):
        """
        Sets the module_id of this ModuleItem.
        the id of the Module this item appears in

        :param module_id: The module_id of this ModuleItem.
        :type: int
        """

        self._module_id = module_id

    @property
    def position(self):
        """
        Gets the position of this ModuleItem.
        the position of this item in the module (1-based)

        :return: The position of this ModuleItem.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this ModuleItem.
        the position of this item in the module (1-based)

        :param position: The position of this ModuleItem.
        :type: int
        """

        self._position = position

    @property
    def title(self):
        """
        Gets the title of this ModuleItem.
        the title of this item

        :return: The title of this ModuleItem.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this ModuleItem.
        the title of this item

        :param title: The title of this ModuleItem.
        :type: str
        """

        self._title = title

    @property
    def indent(self):
        """
        Gets the indent of this ModuleItem.
        0-based indent level; module items may be indented to show a hierarchy

        :return: The indent of this ModuleItem.
        :rtype: int
        """
        return self._indent

    @indent.setter
    def indent(self, indent):
        """
        Sets the indent of this ModuleItem.
        0-based indent level; module items may be indented to show a hierarchy

        :param indent: The indent of this ModuleItem.
        :type: int
        """

        self._indent = indent

    @property
    def type(self):
        """
        Gets the type of this ModuleItem.
        the type of object referred to one of 'File', 'Page', 'Discussion', 'Assignment', 'Quiz', 'SubHeader', 'ExternalUrl', 'ExternalTool'

        :return: The type of this ModuleItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ModuleItem.
        the type of object referred to one of 'File', 'Page', 'Discussion', 'Assignment', 'Quiz', 'SubHeader', 'ExternalUrl', 'ExternalTool'

        :param type: The type of this ModuleItem.
        :type: str
        """

        self._type = type

    @property
    def content_id(self):
        """
        Gets the content_id of this ModuleItem.
        the id of the object referred to applies to 'File', 'Discussion', 'Assignment', 'Quiz', 'ExternalTool' types

        :return: The content_id of this ModuleItem.
        :rtype: int
        """
        return self._content_id

    @content_id.setter
    def content_id(self, content_id):
        """
        Sets the content_id of this ModuleItem.
        the id of the object referred to applies to 'File', 'Discussion', 'Assignment', 'Quiz', 'ExternalTool' types

        :param content_id: The content_id of this ModuleItem.
        :type: int
        """

        self._content_id = content_id

    @property
    def html_url(self):
        """
        Gets the html_url of this ModuleItem.
        link to the item in Canvas

        :return: The html_url of this ModuleItem.
        :rtype: str
        """
        return self._html_url

    @html_url.setter
    def html_url(self, html_url):
        """
        Sets the html_url of this ModuleItem.
        link to the item in Canvas

        :param html_url: The html_url of this ModuleItem.
        :type: str
        """

        self._html_url = html_url

    @property
    def url(self):
        """
        Gets the url of this ModuleItem.
        (Optional) link to the Canvas API object, if applicable

        :return: The url of this ModuleItem.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ModuleItem.
        (Optional) link to the Canvas API object, if applicable

        :param url: The url of this ModuleItem.
        :type: str
        """

        self._url = url

    @property
    def page_url(self):
        """
        Gets the page_url of this ModuleItem.
        (only for 'Page' type) unique locator for the linked wiki page

        :return: The page_url of this ModuleItem.
        :rtype: str
        """
        return self._page_url

    @page_url.setter
    def page_url(self, page_url):
        """
        Sets the page_url of this ModuleItem.
        (only for 'Page' type) unique locator for the linked wiki page

        :param page_url: The page_url of this ModuleItem.
        :type: str
        """

        self._page_url = page_url

    @property
    def external_url(self):
        """
        Gets the external_url of this ModuleItem.
        (only for 'ExternalUrl' and 'ExternalTool' types) external url that the item points to

        :return: The external_url of this ModuleItem.
        :rtype: str
        """
        return self._external_url

    @external_url.setter
    def external_url(self, external_url):
        """
        Sets the external_url of this ModuleItem.
        (only for 'ExternalUrl' and 'ExternalTool' types) external url that the item points to

        :param external_url: The external_url of this ModuleItem.
        :type: str
        """

        self._external_url = external_url

    @property
    def new_tab(self):
        """
        Gets the new_tab of this ModuleItem.
        (only for 'ExternalTool' type) whether the external tool opens in a new tab

        :return: The new_tab of this ModuleItem.
        :rtype: bool
        """
        return self._new_tab

    @new_tab.setter
    def new_tab(self, new_tab):
        """
        Sets the new_tab of this ModuleItem.
        (only for 'ExternalTool' type) whether the external tool opens in a new tab

        :param new_tab: The new_tab of this ModuleItem.
        :type: bool
        """

        self._new_tab = new_tab

    @property
    def completion_requirement(self):
        """
        Gets the completion_requirement of this ModuleItem.
        Completion requirement for this module item

        :return: The completion_requirement of this ModuleItem.
        :rtype: CompletionRequirement
        """
        return self._completion_requirement

    @completion_requirement.setter
    def completion_requirement(self, completion_requirement):
        """
        Sets the completion_requirement of this ModuleItem.
        Completion requirement for this module item

        :param completion_requirement: The completion_requirement of this ModuleItem.
        :type: CompletionRequirement
        """

        self._completion_requirement = completion_requirement

    @property
    def content_details(self):
        """
        Gets the content_details of this ModuleItem.
        (Present only if requested through include[]=content_details) If applicable, returns additional details specific to the associated object

        :return: The content_details of this ModuleItem.
        :rtype: ContentDetails
        """
        return self._content_details

    @content_details.setter
    def content_details(self, content_details):
        """
        Sets the content_details of this ModuleItem.
        (Present only if requested through include[]=content_details) If applicable, returns additional details specific to the associated object

        :param content_details: The content_details of this ModuleItem.
        :type: ContentDetails
        """

        self._content_details = content_details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
