# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ResultLinks(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, user=None, assessor=None, assessment=None):
        """
        ResultLinks - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'user': 'str',
            'assessor': 'str',
            'assessment': 'str'
        }

        self.attribute_map = {
            'user': 'user',
            'assessor': 'assessor',
            'assessment': 'assessment'
        }

        self._user = user
        self._assessor = assessor
        self._assessment = assessment

    @property
    def user(self):
        """
        Gets the user of this ResultLinks.
        A unique identifier for the user to whom this result applies

        :return: The user of this ResultLinks.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ResultLinks.
        A unique identifier for the user to whom this result applies

        :param user: The user of this ResultLinks.
        :type: str
        """

        self._user = user

    @property
    def assessor(self):
        """
        Gets the assessor of this ResultLinks.
        A unique identifier for the user who created this result

        :return: The assessor of this ResultLinks.
        :rtype: str
        """
        return self._assessor

    @assessor.setter
    def assessor(self, assessor):
        """
        Sets the assessor of this ResultLinks.
        A unique identifier for the user who created this result

        :param assessor: The assessor of this ResultLinks.
        :type: str
        """

        self._assessor = assessor

    @property
    def assessment(self):
        """
        Gets the assessment of this ResultLinks.
        A unique identifier for the assessment that this result is for

        :return: The assessment of this ResultLinks.
        :rtype: str
        """
        return self._assessment

    @assessment.setter
    def assessment(self, assessment):
        """
        Sets the assessment of this ResultLinks.
        A unique identifier for the assessment that this result is for

        :param assessment: The assessment of this ResultLinks.
        :type: str
        """

        self._assessment = assessment

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
