# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class GroupCategory(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, role=None, self_signup=None, auto_leader=None, context_type=None, account_id=None, group_limit=None, progress=None):
        """
        GroupCategory - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'role': 'str',
            'self_signup': 'str',
            'auto_leader': 'str',
            'context_type': 'str',
            'account_id': 'int',
            'group_limit': 'int',
            'progress': 'Progress'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'role': 'role',
            'self_signup': 'self_signup',
            'auto_leader': 'auto_leader',
            'context_type': 'context_type',
            'account_id': 'account_id',
            'group_limit': 'group_limit',
            'progress': 'progress'
        }

        self._id = id
        self._name = name
        self._role = role
        self._self_signup = self_signup
        self._auto_leader = auto_leader
        self._context_type = context_type
        self._account_id = account_id
        self._group_limit = group_limit
        self._progress = progress

    @property
    def id(self):
        """
        Gets the id of this GroupCategory.
        The ID of the group category.

        :return: The id of this GroupCategory.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this GroupCategory.
        The ID of the group category.

        :param id: The id of this GroupCategory.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this GroupCategory.
        The display name of the group category.

        :return: The name of this GroupCategory.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this GroupCategory.
        The display name of the group category.

        :param name: The name of this GroupCategory.
        :type: str
        """

        self._name = name

    @property
    def role(self):
        """
        Gets the role of this GroupCategory.
        Certain types of group categories have special role designations. Currently, these include: 'communities', 'student_organized', and 'imported'. Regular course/account group categories have a role of null.

        :return: The role of this GroupCategory.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this GroupCategory.
        Certain types of group categories have special role designations. Currently, these include: 'communities', 'student_organized', and 'imported'. Regular course/account group categories have a role of null.

        :param role: The role of this GroupCategory.
        :type: str
        """

        self._role = role

    @property
    def self_signup(self):
        """
        Gets the self_signup of this GroupCategory.
        If the group category allows users to join a group themselves, thought they may only be a member of one group per group category at a time. Values include 'restricted', 'enabled', and null 'enabled' allows students to assign themselves to a group 'restricted' restricts them to only joining a group in their section null disallows students from joining groups

        :return: The self_signup of this GroupCategory.
        :rtype: str
        """
        return self._self_signup

    @self_signup.setter
    def self_signup(self, self_signup):
        """
        Sets the self_signup of this GroupCategory.
        If the group category allows users to join a group themselves, thought they may only be a member of one group per group category at a time. Values include 'restricted', 'enabled', and null 'enabled' allows students to assign themselves to a group 'restricted' restricts them to only joining a group in their section null disallows students from joining groups

        :param self_signup: The self_signup of this GroupCategory.
        :type: str
        """

        self._self_signup = self_signup

    @property
    def auto_leader(self):
        """
        Gets the auto_leader of this GroupCategory.
        Gives instructors the ability to automatically have group leaders assigned.  Values include 'random', 'first', and null; 'random' picks a student from the group at random as the leader, 'first' sets the first student to be assigned to the group as the leader

        :return: The auto_leader of this GroupCategory.
        :rtype: str
        """
        return self._auto_leader

    @auto_leader.setter
    def auto_leader(self, auto_leader):
        """
        Sets the auto_leader of this GroupCategory.
        Gives instructors the ability to automatically have group leaders assigned.  Values include 'random', 'first', and null; 'random' picks a student from the group at random as the leader, 'first' sets the first student to be assigned to the group as the leader

        :param auto_leader: The auto_leader of this GroupCategory.
        :type: str
        """

        self._auto_leader = auto_leader

    @property
    def context_type(self):
        """
        Gets the context_type of this GroupCategory.
        The course or account that the category group belongs to. The pattern here is that whatever the context_type is, there will be an _id field named after that type. So if instead context_type was 'Course', the course_id field would be replaced by an course_id field.

        :return: The context_type of this GroupCategory.
        :rtype: str
        """
        return self._context_type

    @context_type.setter
    def context_type(self, context_type):
        """
        Sets the context_type of this GroupCategory.
        The course or account that the category group belongs to. The pattern here is that whatever the context_type is, there will be an _id field named after that type. So if instead context_type was 'Course', the course_id field would be replaced by an course_id field.

        :param context_type: The context_type of this GroupCategory.
        :type: str
        """

        self._context_type = context_type

    @property
    def account_id(self):
        """
        Gets the account_id of this GroupCategory.


        :return: The account_id of this GroupCategory.
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """
        Sets the account_id of this GroupCategory.


        :param account_id: The account_id of this GroupCategory.
        :type: int
        """

        self._account_id = account_id

    @property
    def group_limit(self):
        """
        Gets the group_limit of this GroupCategory.
        If self-signup is enabled, group_limit can be set to cap the number of users in each group. If null, there is no limit.

        :return: The group_limit of this GroupCategory.
        :rtype: int
        """
        return self._group_limit

    @group_limit.setter
    def group_limit(self, group_limit):
        """
        Sets the group_limit of this GroupCategory.
        If self-signup is enabled, group_limit can be set to cap the number of users in each group. If null, there is no limit.

        :param group_limit: The group_limit of this GroupCategory.
        :type: int
        """

        self._group_limit = group_limit

    @property
    def progress(self):
        """
        Gets the progress of this GroupCategory.
        If the group category has not yet finished a randomly student assignment request, a progress object will be attached, which will contain information related to the progress of the assignment request. Refer to the Progress API for more information

        :return: The progress of this GroupCategory.
        :rtype: Progress
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """
        Sets the progress of this GroupCategory.
        If the group category has not yet finished a randomly student assignment request, a progress object will be attached, which will contain information related to the progress of the assignment request. Refer to the Progress API for more information

        :param progress: The progress of this GroupCategory.
        :type: Progress
        """

        self._progress = progress

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
