# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class GroupcategoriesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: assign_unassigned_members
    def assign_unassigned_members(self, group_category_id, **kwargs):
        """
        Assign unassigned members
        Assign all unassigned members as evenly as possible among the existing student groups.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.assign_unassigned_members_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :param bool sync: The assigning is done asynchronously by default. If you would like to override this and have the assigning done synchronously, set this value to true.
        :return: GroupMembershipProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id', 'sync']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_unassigned_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `assign_unassigned_members`")

        resource_path = '/v1/group_categories/{group_category_id}/assign_unassigned_members'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'sync' in params:
            form_params.append(('sync', params['sync']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupMembershipProgress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_group_category_accounts
    def create_group_category_accounts(self, account_id, name, **kwargs):
        """
        Create a Group Category
        Create a new group category

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_group_category_accounts_with_http_info(account_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str name: Name of the group category (required)
        :param str self_signup: Allow students to sign up for a group themselves (Course Only). valid values are: \"enabled\":: allows students to self sign up for any group in course \"restricted\":: allows students to self sign up only for groups in the same section null disallows self sign up
        :param str auto_leader: Assigns group leaders automatically when generating and allocating students to groups Valid values are: \"first\":: the first student to be allocated to a group is the leader \"random\":: a random student from all members is chosen as the leader
        :param int group_limit: Limit the maximum number of users in each group (Course Only). Requires self signup.
        :param int create_group_count: Create this number of groups (Course Only).
        :param str split_group_count: (Deprecated) Create this number of groups, and evenly distribute students among them. not allowed with \"enable_self_signup\". because the group assignment happens synchronously, it's recommended that you instead use the assign_unassigned_members endpoint. (Course Only)
        :return: GroupCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'name', 'self_signup', 'auto_leader', 'group_limit', 'create_group_count', 'split_group_count']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_category_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_group_category_accounts`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_group_category_accounts`")

        resource_path = '/v1/accounts/{account_id}/group_categories'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'self_signup' in params:
            form_params.append(('self_signup', params['self_signup']))
        if 'auto_leader' in params:
            form_params.append(('auto_leader', params['auto_leader']))
        if 'group_limit' in params:
            form_params.append(('group_limit', params['group_limit']))
        if 'create_group_count' in params:
            form_params.append(('create_group_count', params['create_group_count']))
        if 'split_group_count' in params:
            form_params.append(('split_group_count', params['split_group_count']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_group_category_courses
    def create_group_category_courses(self, course_id, name, **kwargs):
        """
        Create a Group Category
        Create a new group category

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_group_category_courses_with_http_info(course_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str name: Name of the group category (required)
        :param str self_signup: Allow students to sign up for a group themselves (Course Only). valid values are: \"enabled\":: allows students to self sign up for any group in course \"restricted\":: allows students to self sign up only for groups in the same section null disallows self sign up
        :param str auto_leader: Assigns group leaders automatically when generating and allocating students to groups Valid values are: \"first\":: the first student to be allocated to a group is the leader \"random\":: a random student from all members is chosen as the leader
        :param int group_limit: Limit the maximum number of users in each group (Course Only). Requires self signup.
        :param int create_group_count: Create this number of groups (Course Only).
        :param str split_group_count: (Deprecated) Create this number of groups, and evenly distribute students among them. not allowed with \"enable_self_signup\". because the group assignment happens synchronously, it's recommended that you instead use the assign_unassigned_members endpoint. (Course Only)
        :return: GroupCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'name', 'self_signup', 'auto_leader', 'group_limit', 'create_group_count', 'split_group_count']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_category_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_group_category_courses`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_group_category_courses`")

        resource_path = '/v1/courses/{course_id}/group_categories'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'self_signup' in params:
            form_params.append(('self_signup', params['self_signup']))
        if 'auto_leader' in params:
            form_params.append(('auto_leader', params['auto_leader']))
        if 'group_limit' in params:
            form_params.append(('group_limit', params['group_limit']))
        if 'create_group_count' in params:
            form_params.append(('create_group_count', params['create_group_count']))
        if 'split_group_count' in params:
            form_params.append(('split_group_count', params['split_group_count']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_group_category
    def delete_group_category(self, group_category_id, **kwargs):
        """
        Delete a Group Category
        Deletes a group category and all groups under it. Protected group categories can not be deleted, i.e. \"communities\" and \"student_organized\".

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_group_category_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_group_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `delete_group_category`")

        resource_path = '/v1/group_categories/{group_category_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_group_category
    def get_single_group_category(self, group_category_id, **kwargs):
        """
        Get a single group category
        Returns the data for a single group category, or a 401 if the caller doesn't have the rights to see it.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_group_category_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :return: GroupCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_group_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `get_single_group_category`")

        resource_path = '/v1/group_categories/{group_category_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_group_categories_for_context_accounts
    def list_group_categories_for_context_accounts(self, account_id, **kwargs):
        """
        List group categories for a context
        Returns a list of group categories in a context

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_group_categories_for_context_accounts_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :return: list[GroupCategory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_group_categories_for_context_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_group_categories_for_context_accounts`")

        resource_path = '/v1/accounts/{account_id}/group_categories'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[GroupCategory]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_group_categories_for_context_courses
    def list_group_categories_for_context_courses(self, course_id, **kwargs):
        """
        List group categories for a context
        Returns a list of group categories in a context

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_group_categories_for_context_courses_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[GroupCategory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_group_categories_for_context_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_group_categories_for_context_courses`")

        resource_path = '/v1/courses/{course_id}/group_categories'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[GroupCategory]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_groups_in_group_category
    def list_groups_in_group_category(self, group_category_id, **kwargs):
        """
        List groups in group category
        Returns a list of groups in a group category

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_groups_in_group_category_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_groups_in_group_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `list_groups_in_group_category`")

        resource_path = '/v1/group_categories/{group_category_id}/groups'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Group]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_users_in_group_category
    def list_users_in_group_category(self, group_category_id, **kwargs):
        """
        List users in group category
        Returns a list of users in the group category.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_users_in_group_category_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :param str search_term: The partial name or full ID of the users to match and return in the results list. Must be at least 3 characters.
        :param bool unassigned: Set this value to true if you wish only to search unassigned users in the group category.
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id', 'search_term', 'unassigned']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_in_group_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `list_users_in_group_category`")

        resource_path = '/v1/group_categories/{group_category_id}/users'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'unassigned' in params:
            query_params['unassigned'] = params['unassigned']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_group_category
    def update_group_category(self, group_category_id, **kwargs):
        """
        Update a Group Category
        Modifies an existing group category.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_group_category_with_http_info(group_category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_category_id: ID (required)
        :param str name: Name of the group category
        :param str self_signup: Allow students to sign up for a group themselves (Course Only). Valid values are: \"enabled\":: allows students to self sign up for any group in course \"restricted\":: allows students to self sign up only for groups in the same section null disallows self sign up
        :param str auto_leader: Assigns group leaders automatically when generating and allocating students to groups Valid values are: \"first\":: the first student to be allocated to a group is the leader \"random\":: a random student from all members is chosen as the leader
        :param int group_limit: Limit the maximum number of users in each group (Course Only). Requires self signup.
        :param int create_group_count: Create this number of groups (Course Only).
        :param str split_group_count: (Deprecated) Create this number of groups, and evenly distribute students among them. not allowed with \"enable_self_signup\". because the group assignment happens synchronously, it's recommended that you instead use the assign_unassigned_members endpoint. (Course Only)
        :return: GroupCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_category_id', 'name', 'self_signup', 'auto_leader', 'group_limit', 'create_group_count', 'split_group_count']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_group_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_category_id' is set
        if ('group_category_id' not in params) or (params['group_category_id'] is None):
            raise ValueError("Missing the required parameter `group_category_id` when calling `update_group_category`")

        resource_path = '/v1/group_categories/{group_category_id}'.replace('{format}', 'json')
        path_params = {}
        if 'group_category_id' in params:
            path_params['group_category_id'] = params['group_category_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'self_signup' in params:
            form_params.append(('self_signup', params['self_signup']))
        if 'auto_leader' in params:
            form_params.append(('auto_leader', params['auto_leader']))
        if 'group_limit' in params:
            form_params.append(('group_limit', params['group_limit']))
        if 'create_group_count' in params:
            form_params.append(('create_group_count', params['create_group_count']))
        if 'split_group_count' in params:
            form_params.append(('split_group_count', params['split_group_count']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
