# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class SubmissionVersion(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, assignment_id=None, assignment_name=None, body=None, current_grade=None, current_graded_at=None, current_grader=None, grade_matches_current_submission=None, graded_at=None, grader=None, grader_id=None, id=None, new_grade=None, new_graded_at=None, new_grader=None, previous_grade=None, previous_graded_at=None, previous_grader=None, score=None, user_name=None, submission_type=None, url=None, user_id=None, workflow_state=None):
        """
        SubmissionVersion - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'assignment_id': 'int',
            'assignment_name': 'str',
            'body': 'str',
            'current_grade': 'str',
            'current_graded_at': 'Datetime',
            'current_grader': 'str',
            'grade_matches_current_submission': 'bool',
            'graded_at': 'Datetime',
            'grader': 'str',
            'grader_id': 'int',
            'id': 'int',
            'new_grade': 'str',
            'new_graded_at': 'Datetime',
            'new_grader': 'str',
            'previous_grade': 'str',
            'previous_graded_at': 'Datetime',
            'previous_grader': 'str',
            'score': 'int',
            'user_name': 'str',
            'submission_type': 'str',
            'url': 'str',
            'user_id': 'int',
            'workflow_state': 'str'
        }

        self.attribute_map = {
            'assignment_id': 'assignment_id',
            'assignment_name': 'assignment_name',
            'body': 'body',
            'current_grade': 'current_grade',
            'current_graded_at': 'current_graded_at',
            'current_grader': 'current_grader',
            'grade_matches_current_submission': 'grade_matches_current_submission',
            'graded_at': 'graded_at',
            'grader': 'grader',
            'grader_id': 'grader_id',
            'id': 'id',
            'new_grade': 'new_grade',
            'new_graded_at': 'new_graded_at',
            'new_grader': 'new_grader',
            'previous_grade': 'previous_grade',
            'previous_graded_at': 'previous_graded_at',
            'previous_grader': 'previous_grader',
            'score': 'score',
            'user_name': 'user_name',
            'submission_type': 'submission_type',
            'url': 'url',
            'user_id': 'user_id',
            'workflow_state': 'workflow_state'
        }

        self._assignment_id = assignment_id
        self._assignment_name = assignment_name
        self._body = body
        self._current_grade = current_grade
        self._current_graded_at = current_graded_at
        self._current_grader = current_grader
        self._grade_matches_current_submission = grade_matches_current_submission
        self._graded_at = graded_at
        self._grader = grader
        self._grader_id = grader_id
        self._id = id
        self._new_grade = new_grade
        self._new_graded_at = new_graded_at
        self._new_grader = new_grader
        self._previous_grade = previous_grade
        self._previous_graded_at = previous_graded_at
        self._previous_grader = previous_grader
        self._score = score
        self._user_name = user_name
        self._submission_type = submission_type
        self._url = url
        self._user_id = user_id
        self._workflow_state = workflow_state

    @property
    def assignment_id(self):
        """
        Gets the assignment_id of this SubmissionVersion.
        the id of the assignment this submissions is for

        :return: The assignment_id of this SubmissionVersion.
        :rtype: int
        """
        return self._assignment_id

    @assignment_id.setter
    def assignment_id(self, assignment_id):
        """
        Sets the assignment_id of this SubmissionVersion.
        the id of the assignment this submissions is for

        :param assignment_id: The assignment_id of this SubmissionVersion.
        :type: int
        """

        self._assignment_id = assignment_id

    @property
    def assignment_name(self):
        """
        Gets the assignment_name of this SubmissionVersion.
        the name of the assignment this submission is for

        :return: The assignment_name of this SubmissionVersion.
        :rtype: str
        """
        return self._assignment_name

    @assignment_name.setter
    def assignment_name(self, assignment_name):
        """
        Sets the assignment_name of this SubmissionVersion.
        the name of the assignment this submission is for

        :param assignment_name: The assignment_name of this SubmissionVersion.
        :type: str
        """

        self._assignment_name = assignment_name

    @property
    def body(self):
        """
        Gets the body of this SubmissionVersion.
        the body text of the submission

        :return: The body of this SubmissionVersion.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this SubmissionVersion.
        the body text of the submission

        :param body: The body of this SubmissionVersion.
        :type: str
        """

        self._body = body

    @property
    def current_grade(self):
        """
        Gets the current_grade of this SubmissionVersion.
        the most up to date grade for the current version of this submission

        :return: The current_grade of this SubmissionVersion.
        :rtype: str
        """
        return self._current_grade

    @current_grade.setter
    def current_grade(self, current_grade):
        """
        Sets the current_grade of this SubmissionVersion.
        the most up to date grade for the current version of this submission

        :param current_grade: The current_grade of this SubmissionVersion.
        :type: str
        """

        self._current_grade = current_grade

    @property
    def current_graded_at(self):
        """
        Gets the current_graded_at of this SubmissionVersion.
        the latest time stamp for the grading of this submission

        :return: The current_graded_at of this SubmissionVersion.
        :rtype: Datetime
        """
        return self._current_graded_at

    @current_graded_at.setter
    def current_graded_at(self, current_graded_at):
        """
        Sets the current_graded_at of this SubmissionVersion.
        the latest time stamp for the grading of this submission

        :param current_graded_at: The current_graded_at of this SubmissionVersion.
        :type: Datetime
        """

        self._current_graded_at = current_graded_at

    @property
    def current_grader(self):
        """
        Gets the current_grader of this SubmissionVersion.
        the name of the most recent grader for this submission

        :return: The current_grader of this SubmissionVersion.
        :rtype: str
        """
        return self._current_grader

    @current_grader.setter
    def current_grader(self, current_grader):
        """
        Sets the current_grader of this SubmissionVersion.
        the name of the most recent grader for this submission

        :param current_grader: The current_grader of this SubmissionVersion.
        :type: str
        """

        self._current_grader = current_grader

    @property
    def grade_matches_current_submission(self):
        """
        Gets the grade_matches_current_submission of this SubmissionVersion.
        boolean indicating whether the grade is equal to the current submission grade

        :return: The grade_matches_current_submission of this SubmissionVersion.
        :rtype: bool
        """
        return self._grade_matches_current_submission

    @grade_matches_current_submission.setter
    def grade_matches_current_submission(self, grade_matches_current_submission):
        """
        Sets the grade_matches_current_submission of this SubmissionVersion.
        boolean indicating whether the grade is equal to the current submission grade

        :param grade_matches_current_submission: The grade_matches_current_submission of this SubmissionVersion.
        :type: bool
        """

        self._grade_matches_current_submission = grade_matches_current_submission

    @property
    def graded_at(self):
        """
        Gets the graded_at of this SubmissionVersion.
        time stamp for the grading of this version of the submission

        :return: The graded_at of this SubmissionVersion.
        :rtype: Datetime
        """
        return self._graded_at

    @graded_at.setter
    def graded_at(self, graded_at):
        """
        Sets the graded_at of this SubmissionVersion.
        time stamp for the grading of this version of the submission

        :param graded_at: The graded_at of this SubmissionVersion.
        :type: Datetime
        """

        self._graded_at = graded_at

    @property
    def grader(self):
        """
        Gets the grader of this SubmissionVersion.
        the name of the user who graded this version of the submission

        :return: The grader of this SubmissionVersion.
        :rtype: str
        """
        return self._grader

    @grader.setter
    def grader(self, grader):
        """
        Sets the grader of this SubmissionVersion.
        the name of the user who graded this version of the submission

        :param grader: The grader of this SubmissionVersion.
        :type: str
        """

        self._grader = grader

    @property
    def grader_id(self):
        """
        Gets the grader_id of this SubmissionVersion.
        the user id of the user who graded this version of the submission

        :return: The grader_id of this SubmissionVersion.
        :rtype: int
        """
        return self._grader_id

    @grader_id.setter
    def grader_id(self, grader_id):
        """
        Sets the grader_id of this SubmissionVersion.
        the user id of the user who graded this version of the submission

        :param grader_id: The grader_id of this SubmissionVersion.
        :type: int
        """

        self._grader_id = grader_id

    @property
    def id(self):
        """
        Gets the id of this SubmissionVersion.
        the id of the submission of which this is a version

        :return: The id of this SubmissionVersion.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SubmissionVersion.
        the id of the submission of which this is a version

        :param id: The id of this SubmissionVersion.
        :type: int
        """

        self._id = id

    @property
    def new_grade(self):
        """
        Gets the new_grade of this SubmissionVersion.
        the updated grade provided in this version of the submission

        :return: The new_grade of this SubmissionVersion.
        :rtype: str
        """
        return self._new_grade

    @new_grade.setter
    def new_grade(self, new_grade):
        """
        Sets the new_grade of this SubmissionVersion.
        the updated grade provided in this version of the submission

        :param new_grade: The new_grade of this SubmissionVersion.
        :type: str
        """

        self._new_grade = new_grade

    @property
    def new_graded_at(self):
        """
        Gets the new_graded_at of this SubmissionVersion.
        the timestamp for the grading of this version of the submission (alias for graded_at)

        :return: The new_graded_at of this SubmissionVersion.
        :rtype: Datetime
        """
        return self._new_graded_at

    @new_graded_at.setter
    def new_graded_at(self, new_graded_at):
        """
        Sets the new_graded_at of this SubmissionVersion.
        the timestamp for the grading of this version of the submission (alias for graded_at)

        :param new_graded_at: The new_graded_at of this SubmissionVersion.
        :type: Datetime
        """

        self._new_graded_at = new_graded_at

    @property
    def new_grader(self):
        """
        Gets the new_grader of this SubmissionVersion.
        alias for 'grader'

        :return: The new_grader of this SubmissionVersion.
        :rtype: str
        """
        return self._new_grader

    @new_grader.setter
    def new_grader(self, new_grader):
        """
        Sets the new_grader of this SubmissionVersion.
        alias for 'grader'

        :param new_grader: The new_grader of this SubmissionVersion.
        :type: str
        """

        self._new_grader = new_grader

    @property
    def previous_grade(self):
        """
        Gets the previous_grade of this SubmissionVersion.
        the grade for the submission version immediately preceding this one

        :return: The previous_grade of this SubmissionVersion.
        :rtype: str
        """
        return self._previous_grade

    @previous_grade.setter
    def previous_grade(self, previous_grade):
        """
        Sets the previous_grade of this SubmissionVersion.
        the grade for the submission version immediately preceding this one

        :param previous_grade: The previous_grade of this SubmissionVersion.
        :type: str
        """

        self._previous_grade = previous_grade

    @property
    def previous_graded_at(self):
        """
        Gets the previous_graded_at of this SubmissionVersion.
        the timestamp for the grading of the submission version immediately preceding this one

        :return: The previous_graded_at of this SubmissionVersion.
        :rtype: Datetime
        """
        return self._previous_graded_at

    @previous_graded_at.setter
    def previous_graded_at(self, previous_graded_at):
        """
        Sets the previous_graded_at of this SubmissionVersion.
        the timestamp for the grading of the submission version immediately preceding this one

        :param previous_graded_at: The previous_graded_at of this SubmissionVersion.
        :type: Datetime
        """

        self._previous_graded_at = previous_graded_at

    @property
    def previous_grader(self):
        """
        Gets the previous_grader of this SubmissionVersion.
        the name of the grader who graded the version of this submission immediately preceding this one

        :return: The previous_grader of this SubmissionVersion.
        :rtype: str
        """
        return self._previous_grader

    @previous_grader.setter
    def previous_grader(self, previous_grader):
        """
        Sets the previous_grader of this SubmissionVersion.
        the name of the grader who graded the version of this submission immediately preceding this one

        :param previous_grader: The previous_grader of this SubmissionVersion.
        :type: str
        """

        self._previous_grader = previous_grader

    @property
    def score(self):
        """
        Gets the score of this SubmissionVersion.
        the score for this version of the submission

        :return: The score of this SubmissionVersion.
        :rtype: int
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this SubmissionVersion.
        the score for this version of the submission

        :param score: The score of this SubmissionVersion.
        :type: int
        """

        self._score = score

    @property
    def user_name(self):
        """
        Gets the user_name of this SubmissionVersion.
        the name of the student who created this submission

        :return: The user_name of this SubmissionVersion.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this SubmissionVersion.
        the name of the student who created this submission

        :param user_name: The user_name of this SubmissionVersion.
        :type: str
        """

        self._user_name = user_name

    @property
    def submission_type(self):
        """
        Gets the submission_type of this SubmissionVersion.
        the type of submission

        :return: The submission_type of this SubmissionVersion.
        :rtype: str
        """
        return self._submission_type

    @submission_type.setter
    def submission_type(self, submission_type):
        """
        Sets the submission_type of this SubmissionVersion.
        the type of submission

        :param submission_type: The submission_type of this SubmissionVersion.
        :type: str
        """

        self._submission_type = submission_type

    @property
    def url(self):
        """
        Gets the url of this SubmissionVersion.
        the url of the submission, if there is one

        :return: The url of this SubmissionVersion.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this SubmissionVersion.
        the url of the submission, if there is one

        :param url: The url of this SubmissionVersion.
        :type: str
        """

        self._url = url

    @property
    def user_id(self):
        """
        Gets the user_id of this SubmissionVersion.
        the user ID of the student who created this submission

        :return: The user_id of this SubmissionVersion.
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this SubmissionVersion.
        the user ID of the student who created this submission

        :param user_id: The user_id of this SubmissionVersion.
        :type: int
        """

        self._user_id = user_id

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this SubmissionVersion.
        the state of the submission at this version

        :return: The workflow_state of this SubmissionVersion.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this SubmissionVersion.
        the state of the submission at this version

        :param workflow_state: The workflow_state of this SubmissionVersion.
        :type: str
        """

        self._workflow_state = workflow_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
