# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class GradebookhistoryApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: days_in_gradebook_history_for_this_course
    def days_in_gradebook_history_for_this_course(self, course_id, **kwargs):
        """
        Days in gradebook history for this course
        Returns a map of dates to grader/assignment groups

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.days_in_gradebook_history_for_this_course_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int course_id: The id of the contextual course for this API call (required)
        :return: list[Day]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method days_in_gradebook_history_for_this_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `days_in_gradebook_history_for_this_course`")

        resource_path = '/v1/courses/{course_id}/gradebook_history/days'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Day]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: details_for_given_date_in_gradebook_history_for_this_course
    def details_for_given_date_in_gradebook_history_for_this_course(self, course_id, date, **kwargs):
        """
        Details for a given date in gradebook history for this course
        Returns the graders who worked on this day, along with the assignments they worked on. More details can be obtained by selecting a grader and assignment and calling the 'submissions' api endpoint for a given date.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.details_for_given_date_in_gradebook_history_for_this_course_with_http_info(course_id, date, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int course_id: The id of the contextual course for this API call (required)
        :param str date: The date for which you would like to see detailed information (required)
        :return: list[Grader]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'date']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method details_for_given_date_in_gradebook_history_for_this_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `details_for_given_date_in_gradebook_history_for_this_course`")
        # verify the required parameter 'date' is set
        if ('date' not in params) or (params['date'] is None):
            raise ValueError("Missing the required parameter `date` when calling `details_for_given_date_in_gradebook_history_for_this_course`")

        resource_path = '/v1/courses/{course_id}/gradebook_history/{date}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'date' in params:
            path_params['date'] = params['date']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Grader]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_uncollated_submission_versions
    def list_uncollated_submission_versions(self, course_id, **kwargs):
        """
        List uncollated submission versions
        Gives a paginated, uncollated list of submission versions for all matching submissions in the context. This SubmissionVersion objects will not include the +new_grade+ or +previous_grade+ keys, only the +grade+; same for +graded_at+ and +grader+.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_uncollated_submission_versions_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int course_id: The id of the contextual course for this API call (required)
        :param int assignment_id: The ID of the assignment for which you want to see submissions. If absent, versions of submissions from any assignment in the course are included.
        :param int user_id: The ID of the user for which you want to see submissions. If absent, versions of submissions from any user in the course are included.
        :param bool ascending: Returns submission versions in ascending date order (oldest first). If absent, returns submission versions in descending date order (newest first).
        :return: list[SubmissionVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'user_id', 'ascending']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_uncollated_submission_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_uncollated_submission_versions`")

        resource_path = '/v1/courses/{course_id}/gradebook_history/feed'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'assignment_id' in params:
            query_params['assignment_id'] = params['assignment_id']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'ascending' in params:
            query_params['ascending'] = params['ascending']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SubmissionVersion]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: lists_submissions
    def lists_submissions(self, course_id, date, grader_id, assignment_id, **kwargs):
        """
        Lists submissions
        Gives a nested list of submission versions

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.lists_submissions_with_http_info(course_id, date, grader_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int course_id: The id of the contextual course for this API call (required)
        :param str date: The date for which you would like to see submissions (required)
        :param int grader_id: The ID of the grader for which you want to see submissions (required)
        :param int assignment_id: The ID of the assignment for which you want to see submissions (required)
        :return: list[SubmissionHistory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'date', 'grader_id', 'assignment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lists_submissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `lists_submissions`")
        # verify the required parameter 'date' is set
        if ('date' not in params) or (params['date'] is None):
            raise ValueError("Missing the required parameter `date` when calling `lists_submissions`")
        # verify the required parameter 'grader_id' is set
        if ('grader_id' not in params) or (params['grader_id'] is None):
            raise ValueError("Missing the required parameter `grader_id` when calling `lists_submissions`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `lists_submissions`")

        resource_path = '/v1/courses/{course_id}/gradebook_history/{date}/graders/{grader_id}/assignments/{assignment_id}/submissions'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'date' in params:
            path_params['date'] = params['date']
        if 'grader_id' in params:
            path_params['grader_id'] = params['grader_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SubmissionHistory]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
