# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class CourseProgress(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, requirement_count=None, requirement_completed_count=None, next_requirement_url=None, completed_at=None):
        """
        CourseProgress - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'requirement_count': 'int',
            'requirement_completed_count': 'int',
            'next_requirement_url': 'str',
            'completed_at': 'Datetime'
        }

        self.attribute_map = {
            'requirement_count': 'requirement_count',
            'requirement_completed_count': 'requirement_completed_count',
            'next_requirement_url': 'next_requirement_url',
            'completed_at': 'completed_at'
        }

        self._requirement_count = requirement_count
        self._requirement_completed_count = requirement_completed_count
        self._next_requirement_url = next_requirement_url
        self._completed_at = completed_at

    @property
    def requirement_count(self):
        """
        Gets the requirement_count of this CourseProgress.
        total number of requirements from all modules

        :return: The requirement_count of this CourseProgress.
        :rtype: int
        """
        return self._requirement_count

    @requirement_count.setter
    def requirement_count(self, requirement_count):
        """
        Sets the requirement_count of this CourseProgress.
        total number of requirements from all modules

        :param requirement_count: The requirement_count of this CourseProgress.
        :type: int
        """

        self._requirement_count = requirement_count

    @property
    def requirement_completed_count(self):
        """
        Gets the requirement_completed_count of this CourseProgress.
        total number of requirements the user has completed from all modules

        :return: The requirement_completed_count of this CourseProgress.
        :rtype: int
        """
        return self._requirement_completed_count

    @requirement_completed_count.setter
    def requirement_completed_count(self, requirement_completed_count):
        """
        Sets the requirement_completed_count of this CourseProgress.
        total number of requirements the user has completed from all modules

        :param requirement_completed_count: The requirement_completed_count of this CourseProgress.
        :type: int
        """

        self._requirement_completed_count = requirement_completed_count

    @property
    def next_requirement_url(self):
        """
        Gets the next_requirement_url of this CourseProgress.
        url to next module item that has an unmet requirement. null if the user has completed the course or the current module does not require sequential progress

        :return: The next_requirement_url of this CourseProgress.
        :rtype: str
        """
        return self._next_requirement_url

    @next_requirement_url.setter
    def next_requirement_url(self, next_requirement_url):
        """
        Sets the next_requirement_url of this CourseProgress.
        url to next module item that has an unmet requirement. null if the user has completed the course or the current module does not require sequential progress

        :param next_requirement_url: The next_requirement_url of this CourseProgress.
        :type: str
        """

        self._next_requirement_url = next_requirement_url

    @property
    def completed_at(self):
        """
        Gets the completed_at of this CourseProgress.
        date the course was completed. null if the course has not been completed by this user

        :return: The completed_at of this CourseProgress.
        :rtype: Datetime
        """
        return self._completed_at

    @completed_at.setter
    def completed_at(self, completed_at):
        """
        Sets the completed_at of this CourseProgress.
        date the course was completed. null if the course has not been completed by this user

        :param completed_at: The completed_at of this CourseProgress.
        :type: Datetime
        """

        self._completed_at = completed_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
