# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class CoursesApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: conclude_course
    def conclude_course(self, id, event, **kwargs):
        """
        Conclude a course
        Delete or conclude an existing course

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.conclude_course_with_http_info(id, event, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param str event: The action to take on the course. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'event']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method conclude_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `conclude_course`")
        # verify the required parameter 'event' is set
        if ('event' not in params) or (params['event'] is None):
            raise ValueError("Missing the required parameter `event` when calling `conclude_course`")

        resource_path = '/v1/courses/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'event' in params:
            query_params['event'] = params['event']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: copy_course_content
    def copy_course_content(self, course_id, **kwargs):
        """
        Copy course content
        DEPRECATED: Please use the {api:ContentMigrationsController#create Content Migrations API}  Copies content from one course into another. The default is to copy all course content. You can control specific types to copy by using either the 'except' option or the 'only' option.  The response is the same as the course copy status endpoint

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.copy_course_content_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str source_course: ID or SIS-ID of the course to copy the content from
        :param list[str] _except: A list of the course content types to exclude, all areas not listed will be copied.
        :param list[str] only: A list of the course content types to copy, all areas not listed will not be copied.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'source_course', '_except', 'only']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_course_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `copy_course_content`")

        resource_path = '/v1/courses/{course_id}/course_copy'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'source_course' in params:
            form_params.append(('source_course', params['source_course']))
        if '_except' in params:
            form_params.append(('except', params['_except']))
        if 'only' in params:
            form_params.append(('only', params['only']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: course_activity_stream
    def course_activity_stream(self, course_id, **kwargs):
        """
        Course activity stream
        Returns the current user's course-specific activity stream, paginated.  For full documentation, see the API documentation for the user activity stream, in the user api.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.course_activity_stream_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method course_activity_stream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `course_activity_stream`")

        resource_path = '/v1/courses/{course_id}/activity_stream'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: course_activity_stream_summary
    def course_activity_stream_summary(self, course_id, **kwargs):
        """
        Course activity stream summary
        Returns a summary of the current user's course-specific activity stream.  For full documentation, see the API documentation for the user activity stream summary, in the user api.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.course_activity_stream_summary_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method course_activity_stream_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `course_activity_stream_summary`")

        resource_path = '/v1/courses/{course_id}/activity_stream/summary'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: course_todo_items
    def course_todo_items(self, course_id, **kwargs):
        """
        Course TODO items
        Returns the current user's course-specific todo items.  For full documentation, see the API documentation for the user todo items, in the user api.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.course_todo_items_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method course_todo_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `course_todo_items`")

        resource_path = '/v1/courses/{course_id}/todo'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_new_course
    def create_new_course(self, account_id, **kwargs):
        """
        Create a new course
        Create a new course

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_new_course_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int account_id: The unique ID of the account to create to course under. (required)
        :param str course_name: The name of the course. If omitted, the course will be named \"Unnamed Course.\"
        :param str course_course_code: The course code for the course.
        :param Object course_start_at: Course start date in ISO8601 format, e.g. 2011-01-01T01:00Z
        :param Object course_end_at: Course end date in ISO8601 format. e.g. 2011-01-01T01:00Z
        :param str course_license: The name of the licensing. Should be one of the following abbreviations (a descriptive name is included in parenthesis for reference): - 'private' (Private Copyrighted) - 'cc_by_nc_nd' (CC Attribution Non-Commercial No Derivatives) - 'cc_by_nc_sa' (CC Attribution Non-Commercial Share Alike) - 'cc_by_nc' (CC Attribution Non-Commercial) - 'cc_by_nd' (CC Attribution No Derivatives) - 'cc_by_sa' (CC Attribution Share Alike) - 'cc_by' (CC Attribution) - 'public_domain' (Public Domain).
        :param bool course_is_public: Set to true if course if public.
        :param bool course_is_public_to_auth_users: Set to true if course if public to authenticated users.
        :param bool course_public_syllabus: Set to true to make the course syllabus public.
        :param str course_public_description: A publicly visible description of the course.
        :param bool course_allow_student_wiki_edits: If true, students will be able to modify the course wiki.
        :param bool course_allow_wiki_comments: If true, course members will be able to comment on wiki pages.
        :param bool course_allow_student_forum_attachments: If true, students can attach files to forum posts.
        :param bool course_open_enrollment: Set to true if the course is open enrollment.
        :param bool course_self_enrollment: Set to true if the course is self enrollment.
        :param bool course_restrict_enrollments_to_course_dates: Set to true to restrict user enrollments to the start and end dates of the course.
        :param int course_term_id: The unique ID of the term to create to course in.
        :param str course_sis_course_id: The unique SIS identifier.
        :param str course_integration_id: The unique Integration identifier.
        :param bool course_hide_final_grades: If this option is set to true, the totals in student grades summary will be hidden.
        :param bool course_apply_assignment_group_weights: Set to true to weight final grade based on assignment groups percentages.
        :param bool offer: If this option is set to true, the course will be available to students immediately.
        :param bool enroll_me: Set to true to enroll the current user as the teacher.
        :param str course_syllabus_body: The syllabus body for the course
        :param int course_grading_standard_id: The grading standard id to set for the course. If no value is provided for this argument the current grading_standard will be un-set from this course.
        :param str course_course_format: Optional. Specifies the format of the course. (Should be either 'on_campus' or 'online')
        :return: Course
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'course_name', 'course_course_code', 'course_start_at', 'course_end_at', 'course_license', 'course_is_public', 'course_is_public_to_auth_users', 'course_public_syllabus', 'course_public_description', 'course_allow_student_wiki_edits', 'course_allow_wiki_comments', 'course_allow_student_forum_attachments', 'course_open_enrollment', 'course_self_enrollment', 'course_restrict_enrollments_to_course_dates', 'course_term_id', 'course_sis_course_id', 'course_integration_id', 'course_hide_final_grades', 'course_apply_assignment_group_weights', 'offer', 'enroll_me', 'course_syllabus_body', 'course_grading_standard_id', 'course_course_format']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_new_course`")

        resource_path = '/v1/accounts/{account_id}/courses'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'course_name' in params:
            form_params.append(('course[name]', params['course_name']))
        if 'course_course_code' in params:
            form_params.append(('course[course_code]', params['course_course_code']))
        if 'course_start_at' in params:
            form_params.append(('course[start_at]', params['course_start_at']))
        if 'course_end_at' in params:
            form_params.append(('course[end_at]', params['course_end_at']))
        if 'course_license' in params:
            form_params.append(('course[license]', params['course_license']))
        if 'course_is_public' in params:
            form_params.append(('course[is_public]', params['course_is_public']))
        if 'course_is_public_to_auth_users' in params:
            form_params.append(('course[is_public_to_auth_users]', params['course_is_public_to_auth_users']))
        if 'course_public_syllabus' in params:
            form_params.append(('course[public_syllabus]', params['course_public_syllabus']))
        if 'course_public_description' in params:
            form_params.append(('course[public_description]', params['course_public_description']))
        if 'course_allow_student_wiki_edits' in params:
            form_params.append(('course[allow_student_wiki_edits]', params['course_allow_student_wiki_edits']))
        if 'course_allow_wiki_comments' in params:
            form_params.append(('course[allow_wiki_comments]', params['course_allow_wiki_comments']))
        if 'course_allow_student_forum_attachments' in params:
            form_params.append(('course[allow_student_forum_attachments]', params['course_allow_student_forum_attachments']))
        if 'course_open_enrollment' in params:
            form_params.append(('course[open_enrollment]', params['course_open_enrollment']))
        if 'course_self_enrollment' in params:
            form_params.append(('course[self_enrollment]', params['course_self_enrollment']))
        if 'course_restrict_enrollments_to_course_dates' in params:
            form_params.append(('course[restrict_enrollments_to_course_dates]', params['course_restrict_enrollments_to_course_dates']))
        if 'course_term_id' in params:
            form_params.append(('course[term_id]', params['course_term_id']))
        if 'course_sis_course_id' in params:
            form_params.append(('course[sis_course_id]', params['course_sis_course_id']))
        if 'course_integration_id' in params:
            form_params.append(('course[integration_id]', params['course_integration_id']))
        if 'course_hide_final_grades' in params:
            form_params.append(('course[hide_final_grades]', params['course_hide_final_grades']))
        if 'course_apply_assignment_group_weights' in params:
            form_params.append(('course[apply_assignment_group_weights]', params['course_apply_assignment_group_weights']))
        if 'offer' in params:
            form_params.append(('offer', params['offer']))
        if 'enroll_me' in params:
            form_params.append(('enroll_me', params['enroll_me']))
        if 'course_syllabus_body' in params:
            form_params.append(('course[syllabus_body]', params['course_syllabus_body']))
        if 'course_grading_standard_id' in params:
            form_params.append(('course[grading_standard_id]', params['course_grading_standard_id']))
        if 'course_course_format' in params:
            form_params.append(('course[course_format]', params['course_course_format']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Course',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_course_copy_status
    def get_course_copy_status(self, course_id, id, **kwargs):
        """
        Get course copy status
        DEPRECATED: Please use the {api:ContentMigrationsController#create Content Migrations API}  Retrieve the status of a course copy

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_course_copy_status_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_course_copy_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_course_copy_status`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_course_copy_status`")

        resource_path = '/v1/courses/{course_id}/course_copy/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_course_settings
    def get_course_settings(self, course_id, **kwargs):
        """
        Get course settings
        Returns some of a course's settings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_course_settings_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_course_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_course_settings`")

        resource_path = '/v1/courses/{course_id}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_course_accounts
    def get_single_course_accounts(self, account_id, id, **kwargs):
        """
        Get a single course
        Return information on a single course.  Accepts the same include[] parameters as the list action plus:

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_course_accounts_with_http_info(account_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: - \"all_courses\": Also search recently deleted courses. - \"permissions\": Include permissions the current user has for the course.
        :return: Course
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_course_accounts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_single_course_accounts`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_course_accounts`")

        resource_path = '/v1/accounts/{account_id}/courses/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Course',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_course_courses
    def get_single_course_courses(self, id, **kwargs):
        """
        Get a single course
        Return information on a single course.  Accepts the same include[] parameters as the list action plus:

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_course_courses_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param list[str] include: - \"all_courses\": Also search recently deleted courses. - \"permissions\": Include permissions the current user has for the course.
        :return: Course
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'include']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_course_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_course_courses`")

        resource_path = '/v1/courses/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Course',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_user
    def get_single_user(self, course_id, id, **kwargs):
        """
        Get single user
        Return information on a single user.  Accepts the same include[] parameters as the :users: action, and returns a single user with the same fields as that action.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_user_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_user`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_user`")

        resource_path = '/v1/courses/{course_id}/users/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='User',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_recently_logged_in_students
    def list_recently_logged_in_students(self, course_id, **kwargs):
        """
        List recently logged in students
        Returns the list of users in this course, ordered by how recently they have logged in. The records include the 'last_login' field which contains a timestamp of the last time that user logged into canvas.  The querying user must have the 'View usage reports' permission.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_recently_logged_in_students_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_recently_logged_in_students" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_recently_logged_in_students`")

        resource_path = '/v1/courses/{course_id}/recent_students'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_students
    def list_students(self, course_id, **kwargs):
        """
        List students
        Returns the list of students enrolled in this course.  DEPRECATED: Please use the {api:CoursesController#users course users} endpoint and pass \"student\" as the enrollment_type.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_students_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_students" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_students`")

        resource_path = '/v1/courses/{course_id}/students'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_users_in_course_search_users
    def list_users_in_course_search_users(self, course_id, **kwargs):
        """
        List users in course
        Returns the list of users in this course. And optionally the user's enrollments in the course.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_users_in_course_search_users_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str search_term: The partial name or full ID of the users to match and return in the results list.
        :param str enrollment_type: When set, only return users where the user is enrolled as this type. This argument is ignored if enrollment_role is given.
        :param str enrollment_role: Deprecated When set, only return users enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a base role type of 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param int enrollment_role_id: When set, only return courses where the user is enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a built_in role id with type 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param list[str] include: - \"email\": Optional user email. - \"enrollments\": Optionally include with each Course the user's current and invited enrollments. If the user is enrolled as a student, and the account has permission to manage or view all grades, each enrollment will include a 'grades' key with 'current_score', 'final_score', 'current_grade' and 'final_grade' values. - \"locked\": Optionally include whether an enrollment is locked. - \"avatar_url\": Optionally include avatar_url. - \"bio\": Optionally include each user's bio. - \"test_student\": Optionally include the course's Test Student, if present. Default is to not include Test Student.
        :param str user_id: If included, the user will be queried and if the user is part of the users set, the page parameter will be modified so that the page containing user_id will be returned.
        :param list[str] enrollment_state: When set, only return users where the enrollment workflow state is of one of the given types. \"active\" and \"invited\" enrollments are returned by default.
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'search_term', 'enrollment_type', 'enrollment_role', 'enrollment_role_id', 'include', 'user_id', 'enrollment_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_in_course_search_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_users_in_course_search_users`")

        resource_path = '/v1/courses/{course_id}/search_users'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'enrollment_type' in params:
            query_params['enrollment_type'] = params['enrollment_type']
        if 'enrollment_role' in params:
            query_params['enrollment_role'] = params['enrollment_role']
        if 'enrollment_role_id' in params:
            query_params['enrollment_role_id'] = params['enrollment_role_id']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'enrollment_state' in params:
            query_params['enrollment_state'] = params['enrollment_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_users_in_course_users
    def list_users_in_course_users(self, course_id, **kwargs):
        """
        List users in course
        Returns the list of users in this course. And optionally the user's enrollments in the course.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_users_in_course_users_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str search_term: The partial name or full ID of the users to match and return in the results list.
        :param str enrollment_type: When set, only return users where the user is enrolled as this type. This argument is ignored if enrollment_role is given.
        :param str enrollment_role: Deprecated When set, only return users enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a base role type of 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param int enrollment_role_id: When set, only return courses where the user is enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a built_in role id with type 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param list[str] include: - \"email\": Optional user email. - \"enrollments\": Optionally include with each Course the user's current and invited enrollments. If the user is enrolled as a student, and the account has permission to manage or view all grades, each enrollment will include a 'grades' key with 'current_score', 'final_score', 'current_grade' and 'final_grade' values. - \"locked\": Optionally include whether an enrollment is locked. - \"avatar_url\": Optionally include avatar_url. - \"bio\": Optionally include each user's bio. - \"test_student\": Optionally include the course's Test Student, if present. Default is to not include Test Student.
        :param str user_id: If included, the user will be queried and if the user is part of the users set, the page parameter will be modified so that the page containing user_id will be returned.
        :param list[str] enrollment_state: When set, only return users where the enrollment workflow state is of one of the given types. \"active\" and \"invited\" enrollments are returned by default.
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'search_term', 'enrollment_type', 'enrollment_role', 'enrollment_role_id', 'include', 'user_id', 'enrollment_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_users_in_course_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_users_in_course_users`")

        resource_path = '/v1/courses/{course_id}/users'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'enrollment_type' in params:
            query_params['enrollment_type'] = params['enrollment_type']
        if 'enrollment_role' in params:
            query_params['enrollment_role'] = params['enrollment_role']
        if 'enrollment_role_id' in params:
            query_params['enrollment_role_id'] = params['enrollment_role_id']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'user_id' in params:
            query_params['user_id'] = params['user_id']
        if 'enrollment_state' in params:
            query_params['enrollment_state'] = params['enrollment_state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[User]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_your_courses
    def list_your_courses(self, **kwargs):
        """
        List your courses
        Returns the list of active courses for the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_your_courses_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str enrollment_type: When set, only return courses where the user is enrolled as this type. For example, set to \"teacher\" to return only courses where the user is enrolled as a Teacher. This argument is ignored if enrollment_role is given.
        :param str enrollment_role: Deprecated When set, only return courses where the user is enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a base role type of 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param int enrollment_role_id: When set, only return courses where the user is enrolled with the specified course-level role. This can be a role created with the {api:RoleOverridesController#add_role Add Role API} or a built_in role type of 'StudentEnrollment', 'TeacherEnrollment', 'TaEnrollment', 'ObserverEnrollment', or 'DesignerEnrollment'.
        :param list[str] include: - \"needs_grading_count\": Optional information to include with each Course. When needs_grading_count is given, and the current user has grading rights, the total number of submissions needing grading for all assignments is returned. - \"syllabus_body\": Optional information to include with each Course. When syllabus_body is given the user-generated html for the course syllabus is returned. - \"total_scores\": Optional information to include with each Course. When total_scores is given, any enrollments with type 'student' will also include the fields 'calculated_current_score', 'calculated_final_score', 'calculated_current_grade', and 'calculated_final_grade'. calculated_current_score is the student's score in the course, ignoring ungraded assignments. calculated_final_score is the student's score in the course including ungraded assignments with a score of 0. calculated_current_grade is the letter grade equivalent of calculated_current_score (if available). calculated_final_grade is the letter grade equivalent of calculated_final_score (if available). This argument is ignored if the course is configured to hide final grades. - \"term\": Optional information to include with each Course. When term is given, the information for the enrollment term for each course is returned. - \"course_progress\": Optional information to include with each Course. When course_progress is given, each course will include a 'course_progress' object with the fields: 'requirement_count', an integer specifying the total number of requirements in the course, 'requirement_completed_count', an integer specifying the total number of requirements in this course that have been completed, and 'next_requirement_url', a string url to the next requirement item, and 'completed_at', the date the course was completed (null if incomplete). 'next_requirement_url' will be null if all requirements have been completed or the current module does not require sequential progress. \"course_progress\" will return an error message if the course is not module based or the user is not enrolled as a student in the course. - \"sections\": Section enrollment information to include with each Course. Returns an array of hashes containing the section ID (id), section name (name), start and end dates (start_at, end_at), as well as the enrollment type (enrollment_role, e.g. 'StudentEnrollment'). - \"storage_quota_used_mb\": The amount of storage space used by the files in this course - \"total_students\": Optional information to include with each Course. Returns an integer for the total amount of active and invited students. - \"passback_status\": Include the grade passback_status
        :param list[str] state: If set, only return courses that are in the given state(s). By default, \"available\" is returned for students and observers, and anything except \"deleted\", for all other enrollment types
        :return: list[Course]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['enrollment_type', 'enrollment_role', 'enrollment_role_id', 'include', 'state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_your_courses" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v1/courses'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'enrollment_type' in params:
            query_params['enrollment_type'] = params['enrollment_type']
        if 'enrollment_role' in params:
            query_params['enrollment_role'] = params['enrollment_role']
        if 'enrollment_role_id' in params:
            query_params['enrollment_role_id'] = params['enrollment_role_id']
        if 'include' in params:
            query_params['include'] = params['include']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Course]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: preview_processed_html
    def preview_processed_html(self, course_id, **kwargs):
        """
        Preview processed html
        Preview html content processed for this course

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.preview_processed_html_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str html: The html content to process
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'html']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method preview_processed_html" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `preview_processed_html`")

        resource_path = '/v1/courses/{course_id}/preview_html'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'html' in params:
            form_params.append(('html', params['html']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: reset_course
    def reset_course(self, course_id, **kwargs):
        """
        Reset a course
        Deletes the current course, and creates a new equivalent course with no content, but all sections and users moved over.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.reset_course_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: Course
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `reset_course`")

        resource_path = '/v1/courses/{course_id}/reset_content'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Course',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_course
    def update_course(self, id, course_account_id, **kwargs):
        """
        Update a course
        Update an existing course.  Arguments are the same as Courses#create, with a few exceptions (enroll_me).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_course_with_http_info(id, course_account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID (required)
        :param int course_account_id: The unique ID of the account to create to course under. (required)
        :param str course_name: The name of the course. If omitted, the course will be named \"Unnamed Course.\"
        :param str course_course_code: The course code for the course.
        :param Object course_start_at: Course start date in ISO8601 format, e.g. 2011-01-01T01:00Z
        :param Object course_end_at: Course end date in ISO8601 format. e.g. 2011-01-01T01:00Z
        :param str course_license: The name of the licensing. Should be one of the following abbreviations (a descriptive name is included in parenthesis for reference): - 'private' (Private Copyrighted) - 'cc_by_nc_nd' (CC Attribution Non-Commercial No Derivatives) - 'cc_by_nc_sa' (CC Attribution Non-Commercial Share Alike) - 'cc_by_nc' (CC Attribution Non-Commercial) - 'cc_by_nd' (CC Attribution No Derivatives) - 'cc_by_sa' (CC Attribution Share Alike) - 'cc_by' (CC Attribution) - 'public_domain' (Public Domain).
        :param bool course_is_public: Set to true if course if public.
        :param bool course_public_syllabus: Set to true to make the course syllabus public.
        :param str course_public_description: A publicly visible description of the course.
        :param bool course_allow_student_wiki_edits: If true, students will be able to modify the course wiki.
        :param bool course_allow_wiki_comments: If true, course members will be able to comment on wiki pages.
        :param bool course_allow_student_forum_attachments: If true, students can attach files to forum posts.
        :param bool course_open_enrollment: Set to true if the course is open enrollment.
        :param bool course_self_enrollment: Set to true if the course is self enrollment.
        :param bool course_restrict_enrollments_to_course_dates: Set to true to restrict user enrollments to the start and end dates of the course.
        :param int course_term_id: The unique ID of the term to create to course in.
        :param str course_sis_course_id: The unique SIS identifier.
        :param str course_integration_id: The unique Integration identifier.
        :param bool course_hide_final_grades: If this option is set to true, the totals in student grades summary will be hidden.
        :param bool course_apply_assignment_group_weights: Set to true to weight final grade based on assignment groups percentages.
        :param bool offer: If this option is set to true, the course will be available to students immediately.
        :param str course_syllabus_body: The syllabus body for the course
        :param int course_grading_standard_id: The grading standard id to set for the course. If no value is provided for this argument the current grading_standard will be un-set from this course.
        :param str course_course_format: Optional. Specifies the format of the course. (Should be either 'on_campus' or 'online')
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'course_account_id', 'course_name', 'course_course_code', 'course_start_at', 'course_end_at', 'course_license', 'course_is_public', 'course_public_syllabus', 'course_public_description', 'course_allow_student_wiki_edits', 'course_allow_wiki_comments', 'course_allow_student_forum_attachments', 'course_open_enrollment', 'course_self_enrollment', 'course_restrict_enrollments_to_course_dates', 'course_term_id', 'course_sis_course_id', 'course_integration_id', 'course_hide_final_grades', 'course_apply_assignment_group_weights', 'offer', 'course_syllabus_body', 'course_grading_standard_id', 'course_course_format']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_course" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_course`")
        # verify the required parameter 'course_account_id' is set
        if ('course_account_id' not in params) or (params['course_account_id'] is None):
            raise ValueError("Missing the required parameter `course_account_id` when calling `update_course`")

        resource_path = '/v1/courses/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'course_account_id' in params:
            form_params.append(('course[account_id]', params['course_account_id']))
        if 'course_name' in params:
            form_params.append(('course[name]', params['course_name']))
        if 'course_course_code' in params:
            form_params.append(('course[course_code]', params['course_course_code']))
        if 'course_start_at' in params:
            form_params.append(('course[start_at]', params['course_start_at']))
        if 'course_end_at' in params:
            form_params.append(('course[end_at]', params['course_end_at']))
        if 'course_license' in params:
            form_params.append(('course[license]', params['course_license']))
        if 'course_is_public' in params:
            form_params.append(('course[is_public]', params['course_is_public']))
        if 'course_public_syllabus' in params:
            form_params.append(('course[public_syllabus]', params['course_public_syllabus']))
        if 'course_public_description' in params:
            form_params.append(('course[public_description]', params['course_public_description']))
        if 'course_allow_student_wiki_edits' in params:
            form_params.append(('course[allow_student_wiki_edits]', params['course_allow_student_wiki_edits']))
        if 'course_allow_wiki_comments' in params:
            form_params.append(('course[allow_wiki_comments]', params['course_allow_wiki_comments']))
        if 'course_allow_student_forum_attachments' in params:
            form_params.append(('course[allow_student_forum_attachments]', params['course_allow_student_forum_attachments']))
        if 'course_open_enrollment' in params:
            form_params.append(('course[open_enrollment]', params['course_open_enrollment']))
        if 'course_self_enrollment' in params:
            form_params.append(('course[self_enrollment]', params['course_self_enrollment']))
        if 'course_restrict_enrollments_to_course_dates' in params:
            form_params.append(('course[restrict_enrollments_to_course_dates]', params['course_restrict_enrollments_to_course_dates']))
        if 'course_term_id' in params:
            form_params.append(('course[term_id]', params['course_term_id']))
        if 'course_sis_course_id' in params:
            form_params.append(('course[sis_course_id]', params['course_sis_course_id']))
        if 'course_integration_id' in params:
            form_params.append(('course[integration_id]', params['course_integration_id']))
        if 'course_hide_final_grades' in params:
            form_params.append(('course[hide_final_grades]', params['course_hide_final_grades']))
        if 'course_apply_assignment_group_weights' in params:
            form_params.append(('course[apply_assignment_group_weights]', params['course_apply_assignment_group_weights']))
        if 'offer' in params:
            form_params.append(('offer', params['offer']))
        if 'course_syllabus_body' in params:
            form_params.append(('course[syllabus_body]', params['course_syllabus_body']))
        if 'course_grading_standard_id' in params:
            form_params.append(('course[grading_standard_id]', params['course_grading_standard_id']))
        if 'course_course_format' in params:
            form_params.append(('course[course_format]', params['course_course_format']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_course_settings
    def update_course_settings(self, course_id, **kwargs):
        """
        Update course settings
        Can update the following course settings:

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_course_settings_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param bool allow_student_discussion_topics: Let students create discussion topics
        :param bool allow_student_forum_attachments: Let students attach files to discussions
        :param bool allow_student_discussion_editing: Let students edit or delete their own discussion posts
        :param bool allow_student_organized_groups: Let students organize their own groups
        :param bool hide_final_grades: Hide totals in student grades summary
        :param bool hide_distribution_graphs: Hide grade distribution graphs from students
        :param bool lock_all_announcements: Disable comments on announcements
        :param bool restrict_student_past_view: Restrict students from viewing courses after end date
        :param bool restrict_student_future_view: Restrict students from viewing courses before start date
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'allow_student_discussion_topics', 'allow_student_forum_attachments', 'allow_student_discussion_editing', 'allow_student_organized_groups', 'hide_final_grades', 'hide_distribution_graphs', 'lock_all_announcements', 'restrict_student_past_view', 'restrict_student_future_view']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_course_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_course_settings`")

        resource_path = '/v1/courses/{course_id}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'allow_student_discussion_topics' in params:
            form_params.append(('allow_student_discussion_topics', params['allow_student_discussion_topics']))
        if 'allow_student_forum_attachments' in params:
            form_params.append(('allow_student_forum_attachments', params['allow_student_forum_attachments']))
        if 'allow_student_discussion_editing' in params:
            form_params.append(('allow_student_discussion_editing', params['allow_student_discussion_editing']))
        if 'allow_student_organized_groups' in params:
            form_params.append(('allow_student_organized_groups', params['allow_student_organized_groups']))
        if 'hide_final_grades' in params:
            form_params.append(('hide_final_grades', params['hide_final_grades']))
        if 'hide_distribution_graphs' in params:
            form_params.append(('hide_distribution_graphs', params['hide_distribution_graphs']))
        if 'lock_all_announcements' in params:
            form_params.append(('lock_all_announcements', params['lock_all_announcements']))
        if 'restrict_student_past_view' in params:
            form_params.append(('restrict_student_past_view', params['restrict_student_past_view']))
        if 'restrict_student_future_view' in params:
            form_params.append(('restrict_student_future_view', params['restrict_student_future_view']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_courses
    def update_courses(self, account_id, course_ids, event, **kwargs):
        """
        Update courses
        Update multiple courses in an account.  Operates asynchronously; use the {api:ProgressController#show progress endpoint} to query the status of an operation.  The action to take on each course.  Must be one of 'offer', 'conclude', 'delete', or 'undelete'.   * 'offer' makes a course visible to students. This action is also called \"publish\" on the web site.   * 'conclude' prevents future enrollments and makes a course read-only for all participants. The course still appears     in prior-enrollment lists.   * 'delete' completely removes the course from the web site (including course menus and prior-enrollment lists).     All enrollments are deleted. Course content may be physically deleted at a future date.   * 'undelete' attempts to recover a course that has been deleted. (Recovery is not guaranteed; please conclude     rather than delete a course if there is any possibility the course will be used again.) The recovered course     will be unpublished. Deleted enrollments will not be recovered.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_courses_with_http_info(account_id, course_ids, event, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param list[str] course_ids: List of ids of courses to update. At most 500 courses may be updated in one call. (required)
        :param str event: no description (required)
        :return: Progress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'course_ids', 'event']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_courses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_courses`")
        # verify the required parameter 'course_ids' is set
        if ('course_ids' not in params) or (params['course_ids'] is None):
            raise ValueError("Missing the required parameter `course_ids` when calling `update_courses`")
        # verify the required parameter 'event' is set
        if ('event' not in params) or (params['event'] is None):
            raise ValueError("Missing the required parameter `event` when calling `update_courses`")

        resource_path = '/v1/accounts/{account_id}/courses'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'course_ids' in params:
            form_params.append(('course_ids', params['course_ids']))
        if 'event' in params:
            form_params.append(('event', params['event']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Progress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: upload_file
    def upload_file(self, course_id, **kwargs):
        """
        Upload a file
        Upload a file to the course.  This API endpoint is the first step in uploading a file to a course. See the {file:file_uploads.html File Upload Documentation} for details on the file upload workflow.  Only those with the \"Manage Files\" permission on a course can upload files to the course. By default, this is Teachers, TAs and Designers.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.upload_file_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `upload_file`")

        resource_path = '/v1/courses/{course_id}/files'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
