# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class Conversation(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, subject=None, workflow_state=None, last_message=None, start_at=None, message_count=None, subscribed=None, private=None, starred=None, properties=None, audience=None, audience_contexts=None, avatar_url=None, participants=None, visible=None, context_name=None):
        """
        Conversation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'subject': 'str',
            'workflow_state': 'str',
            'last_message': 'str',
            'start_at': 'Datetime',
            'message_count': 'int',
            'subscribed': 'bool',
            'private': 'bool',
            'starred': 'bool',
            'properties': 'list[str]',
            'audience': 'list[int]',
            'audience_contexts': 'list[str]',
            'avatar_url': 'str',
            'participants': 'list[str]',
            'visible': 'bool',
            'context_name': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'subject': 'subject',
            'workflow_state': 'workflow_state',
            'last_message': 'last_message',
            'start_at': 'start_at',
            'message_count': 'message_count',
            'subscribed': 'subscribed',
            'private': 'private',
            'starred': 'starred',
            'properties': 'properties',
            'audience': 'audience',
            'audience_contexts': 'audience_contexts',
            'avatar_url': 'avatar_url',
            'participants': 'participants',
            'visible': 'visible',
            'context_name': 'context_name'
        }

        self._id = id
        self._subject = subject
        self._workflow_state = workflow_state
        self._last_message = last_message
        self._start_at = start_at
        self._message_count = message_count
        self._subscribed = subscribed
        self._private = private
        self._starred = starred
        self._properties = properties
        self._audience = audience
        self._audience_contexts = audience_contexts
        self._avatar_url = avatar_url
        self._participants = participants
        self._visible = visible
        self._context_name = context_name

    @property
    def id(self):
        """
        Gets the id of this Conversation.
        the unique identifier for the conversation.

        :return: The id of this Conversation.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Conversation.
        the unique identifier for the conversation.

        :param id: The id of this Conversation.
        :type: int
        """

        self._id = id

    @property
    def subject(self):
        """
        Gets the subject of this Conversation.
        the subject of the conversation.

        :return: The subject of this Conversation.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this Conversation.
        the subject of the conversation.

        :param subject: The subject of this Conversation.
        :type: str
        """

        self._subject = subject

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this Conversation.
        The current state of the conversation (read, unread or archived).

        :return: The workflow_state of this Conversation.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this Conversation.
        The current state of the conversation (read, unread or archived).

        :param workflow_state: The workflow_state of this Conversation.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def last_message(self):
        """
        Gets the last_message of this Conversation.
        A <=100 character preview from the most recent message.

        :return: The last_message of this Conversation.
        :rtype: str
        """
        return self._last_message

    @last_message.setter
    def last_message(self, last_message):
        """
        Sets the last_message of this Conversation.
        A <=100 character preview from the most recent message.

        :param last_message: The last_message of this Conversation.
        :type: str
        """

        self._last_message = last_message

    @property
    def start_at(self):
        """
        Gets the start_at of this Conversation.
        the date and time at which the last message was sent.

        :return: The start_at of this Conversation.
        :rtype: Datetime
        """
        return self._start_at

    @start_at.setter
    def start_at(self, start_at):
        """
        Sets the start_at of this Conversation.
        the date and time at which the last message was sent.

        :param start_at: The start_at of this Conversation.
        :type: Datetime
        """

        self._start_at = start_at

    @property
    def message_count(self):
        """
        Gets the message_count of this Conversation.
        the number of messages in the conversation.

        :return: The message_count of this Conversation.
        :rtype: int
        """
        return self._message_count

    @message_count.setter
    def message_count(self, message_count):
        """
        Sets the message_count of this Conversation.
        the number of messages in the conversation.

        :param message_count: The message_count of this Conversation.
        :type: int
        """

        self._message_count = message_count

    @property
    def subscribed(self):
        """
        Gets the subscribed of this Conversation.
        whether the current user is subscribed to the conversation.

        :return: The subscribed of this Conversation.
        :rtype: bool
        """
        return self._subscribed

    @subscribed.setter
    def subscribed(self, subscribed):
        """
        Sets the subscribed of this Conversation.
        whether the current user is subscribed to the conversation.

        :param subscribed: The subscribed of this Conversation.
        :type: bool
        """

        self._subscribed = subscribed

    @property
    def private(self):
        """
        Gets the private of this Conversation.
        whether the conversation is private.

        :return: The private of this Conversation.
        :rtype: bool
        """
        return self._private

    @private.setter
    def private(self, private):
        """
        Sets the private of this Conversation.
        whether the conversation is private.

        :param private: The private of this Conversation.
        :type: bool
        """

        self._private = private

    @property
    def starred(self):
        """
        Gets the starred of this Conversation.
        whether the conversation is starred.

        :return: The starred of this Conversation.
        :rtype: bool
        """
        return self._starred

    @starred.setter
    def starred(self, starred):
        """
        Sets the starred of this Conversation.
        whether the conversation is starred.

        :param starred: The starred of this Conversation.
        :type: bool
        """

        self._starred = starred

    @property
    def properties(self):
        """
        Gets the properties of this Conversation.
        Additional conversation flags (last_author, attachments, media_objects). Each listed property means the flag is set to true (i.e. the current user is the most recent author, there are attachments, or there are media objects)

        :return: The properties of this Conversation.
        :rtype: list[str]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this Conversation.
        Additional conversation flags (last_author, attachments, media_objects). Each listed property means the flag is set to true (i.e. the current user is the most recent author, there are attachments, or there are media objects)

        :param properties: The properties of this Conversation.
        :type: list[str]
        """

        self._properties = properties

    @property
    def audience(self):
        """
        Gets the audience of this Conversation.
        Array of user ids who are involved in the conversation, ordered by participation level, then alphabetical. Excludes current user, unless this is a monologue.

        :return: The audience of this Conversation.
        :rtype: list[int]
        """
        return self._audience

    @audience.setter
    def audience(self, audience):
        """
        Sets the audience of this Conversation.
        Array of user ids who are involved in the conversation, ordered by participation level, then alphabetical. Excludes current user, unless this is a monologue.

        :param audience: The audience of this Conversation.
        :type: list[int]
        """

        self._audience = audience

    @property
    def audience_contexts(self):
        """
        Gets the audience_contexts of this Conversation.
        Most relevant shared contexts (courses and groups) between current user and other participants. If there is only one participant, it will also include that user's enrollment(s)/ membership type(s) in each course/group.

        :return: The audience_contexts of this Conversation.
        :rtype: list[str]
        """
        return self._audience_contexts

    @audience_contexts.setter
    def audience_contexts(self, audience_contexts):
        """
        Sets the audience_contexts of this Conversation.
        Most relevant shared contexts (courses and groups) between current user and other participants. If there is only one participant, it will also include that user's enrollment(s)/ membership type(s) in each course/group.

        :param audience_contexts: The audience_contexts of this Conversation.
        :type: list[str]
        """

        self._audience_contexts = audience_contexts

    @property
    def avatar_url(self):
        """
        Gets the avatar_url of this Conversation.
        URL to appropriate icon for this conversation (custom, individual or group avatar, depending on audience).

        :return: The avatar_url of this Conversation.
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """
        Sets the avatar_url of this Conversation.
        URL to appropriate icon for this conversation (custom, individual or group avatar, depending on audience).

        :param avatar_url: The avatar_url of this Conversation.
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def participants(self):
        """
        Gets the participants of this Conversation.
        Array of users (id, name) participating in the conversation. Includes current user.

        :return: The participants of this Conversation.
        :rtype: list[str]
        """
        return self._participants

    @participants.setter
    def participants(self, participants):
        """
        Sets the participants of this Conversation.
        Array of users (id, name) participating in the conversation. Includes current user.

        :param participants: The participants of this Conversation.
        :type: list[str]
        """

        self._participants = participants

    @property
    def visible(self):
        """
        Gets the visible of this Conversation.
        indicates whether the conversation is visible under the current scope and filter. This attribute is always true in the index API response, and is primarily useful in create/update responses so that you can know if the record should be displayed in the UI. The default scope is assumed, unless a scope or filter is passed to the create/update API call.

        :return: The visible of this Conversation.
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this Conversation.
        indicates whether the conversation is visible under the current scope and filter. This attribute is always true in the index API response, and is primarily useful in create/update responses so that you can know if the record should be displayed in the UI. The default scope is assumed, unless a scope or filter is passed to the create/update API call.

        :param visible: The visible of this Conversation.
        :type: bool
        """

        self._visible = visible

    @property
    def context_name(self):
        """
        Gets the context_name of this Conversation.
        Name of the course or group in which the conversation is occurring.

        :return: The context_name of this Conversation.
        :rtype: str
        """
        return self._context_name

    @context_name.setter
    def context_name(self, context_name):
        """
        Sets the context_name of this Conversation.
        Name of the course or group in which the conversation is occurring.

        :param context_name: The context_name of this Conversation.
        :type: str
        """

        self._context_name = context_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
