# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class CommMessage(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, created_at=None, sent_at=None, workflow_state=None, _from=None, to=None, reply_to=None, subject=None, body=None, html_body=None):
        """
        CommMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'created_at': 'Datetime',
            'sent_at': 'Datetime',
            'workflow_state': 'str',
            '_from': 'str',
            'to': 'str',
            'reply_to': 'str',
            'subject': 'str',
            'body': 'str',
            'html_body': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'created_at': 'created_at',
            'sent_at': 'sent_at',
            'workflow_state': 'workflow_state',
            '_from': 'from',
            'to': 'to',
            'reply_to': 'reply_to',
            'subject': 'subject',
            'body': 'body',
            'html_body': 'html_body'
        }

        self._id = id
        self._created_at = created_at
        self._sent_at = sent_at
        self._workflow_state = workflow_state
        self.__from = _from
        self._to = to
        self._reply_to = reply_to
        self._subject = subject
        self._body = body
        self._html_body = html_body

    @property
    def id(self):
        """
        Gets the id of this CommMessage.
        The ID of the CommMessage.

        :return: The id of this CommMessage.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CommMessage.
        The ID of the CommMessage.

        :param id: The id of this CommMessage.
        :type: int
        """

        self._id = id

    @property
    def created_at(self):
        """
        Gets the created_at of this CommMessage.
        The date and time this message was created

        :return: The created_at of this CommMessage.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this CommMessage.
        The date and time this message was created

        :param created_at: The created_at of this CommMessage.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def sent_at(self):
        """
        Gets the sent_at of this CommMessage.
        The date and time this message was sent

        :return: The sent_at of this CommMessage.
        :rtype: Datetime
        """
        return self._sent_at

    @sent_at.setter
    def sent_at(self, sent_at):
        """
        Sets the sent_at of this CommMessage.
        The date and time this message was sent

        :param sent_at: The sent_at of this CommMessage.
        :type: Datetime
        """

        self._sent_at = sent_at

    @property
    def workflow_state(self):
        """
        Gets the workflow_state of this CommMessage.
        The workflow state of the message. One of 'created', 'staged', 'sending', 'sent', 'bounced', 'dashboard', 'cancelled', or 'closed'

        :return: The workflow_state of this CommMessage.
        :rtype: str
        """
        return self._workflow_state

    @workflow_state.setter
    def workflow_state(self, workflow_state):
        """
        Sets the workflow_state of this CommMessage.
        The workflow state of the message. One of 'created', 'staged', 'sending', 'sent', 'bounced', 'dashboard', 'cancelled', or 'closed'

        :param workflow_state: The workflow_state of this CommMessage.
        :type: str
        """

        self._workflow_state = workflow_state

    @property
    def _from(self):
        """
        Gets the _from of this CommMessage.
        The address that was put in the 'from' field of the message

        :return: The _from of this CommMessage.
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """
        Sets the _from of this CommMessage.
        The address that was put in the 'from' field of the message

        :param _from: The _from of this CommMessage.
        :type: str
        """

        self.__from = _from

    @property
    def to(self):
        """
        Gets the to of this CommMessage.
        The address the message was sent to:

        :return: The to of this CommMessage.
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """
        Sets the to of this CommMessage.
        The address the message was sent to:

        :param to: The to of this CommMessage.
        :type: str
        """

        self._to = to

    @property
    def reply_to(self):
        """
        Gets the reply_to of this CommMessage.
        The reply_to header of the message

        :return: The reply_to of this CommMessage.
        :rtype: str
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to):
        """
        Sets the reply_to of this CommMessage.
        The reply_to header of the message

        :param reply_to: The reply_to of this CommMessage.
        :type: str
        """

        self._reply_to = reply_to

    @property
    def subject(self):
        """
        Gets the subject of this CommMessage.
        The message subject

        :return: The subject of this CommMessage.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this CommMessage.
        The message subject

        :param subject: The subject of this CommMessage.
        :type: str
        """

        self._subject = subject

    @property
    def body(self):
        """
        Gets the body of this CommMessage.
        The plain text body of the message

        :return: The body of this CommMessage.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this CommMessage.
        The plain text body of the message

        :param body: The body of this CommMessage.
        :type: str
        """

        self._body = body

    @property
    def html_body(self):
        """
        Gets the html_body of this CommMessage.
        The HTML body of the message.

        :return: The html_body of this CommMessage.
        :rtype: str
        """
        return self._html_body

    @html_body.setter
    def html_body(self, html_body):
        """
        Sets the html_body of this CommMessage.
        The HTML body of the message.

        :param html_body: The html_body of this CommMessage.
        :type: str
        """

        self._html_body = html_body

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
