# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class AssignmentOverride(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, assignment_id=None, student_ids=None, group_id=None, course_section_id=None, title=None, due_at=None, all_day=None, all_day_date=None, unlock_at=None, lock_at=None):
        """
        AssignmentOverride - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'assignment_id': 'int',
            'student_ids': 'list[int]',
            'group_id': 'int',
            'course_section_id': 'int',
            'title': 'str',
            'due_at': 'Datetime',
            'all_day': 'int',
            'all_day_date': 'Datetime',
            'unlock_at': 'Datetime',
            'lock_at': 'Datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'assignment_id': 'assignment_id',
            'student_ids': 'student_ids',
            'group_id': 'group_id',
            'course_section_id': 'course_section_id',
            'title': 'title',
            'due_at': 'due_at',
            'all_day': 'all_day',
            'all_day_date': 'all_day_date',
            'unlock_at': 'unlock_at',
            'lock_at': 'lock_at'
        }

        self._id = id
        self._assignment_id = assignment_id
        self._student_ids = student_ids
        self._group_id = group_id
        self._course_section_id = course_section_id
        self._title = title
        self._due_at = due_at
        self._all_day = all_day
        self._all_day_date = all_day_date
        self._unlock_at = unlock_at
        self._lock_at = lock_at

    @property
    def id(self):
        """
        Gets the id of this AssignmentOverride.
        the ID of the assignment override

        :return: The id of this AssignmentOverride.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AssignmentOverride.
        the ID of the assignment override

        :param id: The id of this AssignmentOverride.
        :type: int
        """

        self._id = id

    @property
    def assignment_id(self):
        """
        Gets the assignment_id of this AssignmentOverride.
        the ID of the assignment the override applies to

        :return: The assignment_id of this AssignmentOverride.
        :rtype: int
        """
        return self._assignment_id

    @assignment_id.setter
    def assignment_id(self, assignment_id):
        """
        Sets the assignment_id of this AssignmentOverride.
        the ID of the assignment the override applies to

        :param assignment_id: The assignment_id of this AssignmentOverride.
        :type: int
        """

        self._assignment_id = assignment_id

    @property
    def student_ids(self):
        """
        Gets the student_ids of this AssignmentOverride.
        the IDs of the override's target students (present if the override targets an ad-hoc set of students)

        :return: The student_ids of this AssignmentOverride.
        :rtype: list[int]
        """
        return self._student_ids

    @student_ids.setter
    def student_ids(self, student_ids):
        """
        Sets the student_ids of this AssignmentOverride.
        the IDs of the override's target students (present if the override targets an ad-hoc set of students)

        :param student_ids: The student_ids of this AssignmentOverride.
        :type: list[int]
        """

        self._student_ids = student_ids

    @property
    def group_id(self):
        """
        Gets the group_id of this AssignmentOverride.
        the ID of the override's target group (present if the override targets a group and the assignment is a group assignment)

        :return: The group_id of this AssignmentOverride.
        :rtype: int
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this AssignmentOverride.
        the ID of the override's target group (present if the override targets a group and the assignment is a group assignment)

        :param group_id: The group_id of this AssignmentOverride.
        :type: int
        """

        self._group_id = group_id

    @property
    def course_section_id(self):
        """
        Gets the course_section_id of this AssignmentOverride.
        the ID of the overrides's target section (present if the override targets a section)

        :return: The course_section_id of this AssignmentOverride.
        :rtype: int
        """
        return self._course_section_id

    @course_section_id.setter
    def course_section_id(self, course_section_id):
        """
        Sets the course_section_id of this AssignmentOverride.
        the ID of the overrides's target section (present if the override targets a section)

        :param course_section_id: The course_section_id of this AssignmentOverride.
        :type: int
        """

        self._course_section_id = course_section_id

    @property
    def title(self):
        """
        Gets the title of this AssignmentOverride.
        the title of the override

        :return: The title of this AssignmentOverride.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this AssignmentOverride.
        the title of the override

        :param title: The title of this AssignmentOverride.
        :type: str
        """

        self._title = title

    @property
    def due_at(self):
        """
        Gets the due_at of this AssignmentOverride.
        the overridden due at (present if due_at is overridden)

        :return: The due_at of this AssignmentOverride.
        :rtype: Datetime
        """
        return self._due_at

    @due_at.setter
    def due_at(self, due_at):
        """
        Sets the due_at of this AssignmentOverride.
        the overridden due at (present if due_at is overridden)

        :param due_at: The due_at of this AssignmentOverride.
        :type: Datetime
        """

        self._due_at = due_at

    @property
    def all_day(self):
        """
        Gets the all_day of this AssignmentOverride.
        the overridden all day flag (present if due_at is overridden)

        :return: The all_day of this AssignmentOverride.
        :rtype: int
        """
        return self._all_day

    @all_day.setter
    def all_day(self, all_day):
        """
        Sets the all_day of this AssignmentOverride.
        the overridden all day flag (present if due_at is overridden)

        :param all_day: The all_day of this AssignmentOverride.
        :type: int
        """

        self._all_day = all_day

    @property
    def all_day_date(self):
        """
        Gets the all_day_date of this AssignmentOverride.
        the overridden all day date (present if due_at is overridden)

        :return: The all_day_date of this AssignmentOverride.
        :rtype: Datetime
        """
        return self._all_day_date

    @all_day_date.setter
    def all_day_date(self, all_day_date):
        """
        Sets the all_day_date of this AssignmentOverride.
        the overridden all day date (present if due_at is overridden)

        :param all_day_date: The all_day_date of this AssignmentOverride.
        :type: Datetime
        """

        self._all_day_date = all_day_date

    @property
    def unlock_at(self):
        """
        Gets the unlock_at of this AssignmentOverride.
        the overridden unlock at (present if unlock_at is overridden)

        :return: The unlock_at of this AssignmentOverride.
        :rtype: Datetime
        """
        return self._unlock_at

    @unlock_at.setter
    def unlock_at(self, unlock_at):
        """
        Sets the unlock_at of this AssignmentOverride.
        the overridden unlock at (present if unlock_at is overridden)

        :param unlock_at: The unlock_at of this AssignmentOverride.
        :type: Datetime
        """

        self._unlock_at = unlock_at

    @property
    def lock_at(self):
        """
        Gets the lock_at of this AssignmentOverride.
        the overridden lock at, if any (present if lock_at is overridden)

        :return: The lock_at of this AssignmentOverride.
        :rtype: Datetime
        """
        return self._lock_at

    @lock_at.setter
    def lock_at(self, lock_at):
        """
        Sets the lock_at of this AssignmentOverride.
        the overridden lock at, if any (present if lock_at is overridden)

        :param lock_at: The lock_at of this AssignmentOverride.
        :type: Datetime
        """

        self._lock_at = lock_at

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
