# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class AssignmentsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: create_assignment
    def create_assignment(self, course_id, assignment_name, **kwargs):
        """
        Create an assignment
        Create a new assignment for this course. The assignment is created in the active state.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_assignment_with_http_info(course_id, assignment_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_name: The assignment name. (required)
        :param int assignment_position: The position of this assignment in the group when displaying assignment lists.
        :param list[str] assignment_submission_types: List of supported submission types for the assignment. Unless the assignment is allowing online submissions, the array should only have one element. If not allowing online submissions, your options are: \"online_quiz\" \"none\" \"on_paper\" \"online_quiz\" \"discussion_topic\" \"external_tool\" If you are allowing online submissions, you can have one or many allowed submission types: \"online_upload\" \"online_text_entry\" \"online_url\" \"media_recording\" (Only valid when the Kaltura plugin is enabled)
        :param list[str] assignment_allowed_extensions: Allowed extensions if submission_types includes \"online_upload\" Example: allowed_extensions: [\"docx\",\"ppt\"]
        :param bool assignment_turnitin_enabled: Only applies when the Turnitin plugin is enabled for a course and the submission_types array includes \"online_upload\". Toggles Turnitin submissions for the assignment. Will be ignored if Turnitin is not available for the course.
        :param str assignment_turnitin_settings: Settings to send along to turnitin. See Assignment object definition for format.
        :param str assignment_integration_data: Data related to third party integrations, JSON string required.
        :param str assignment_integration_id: Unique ID from third party integrations
        :param bool assignment_peer_reviews: If submission_types does not include external_tool,discussion_topic, online_quiz, or on_paper, determines whether or not peer reviews will be turned on for the assignment.
        :param bool assignment_automatic_peer_reviews: Whether peer reviews will be assigned automatically by Canvas or if teachers must manually assign peer reviews. Does not apply if peer reviews are not enabled.
        :param bool assignment_notify_of_update: If true, Canvas will send a notification to students in the class notifying them that the content has changed.
        :param int assignment_group_category_id: If present, the assignment will become a group assignment assigned to the group.
        :param int assignment_grade_group_students_individually: If this is a group assignment, teachers have the options to grade students individually. If false, Canvas will apply the assignment's score to each member of the group. If true, the teacher can manually assign scores to each member of the group.
        :param Object assignment_external_tool_tag_attributes: no description
        :param Object assignment_points_possible: The maximum points possible on the assignment.
        :param str assignment_grading_type: The strategy used for grading the assignment. The assignment is ungraded if this field is omitted.
        :param Object assignment_due_at: The day/time the assignment is due. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param Object assignment_lock_at: The day/time the assignment is locked after. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param Object assignment_unlock_at: The day/time the assignment is unlocked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param str assignment_description: The assignment's description, supports HTML.
        :param int assignment_assignment_group_id: The assignment group id to put the assignment in. Defaults to the top assignment group in the course.
        :param bool assignment_muted: Whether this assignment is muted. A muted assignment does not send change notifications and hides grades from students. Defaults to false.
        :param list[Assignmentoverride] assignment_assignment_overrides: List of overrides for the assignment. NOTE: The assignment overrides feature is in beta.
        :param bool assignment_only_visible_to_overrides: Whether this assignment is only visible to overrides (Only useful if 'differentiated assignments' account setting is on)
        :param bool assignment_published: Whether this assignment is published. (Only useful if 'draft state' account setting is on) Unpublished assignments are not visible to students.
        :param int assignment_grading_standard_id: The grading standard id to set for the course. If no value is provided for this argument the current grading_standard will be un-set from this course. This will update the grading_type for the course to 'letter_grade' unless it is already 'gpa_scale'.
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_name', 'assignment_position', 'assignment_submission_types', 'assignment_allowed_extensions', 'assignment_turnitin_enabled', 'assignment_turnitin_settings', 'assignment_integration_data', 'assignment_integration_id', 'assignment_peer_reviews', 'assignment_automatic_peer_reviews', 'assignment_notify_of_update', 'assignment_group_category_id', 'assignment_grade_group_students_individually', 'assignment_external_tool_tag_attributes', 'assignment_points_possible', 'assignment_grading_type', 'assignment_due_at', 'assignment_lock_at', 'assignment_unlock_at', 'assignment_description', 'assignment_assignment_group_id', 'assignment_muted', 'assignment_assignment_overrides', 'assignment_only_visible_to_overrides', 'assignment_published', 'assignment_grading_standard_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_assignment`")
        # verify the required parameter 'assignment_name' is set
        if ('assignment_name' not in params) or (params['assignment_name'] is None):
            raise ValueError("Missing the required parameter `assignment_name` when calling `create_assignment`")

        resource_path = '/v1/courses/{course_id}/assignments'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'assignment_name' in params:
            form_params.append(('assignment[name]', params['assignment_name']))
        if 'assignment_position' in params:
            form_params.append(('assignment[position]', params['assignment_position']))
        if 'assignment_submission_types' in params:
            form_params.append(('assignment[submission_types]', params['assignment_submission_types']))
        if 'assignment_allowed_extensions' in params:
            form_params.append(('assignment[allowed_extensions]', params['assignment_allowed_extensions']))
        if 'assignment_turnitin_enabled' in params:
            form_params.append(('assignment[turnitin_enabled]', params['assignment_turnitin_enabled']))
        if 'assignment_turnitin_settings' in params:
            form_params.append(('assignment[turnitin_settings]', params['assignment_turnitin_settings']))
        if 'assignment_integration_data' in params:
            form_params.append(('assignment[integration_data]', params['assignment_integration_data']))
        if 'assignment_integration_id' in params:
            form_params.append(('assignment[integration_id]', params['assignment_integration_id']))
        if 'assignment_peer_reviews' in params:
            form_params.append(('assignment[peer_reviews]', params['assignment_peer_reviews']))
        if 'assignment_automatic_peer_reviews' in params:
            form_params.append(('assignment[automatic_peer_reviews]', params['assignment_automatic_peer_reviews']))
        if 'assignment_notify_of_update' in params:
            form_params.append(('assignment[notify_of_update]', params['assignment_notify_of_update']))
        if 'assignment_group_category_id' in params:
            form_params.append(('assignment[group_category_id]', params['assignment_group_category_id']))
        if 'assignment_grade_group_students_individually' in params:
            form_params.append(('assignment[grade_group_students_individually]', params['assignment_grade_group_students_individually']))
        if 'assignment_external_tool_tag_attributes' in params:
            form_params.append(('assignment[external_tool_tag_attributes]', params['assignment_external_tool_tag_attributes']))
        if 'assignment_points_possible' in params:
            form_params.append(('assignment[points_possible]', params['assignment_points_possible']))
        if 'assignment_grading_type' in params:
            form_params.append(('assignment[grading_type]', params['assignment_grading_type']))
        if 'assignment_due_at' in params:
            form_params.append(('assignment[due_at]', params['assignment_due_at']))
        if 'assignment_lock_at' in params:
            form_params.append(('assignment[lock_at]', params['assignment_lock_at']))
        if 'assignment_unlock_at' in params:
            form_params.append(('assignment[unlock_at]', params['assignment_unlock_at']))
        if 'assignment_description' in params:
            form_params.append(('assignment[description]', params['assignment_description']))
        if 'assignment_assignment_group_id' in params:
            form_params.append(('assignment[assignment_group_id]', params['assignment_assignment_group_id']))
        if 'assignment_muted' in params:
            form_params.append(('assignment[muted]', params['assignment_muted']))
        if 'assignment_assignment_overrides' in params:
            form_params.append(('assignment[assignment_overrides]', params['assignment_assignment_overrides']))
        if 'assignment_only_visible_to_overrides' in params:
            form_params.append(('assignment[only_visible_to_overrides]', params['assignment_only_visible_to_overrides']))
        if 'assignment_published' in params:
            form_params.append(('assignment[published]', params['assignment_published']))
        if 'assignment_grading_standard_id' in params:
            form_params.append(('assignment[grading_standard_id]', params['assignment_grading_standard_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_assignment_override
    def create_assignment_override(self, course_id, assignment_id, **kwargs):
        """
        Create an assignment override
        One of student_ids, group_id, or course_section_id must be present. At most one should be present; if multiple are present only the most specific (student_ids first, then group_id, then course_section_id) is used and any others are ignored.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_assignment_override_with_http_info(course_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param list[int] assignment_override_student_ids: The IDs of the override's target students. If present, the IDs must each identify a user with an active student enrollment in the course that is not already targetted by a different adhoc override.
        :param str assignment_override_title: The title of the adhoc assignment override. Required if student_ids is present, ignored otherwise (the title is set to the name of the targetted group or section instead).
        :param int assignment_override_group_id: The ID of the override's target group. If present, the following conditions must be met for the override to be successful: 1. the assignment MUST be a group assignment (a group_category_id is assigned to it) 2. the ID must identify an active group in the group set the assignment is in 3. the ID must not be targetted by a different override See {Appendix: Group assignments} for more info.
        :param int assignment_override_course_section_id: The ID of the override's target section. If present, must identify an active section of the assignment's course not already targetted by a different override.
        :param Object assignment_override_due_at: The day/time the overridden assignment is due. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect due date. May be present but null to indicate the override removes any previous due date.
        :param Object assignment_override_unlock_at: The day/time the overridden assignment becomes unlocked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect the unlock date. May be present but null to indicate the override removes any previous unlock date.
        :param Object assignment_override_lock_at: The day/time the overridden assignment becomes locked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect the lock date. May be present but null to indicate the override removes any previous lock date.
        :return: AssignmentOverride
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'assignment_override_student_ids', 'assignment_override_title', 'assignment_override_group_id', 'assignment_override_course_section_id', 'assignment_override_due_at', 'assignment_override_unlock_at', 'assignment_override_lock_at']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_assignment_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `create_assignment_override`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `create_assignment_override`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/overrides'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'assignment_override_student_ids' in params:
            form_params.append(('assignment_override[student_ids]', params['assignment_override_student_ids']))
        if 'assignment_override_title' in params:
            form_params.append(('assignment_override[title]', params['assignment_override_title']))
        if 'assignment_override_group_id' in params:
            form_params.append(('assignment_override[group_id]', params['assignment_override_group_id']))
        if 'assignment_override_course_section_id' in params:
            form_params.append(('assignment_override[course_section_id]', params['assignment_override_course_section_id']))
        if 'assignment_override_due_at' in params:
            form_params.append(('assignment_override[due_at]', params['assignment_override_due_at']))
        if 'assignment_override_unlock_at' in params:
            form_params.append(('assignment_override[unlock_at]', params['assignment_override_unlock_at']))
        if 'assignment_override_lock_at' in params:
            form_params.append(('assignment_override[lock_at]', params['assignment_override_lock_at']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignmentOverride',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_assignment
    def delete_assignment(self, course_id, id, **kwargs):
        """
        Delete an assignment
        Delete the given assignment.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assignment_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_assignment`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_assignment`")

        resource_path = '/v1/courses/{course_id}/assignments/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: delete_assignment_override
    def delete_assignment_override(self, course_id, assignment_id, id, **kwargs):
        """
        Delete an assignment override
        Deletes an override and returns its former details.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assignment_override_with_http_info(course_id, assignment_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str id: ID (required)
        :return: AssignmentOverride
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assignment_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `delete_assignment_override`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `delete_assignment_override`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_assignment_override`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/overrides/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignmentOverride',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: edit_assignment
    def edit_assignment(self, course_id, id, **kwargs):
        """
        Edit an assignment
        Modify an existing assignment.  If the assignment [assignment_overrides] key is absent, any existing overrides are kept as is. If the assignment [assignment_overrides] key is present, existing overrides are updated or deleted (and new ones created, as necessary) to match the provided list.  NOTE: The assignment overrides feature is in beta.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.edit_assignment_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param str assignment_name: The assignment name.
        :param int assignment_position: The position of this assignment in the group when displaying assignment lists.
        :param list[str] assignment_submission_types: List of supported submission types for the assignment. Unless the assignment is allowing online submissions, the array should only have one element. If not allowing online submissions, your options are: \"online_quiz\" \"none\" \"on_paper\" \"online_quiz\" \"discussion_topic\" \"external_tool\" If you are allowing online submissions, you can have one or many allowed submission types: \"online_upload\" \"online_text_entry\" \"online_url\" \"media_recording\" (Only valid when the Kaltura plugin is enabled)
        :param list[str] assignment_allowed_extensions: Allowed extensions if submission_types includes \"online_upload\" Example: allowed_extensions: [\"docx\",\"ppt\"]
        :param bool assignment_turnitin_enabled: Only applies when the Turnitin plugin is enabled for a course and the submission_types array includes \"online_upload\". Toggles Turnitin submissions for the assignment. Will be ignored if Turnitin is not available for the course.
        :param str assignment_turnitin_settings: Settings to send along to turnitin. See Assignment object definition for format.
        :param str assignment_integration_data: Data related to third party integrations, JSON string required.
        :param str assignment_integration_id: Unique ID from third party integrations
        :param bool assignment_peer_reviews: If submission_types does not include external_tool,discussion_topic, online_quiz, or on_paper, determines whether or not peer reviews will be turned on for the assignment.
        :param bool assignment_automatic_peer_reviews: Whether peer reviews will be assigned automatically by Canvas or if teachers must manually assign peer reviews. Does not apply if peer reviews are not enabled.
        :param bool assignment_notify_of_update: If true, Canvas will send a notification to students in the class notifying them that the content has changed.
        :param int assignment_group_category_id: If present, the assignment will become a group assignment assigned to the group.
        :param int assignment_grade_group_students_individually: If this is a group assignment, teachers have the options to grade students individually. If false, Canvas will apply the assignment's score to each member of the group. If true, the teacher can manually assign scores to each member of the group.
        :param Object assignment_external_tool_tag_attributes: no description
        :param Object assignment_points_possible: The maximum points possible on the assignment.
        :param str assignment_grading_type: The strategy used for grading the assignment. The assignment is ungraded if this field is omitted.
        :param Object assignment_due_at: The day/time the assignment is due. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param Object assignment_lock_at: The day/time the assignment is locked after. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param Object assignment_unlock_at: The day/time the assignment is unlocked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z.
        :param str assignment_description: The assignment's description, supports HTML.
        :param int assignment_assignment_group_id: The assignment group id to put the assignment in. Defaults to the top assignment group in the course.
        :param bool assignment_muted: Whether this assignment is muted. A muted assignment does not send change notifications and hides grades from students. Defaults to false.
        :param list[Assignmentoverride] assignment_assignment_overrides: List of overrides for the assignment. NOTE: The assignment overrides feature is in beta.
        :param bool assignment_only_visible_to_overrides: Whether this assignment is only visible to overrides (Only useful if 'differentiated assignments' account setting is on)
        :param bool assignment_published: Whether this assignment is published. (Only useful if 'draft state' account setting is on) Unpublished assignments are not visible to students.
        :param int assignment_grading_standard_id: The grading standard id to set for the course. If no value is provided for this argument the current grading_standard will be un-set from this course. This will update the grading_type for the course to 'letter_grade' unless it is already 'gpa_scale'.
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'assignment_name', 'assignment_position', 'assignment_submission_types', 'assignment_allowed_extensions', 'assignment_turnitin_enabled', 'assignment_turnitin_settings', 'assignment_integration_data', 'assignment_integration_id', 'assignment_peer_reviews', 'assignment_automatic_peer_reviews', 'assignment_notify_of_update', 'assignment_group_category_id', 'assignment_grade_group_students_individually', 'assignment_external_tool_tag_attributes', 'assignment_points_possible', 'assignment_grading_type', 'assignment_due_at', 'assignment_lock_at', 'assignment_unlock_at', 'assignment_description', 'assignment_assignment_group_id', 'assignment_muted', 'assignment_assignment_overrides', 'assignment_only_visible_to_overrides', 'assignment_published', 'assignment_grading_standard_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `edit_assignment`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `edit_assignment`")

        resource_path = '/v1/courses/{course_id}/assignments/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'assignment_name' in params:
            form_params.append(('assignment[name]', params['assignment_name']))
        if 'assignment_position' in params:
            form_params.append(('assignment[position]', params['assignment_position']))
        if 'assignment_submission_types' in params:
            form_params.append(('assignment[submission_types]', params['assignment_submission_types']))
        if 'assignment_allowed_extensions' in params:
            form_params.append(('assignment[allowed_extensions]', params['assignment_allowed_extensions']))
        if 'assignment_turnitin_enabled' in params:
            form_params.append(('assignment[turnitin_enabled]', params['assignment_turnitin_enabled']))
        if 'assignment_turnitin_settings' in params:
            form_params.append(('assignment[turnitin_settings]', params['assignment_turnitin_settings']))
        if 'assignment_integration_data' in params:
            form_params.append(('assignment[integration_data]', params['assignment_integration_data']))
        if 'assignment_integration_id' in params:
            form_params.append(('assignment[integration_id]', params['assignment_integration_id']))
        if 'assignment_peer_reviews' in params:
            form_params.append(('assignment[peer_reviews]', params['assignment_peer_reviews']))
        if 'assignment_automatic_peer_reviews' in params:
            form_params.append(('assignment[automatic_peer_reviews]', params['assignment_automatic_peer_reviews']))
        if 'assignment_notify_of_update' in params:
            form_params.append(('assignment[notify_of_update]', params['assignment_notify_of_update']))
        if 'assignment_group_category_id' in params:
            form_params.append(('assignment[group_category_id]', params['assignment_group_category_id']))
        if 'assignment_grade_group_students_individually' in params:
            form_params.append(('assignment[grade_group_students_individually]', params['assignment_grade_group_students_individually']))
        if 'assignment_external_tool_tag_attributes' in params:
            form_params.append(('assignment[external_tool_tag_attributes]', params['assignment_external_tool_tag_attributes']))
        if 'assignment_points_possible' in params:
            form_params.append(('assignment[points_possible]', params['assignment_points_possible']))
        if 'assignment_grading_type' in params:
            form_params.append(('assignment[grading_type]', params['assignment_grading_type']))
        if 'assignment_due_at' in params:
            form_params.append(('assignment[due_at]', params['assignment_due_at']))
        if 'assignment_lock_at' in params:
            form_params.append(('assignment[lock_at]', params['assignment_lock_at']))
        if 'assignment_unlock_at' in params:
            form_params.append(('assignment[unlock_at]', params['assignment_unlock_at']))
        if 'assignment_description' in params:
            form_params.append(('assignment[description]', params['assignment_description']))
        if 'assignment_assignment_group_id' in params:
            form_params.append(('assignment[assignment_group_id]', params['assignment_assignment_group_id']))
        if 'assignment_muted' in params:
            form_params.append(('assignment[muted]', params['assignment_muted']))
        if 'assignment_assignment_overrides' in params:
            form_params.append(('assignment[assignment_overrides]', params['assignment_assignment_overrides']))
        if 'assignment_only_visible_to_overrides' in params:
            form_params.append(('assignment[only_visible_to_overrides]', params['assignment_only_visible_to_overrides']))
        if 'assignment_published' in params:
            form_params.append(('assignment[published]', params['assignment_published']))
        if 'assignment_grading_standard_id' in params:
            form_params.append(('assignment[grading_standard_id]', params['assignment_grading_standard_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_assignment
    def get_single_assignment(self, course_id, id, **kwargs):
        """
        Get a single assignment
        Returns the assignment with the given id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_assignment_with_http_info(course_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str id: ID (required)
        :param list[str] include: Associations to include with the assignment. The \"assignment_visibility\" option requires that the Differentiated Assignments course feature be turned on.
        :param bool override_assignment_dates: Apply assignment overrides to the assignment, defaults to true.
        :param bool needs_grading_count_by_section: Split up \"needs_grading_count\" by sections into the \"needs_grading_count_by_section\" key, defaults to false
        :param bool all_dates: All dates associated with the assignment, if applicable
        :return: Assignment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'id', 'include', 'override_assignment_dates', 'needs_grading_count_by_section', 'all_dates']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_assignment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_assignment`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_assignment`")

        resource_path = '/v1/courses/{course_id}/assignments/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'override_assignment_dates' in params:
            query_params['override_assignment_dates'] = params['override_assignment_dates']
        if 'needs_grading_count_by_section' in params:
            query_params['needs_grading_count_by_section'] = params['needs_grading_count_by_section']
        if 'all_dates' in params:
            query_params['all_dates'] = params['all_dates']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assignment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: get_single_assignment_override
    def get_single_assignment_override(self, course_id, assignment_id, id, **kwargs):
        """
        Get a single assignment override
        Returns details of the the override with the given id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_single_assignment_override_with_http_info(course_id, assignment_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str id: ID (required)
        :return: AssignmentOverride
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_single_assignment_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `get_single_assignment_override`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `get_single_assignment_override`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_single_assignment_override`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/overrides/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignmentOverride',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_assignment_overrides
    def list_assignment_overrides(self, course_id, assignment_id, **kwargs):
        """
        List assignment overrides
        Returns the list of overrides for this assignment that target sections/groups/students visible to the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignment_overrides_with_http_info(course_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :return: list[AssignmentOverride]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignment_overrides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_assignment_overrides`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `list_assignment_overrides`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/overrides'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[AssignmentOverride]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: list_assignments
    def list_assignments(self, course_id, **kwargs):
        """
        List assignments
        Returns the list of assignments for the current context.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_assignments_with_http_info(course_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param list[str] include: Associations to include with the assignment. The \"assignment_visibility\" option requires that the Differentiated Assignments course feature be turned on.
        :param str search_term: The partial title of the assignments to match and return.
        :param bool override_assignment_dates: Apply assignment overrides for each assignment, defaults to true.
        :param bool needs_grading_count_by_section: Split up \"needs_grading_count\" by sections into the \"needs_grading_count_by_section\" key, defaults to false
        :param str bucket: If included, only return certain assignments depending on due date and submission status. Valid buckets are \"past\", \"overdue\", \"undated\", \"ungraded\", \"upcoming\", and \"future\".
        :return: list[Assignment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'include', 'search_term', 'override_assignment_dates', 'needs_grading_count_by_section', 'bucket']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assignments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `list_assignments`")

        resource_path = '/v1/courses/{course_id}/assignments'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']

        query_params = {}
        if 'include' in params:
            query_params['include'] = params['include']
        if 'search_term' in params:
            query_params['search_term'] = params['search_term']
        if 'override_assignment_dates' in params:
            query_params['override_assignment_dates'] = params['override_assignment_dates']
        if 'needs_grading_count_by_section' in params:
            query_params['needs_grading_count_by_section'] = params['needs_grading_count_by_section']
        if 'bucket' in params:
            query_params['bucket'] = params['bucket']
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Assignment]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: redirect_to_assignment_override_for_group
    def redirect_to_assignment_override_for_group(self, group_id, assignment_id, **kwargs):
        """
        Redirect to the assignment override for a group
        Responds with a redirect to the override for the given group, if any (404 otherwise).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.redirect_to_assignment_override_for_group_with_http_info(group_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: ID (required)
        :param str assignment_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'assignment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirect_to_assignment_override_for_group" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `redirect_to_assignment_override_for_group`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `redirect_to_assignment_override_for_group`")

        resource_path = '/v1/groups/{group_id}/assignments/{assignment_id}/override'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['group_id'] = params['group_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: redirect_to_assignment_override_for_section
    def redirect_to_assignment_override_for_section(self, course_section_id, assignment_id, **kwargs):
        """
        Redirect to the assignment override for a section
        Responds with a redirect to the override for the given section, if any (404 otherwise).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.redirect_to_assignment_override_for_section_with_http_info(course_section_id, assignment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_section_id: ID (required)
        :param str assignment_id: ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_section_id', 'assignment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirect_to_assignment_override_for_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_section_id' is set
        if ('course_section_id' not in params) or (params['course_section_id'] is None):
            raise ValueError("Missing the required parameter `course_section_id` when calling `redirect_to_assignment_override_for_section`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `redirect_to_assignment_override_for_section`")

        resource_path = '/v1/sections/{course_section_id}/assignments/{assignment_id}/override'.replace('{format}', 'json')
        path_params = {}
        if 'course_section_id' in params:
            path_params['course_section_id'] = params['course_section_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: update_assignment_override
    def update_assignment_override(self, course_id, assignment_id, id, **kwargs):
        """
        Update an assignment override
        All current overridden values must be supplied if they are to be retained; e.g. if due_at was overridden, but this PUT omits a value for due_at, due_at will no longer be overridden. If the override is adhoc and student_ids is not supplied, the target override set is unchanged. Target override sets cannot be changed for group or section overrides.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_assignment_override_with_http_info(course_id, assignment_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str course_id: ID (required)
        :param str assignment_id: ID (required)
        :param str id: ID (required)
        :param list[int] assignment_override_student_ids: The IDs of the override's target students. If present, the IDs must each identify a user with an active student enrollment in the course that is not already targetted by a different adhoc override. Ignored unless the override being updated is adhoc.
        :param str assignment_override_title: The title of an adhoc assignment override. Ignored unless the override being updated is adhoc.
        :param Object assignment_override_due_at: The day/time the overridden assignment is due. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect due date. May be present but null to indicate the override removes any previous due date.
        :param Object assignment_override_unlock_at: The day/time the overridden assignment becomes unlocked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect the unlock date. May be present but null to indicate the override removes any previous unlock date.
        :param Object assignment_override_lock_at: The day/time the overridden assignment becomes locked. Accepts times in ISO 8601 format, e.g. 2014-10-21T18:48:00Z. If absent, this override will not affect the lock date. May be present but null to indicate the override removes any previous lock date.
        :return: AssignmentOverride
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['course_id', 'assignment_id', 'id', 'assignment_override_student_ids', 'assignment_override_title', 'assignment_override_due_at', 'assignment_override_unlock_at', 'assignment_override_lock_at']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_assignment_override" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'course_id' is set
        if ('course_id' not in params) or (params['course_id'] is None):
            raise ValueError("Missing the required parameter `course_id` when calling `update_assignment_override`")
        # verify the required parameter 'assignment_id' is set
        if ('assignment_id' not in params) or (params['assignment_id'] is None):
            raise ValueError("Missing the required parameter `assignment_id` when calling `update_assignment_override`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_assignment_override`")

        resource_path = '/v1/courses/{course_id}/assignments/{assignment_id}/overrides/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'course_id' in params:
            path_params['course_id'] = params['course_id']
        if 'assignment_id' in params:
            path_params['assignment_id'] = params['assignment_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'assignment_override_student_ids' in params:
            form_params.append(('assignment_override[student_ids]', params['assignment_override_student_ids']))
        if 'assignment_override_title' in params:
            form_params.append(('assignment_override[title]', params['assignment_override_title']))
        if 'assignment_override_due_at' in params:
            form_params.append(('assignment_override[due_at]', params['assignment_override_due_at']))
        if 'assignment_override_unlock_at' in params:
            form_params.append(('assignment_override[unlock_at]', params['assignment_override_unlock_at']))
        if 'assignment_override_lock_at' in params:
            form_params.append(('assignment_override[lock_at]', params['assignment_override_lock_at']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssignmentOverride',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
