# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class AssignmentGroup(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, name=None, position=None, group_weight=None, assignments=None, rules=None):
        """
        AssignmentGroup - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'position': 'int',
            'group_weight': 'int',
            'assignments': 'list[int]',
            'rules': 'GradingRules'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'position': 'position',
            'group_weight': 'group_weight',
            'assignments': 'assignments',
            'rules': 'rules'
        }

        self._id = id
        self._name = name
        self._position = position
        self._group_weight = group_weight
        self._assignments = assignments
        self._rules = rules

    @property
    def id(self):
        """
        Gets the id of this AssignmentGroup.
        the id of the Assignment Group

        :return: The id of this AssignmentGroup.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AssignmentGroup.
        the id of the Assignment Group

        :param id: The id of this AssignmentGroup.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this AssignmentGroup.
        the name of the Assignment Group

        :return: The name of this AssignmentGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AssignmentGroup.
        the name of the Assignment Group

        :param name: The name of this AssignmentGroup.
        :type: str
        """

        self._name = name

    @property
    def position(self):
        """
        Gets the position of this AssignmentGroup.
        the position of the Assignment Group

        :return: The position of this AssignmentGroup.
        :rtype: int
        """
        return self._position

    @position.setter
    def position(self, position):
        """
        Sets the position of this AssignmentGroup.
        the position of the Assignment Group

        :param position: The position of this AssignmentGroup.
        :type: int
        """

        self._position = position

    @property
    def group_weight(self):
        """
        Gets the group_weight of this AssignmentGroup.
        the weight of the Assignment Group

        :return: The group_weight of this AssignmentGroup.
        :rtype: int
        """
        return self._group_weight

    @group_weight.setter
    def group_weight(self, group_weight):
        """
        Sets the group_weight of this AssignmentGroup.
        the weight of the Assignment Group

        :param group_weight: The group_weight of this AssignmentGroup.
        :type: int
        """

        self._group_weight = group_weight

    @property
    def assignments(self):
        """
        Gets the assignments of this AssignmentGroup.
        the assignments in this Assignment Group (see the Assignment API for a detailed list of fields)

        :return: The assignments of this AssignmentGroup.
        :rtype: list[int]
        """
        return self._assignments

    @assignments.setter
    def assignments(self, assignments):
        """
        Sets the assignments of this AssignmentGroup.
        the assignments in this Assignment Group (see the Assignment API for a detailed list of fields)

        :param assignments: The assignments of this AssignmentGroup.
        :type: list[int]
        """

        self._assignments = assignments

    @property
    def rules(self):
        """
        Gets the rules of this AssignmentGroup.
        the grading rules that this Assignment Group has

        :return: The rules of this AssignmentGroup.
        :rtype: GradingRules
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """
        Sets the rules of this AssignmentGroup.
        the grading rules that this Assignment Group has

        :param rules: The rules of this AssignmentGroup.
        :type: GradingRules
        """

        self._rules = rules

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
