# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from ...base_model import BaseModel
from pprint import pformat
from six import iteritems
import re


class ExternalFeed(BaseModel):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, id=None, display_name=None, url=None, header_match=None, created_at=None, verbosity=None):
        """
        ExternalFeed - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'display_name': 'str',
            'url': 'str',
            'header_match': 'str',
            'created_at': 'Datetime',
            'verbosity': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'display_name',
            'url': 'url',
            'header_match': 'header_match',
            'created_at': 'created_at',
            'verbosity': 'verbosity'
        }

        self._id = id
        self._display_name = display_name
        self._url = url
        self._header_match = header_match
        self._created_at = created_at
        self._verbosity = verbosity

    @property
    def id(self):
        """
        Gets the id of this ExternalFeed.
        The ID of the feed

        :return: The id of this ExternalFeed.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ExternalFeed.
        The ID of the feed

        :param id: The id of this ExternalFeed.
        :type: int
        """

        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ExternalFeed.
        The title of the feed, pulled from the feed itself. If the feed hasn't yet been pulled, a temporary name will be synthesized based on the URL

        :return: The display_name of this ExternalFeed.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ExternalFeed.
        The title of the feed, pulled from the feed itself. If the feed hasn't yet been pulled, a temporary name will be synthesized based on the URL

        :param display_name: The display_name of this ExternalFeed.
        :type: str
        """

        self._display_name = display_name

    @property
    def url(self):
        """
        Gets the url of this ExternalFeed.
        The HTTP/HTTPS URL to the feed

        :return: The url of this ExternalFeed.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ExternalFeed.
        The HTTP/HTTPS URL to the feed

        :param url: The url of this ExternalFeed.
        :type: str
        """

        self._url = url

    @property
    def header_match(self):
        """
        Gets the header_match of this ExternalFeed.
        If not null, only feed entries whose title contains this string will trigger new posts in Canvas

        :return: The header_match of this ExternalFeed.
        :rtype: str
        """
        return self._header_match

    @header_match.setter
    def header_match(self, header_match):
        """
        Sets the header_match of this ExternalFeed.
        If not null, only feed entries whose title contains this string will trigger new posts in Canvas

        :param header_match: The header_match of this ExternalFeed.
        :type: str
        """

        self._header_match = header_match

    @property
    def created_at(self):
        """
        Gets the created_at of this ExternalFeed.
        When this external feed was added to Canvas

        :return: The created_at of this ExternalFeed.
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this ExternalFeed.
        When this external feed was added to Canvas

        :param created_at: The created_at of this ExternalFeed.
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def verbosity(self):
        """
        Gets the verbosity of this ExternalFeed.
        The verbosity setting determines how much of the feed's content is imported into Canvas as part of the posting. 'link_only' means that only the title and a link to the item. 'truncate' means that a summary of the first portion of the item body will be used. 'full' means that the full item body will be used.

        :return: The verbosity of this ExternalFeed.
        :rtype: str
        """
        return self._verbosity

    @verbosity.setter
    def verbosity(self, verbosity):
        """
        Sets the verbosity of this ExternalFeed.
        The verbosity setting determines how much of the feed's content is imported into Canvas as part of the posting. 'link_only' means that only the title and a link to the item. 'truncate' means that a summary of the first portion of the item body will be used. 'full' means that the full item body will be used.

        :param verbosity: The verbosity of this ExternalFeed.
        :type: str
        """

        self._verbosity = verbosity

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
