# coding: utf-8

"""


    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ...base_api import BaseApi
from ...configuration import Configuration
from ..api_client import ApiClient


class AccountnotificationsApi(BaseApi):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    # OPERATIONID: close_notification_for_user
    def close_notification_for_user(self, account_id, user_id, id, **kwargs):
        """
        Close notification for user
        If the user no long wants to see this notification it can be excused with this call

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.close_notification_for_user_with_http_info(account_id, user_id, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str user_id: ID (required)
        :param str id: ID (required)
        :return: AccountNotification
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'user_id', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method close_notification_for_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `close_notification_for_user`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `close_notification_for_user`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `close_notification_for_user`")

        resource_path = '/v1/accounts/{account_id}/users/{user_id}/account_notifications/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AccountNotification',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: create_global_notification
    def create_global_notification(self, account_id, account_notification_subject, account_notification_message, account_notification_start_at, account_notification_end_at, **kwargs):
        """
        Create a global notification
        Create and return a new global notification for an account.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_global_notification_with_http_info(account_id, account_notification_subject, account_notification_message, account_notification_start_at, account_notification_end_at, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str account_notification_subject: The subject of the notification. (required)
        :param str account_notification_message: The message body of the notification. (required)
        :param Object account_notification_start_at: The start date and time of the notification in ISO8601 format. e.g. 2014-01-01T01:00Z (required)
        :param Object account_notification_end_at: The end date and time of the notification in ISO8601 format. e.g. 2014-01-01T01:00Z (required)
        :param str account_notification_icon: The icon to display with the notification. Note: Defaults to warning.
        :param list[str] account_notification_roles: The role(s) to send global notification to. Note: ommitting this field will send to everyone Example: account_notification_roles: [\"StudentEnrollment\", \"TeacherEnrollment\"]
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'account_notification_subject', 'account_notification_message', 'account_notification_start_at', 'account_notification_end_at', 'account_notification_icon', 'account_notification_roles']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_global_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_global_notification`")
        # verify the required parameter 'account_notification_subject' is set
        if ('account_notification_subject' not in params) or (params['account_notification_subject'] is None):
            raise ValueError("Missing the required parameter `account_notification_subject` when calling `create_global_notification`")
        # verify the required parameter 'account_notification_message' is set
        if ('account_notification_message' not in params) or (params['account_notification_message'] is None):
            raise ValueError("Missing the required parameter `account_notification_message` when calling `create_global_notification`")
        # verify the required parameter 'account_notification_start_at' is set
        if ('account_notification_start_at' not in params) or (params['account_notification_start_at'] is None):
            raise ValueError("Missing the required parameter `account_notification_start_at` when calling `create_global_notification`")
        # verify the required parameter 'account_notification_end_at' is set
        if ('account_notification_end_at' not in params) or (params['account_notification_end_at'] is None):
            raise ValueError("Missing the required parameter `account_notification_end_at` when calling `create_global_notification`")

        resource_path = '/v1/accounts/{account_id}/account_notifications'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'account_notification_subject' in params:
            form_params.append(('account_notification[subject]', params['account_notification_subject']))
        if 'account_notification_message' in params:
            form_params.append(('account_notification[message]', params['account_notification_message']))
        if 'account_notification_start_at' in params:
            form_params.append(('account_notification[start_at]', params['account_notification_start_at']))
        if 'account_notification_end_at' in params:
            form_params.append(('account_notification[end_at]', params['account_notification_end_at']))
        if 'account_notification_icon' in params:
            form_params.append(('account_notification[icon]', params['account_notification_icon']))
        if 'account_notification_roles' in params:
            form_params.append(('account_notification_roles', params['account_notification_roles']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # OPERATIONID: index_of_active_global_notification_for_user
    def index_of_active_global_notification_for_user(self, account_id, user_id, **kwargs):
        """
        Index of active global notification for the user
        Returns a list of all global notifications in the account for this user Any notifications that have been closed by the user will not be returned

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.index_of_active_global_notification_for_user_with_http_info(account_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: ID (required)
        :param str user_id: ID (required)
        :return: list[AccountNotification]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('per_page')
        all_params.append('page')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_of_active_global_notification_for_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `index_of_active_global_notification_for_user`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `index_of_active_global_notification_for_user`")

        resource_path = '/v1/accounts/{account_id}/users/{user_id}/account_notifications'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']

        query_params = {}
        if 'per_page' in params:
            query_params['per_page'] = params['per_page']
        if 'page' in params:
            query_params['page'] = params['page']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['canvas']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[AccountNotification]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
