/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.DataInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.alomax.io.PushbackInputStream;

public class ASCIIInputStream
extends FilterInputStream
implements DataInput {
    public boolean hadEOF = false;
    public char[] lineBuffer;

    public ASCIIInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public boolean bad() {
        return false;
    }

    public boolean hadEof() throws IOException {
        return this.hadEOF;
    }

    public boolean eof() throws IOException {
        if (this.hadEOF) {
            return true;
        }
        int n = this.nextNonWhiteSpaceCharacter();
        if (n == -1) {
            this.hadEOF = true;
            return true;
        }
        this.pushback(n);
        return false;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 < 0) {
            this.hadEOF = true;
        }
        return n3;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        InputStream inputStream = this.in;
        for (int i = 0; i < n2; i += n3) {
            n3 = inputStream.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            this.hadEOF = true;
        }
    }

    public int skipBytes(int n) throws IOException {
        InputStream inputStream = this.in;
        for (int i = 0; i < n; i += (int)inputStream.skip(n - i)) {
        }
        return n;
    }

    public boolean readBoolean() throws IOException {
        String string = this.readWord();
        if (string == null) {
            throw new NumberFormatException("Error in reading boolean: no string input");
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        throw new NumberFormatException("Expected true or false, but got " + string);
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.hadEOF = true;
        }
        return (byte)(n & 0xFF);
    }

    public int readUnsignedByte() throws IOException {
        return this.readChar() & 0xFF;
    }

    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    public int readUnsignedShort() throws IOException {
        return this.readInt() & 0xFFFF;
    }

    public char readChar() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            this.hadEOF = true;
        }
        return (char)n;
    }

    public int readInt() throws IOException {
        return (int)this.readLong();
    }

    public long readLong() throws IOException {
        long l = 0L;
        int n = -1;
        long l2 = 1L;
        int n2 = 0;
        if (this.hadEOF) {
            return 0L;
        }
        n = this.nextNonWhiteSpaceCharacter();
        switch (n) {
            case 45: {
                l2 = -1L;
                n = this.in.read();
                break;
            }
            case 43: {
                n = this.in.read();
                break;
            }
            case -1: {
                this.hadEOF = true;
                return 0L;
            }
        }
        while (n >= 48 && n <= 57) {
            l = l * 10L + (long)(n - 48);
            n = this.in.read();
            ++n2;
        }
        if (n < 0) {
            this.hadEOF = true;
        } else {
            this.pushback(n);
        }
        if (n2 == 0) {
            throw new NumberFormatException("The next token did not start with a digit");
        }
        return l * l2;
    }

    public float readFloat() throws IOException {
        return (float)this.readDouble();
    }

    public double readDouble() throws IOException {
        double d;
        double d2 = 0.0;
        int n = -1;
        int n2 = 1;
        int n3 = 0;
        n = this.nextNonWhiteSpaceCharacter();
        switch (n) {
            case 45: {
                n2 = -1;
                n = this.in.read();
                break;
            }
            case 43: {
                n = this.in.read();
            }
        }
        while (n >= 48 && n <= 57) {
            d2 = d2 * 10.0 + (double)(n - 48);
            n = this.in.read();
            ++n3;
        }
        if (n == 46) {
            d = 0.1;
            n = this.in.read();
            while (n >= 48 && n <= 57) {
                d2 += (double)(n - 48) * d;
                d /= 10.0;
                n = this.in.read();
                ++n3;
            }
        }
        if (n3 == 0) {
            throw new NumberFormatException("Next token does not have valid decimal value. Token read so far: " + d2 * (double)n2);
        }
        if (n == 101 || n == 69) {
            d = 0.0;
            int n4 = 1;
            n3 = 0;
            n = this.in.read();
            switch (n) {
                case 45: {
                    n4 = -1;
                    n = this.in.read();
                    break;
                }
                case 43: {
                    n = this.in.read();
                }
            }
            while (n >= 48 && n <= 57) {
                d = d * 10.0 + (double)(n - 48);
                n = this.in.read();
                ++n3;
            }
            if (d != 0.0) {
                try {
                    d2 *= Math.pow(10.0, d * (double)n4);
                }
                catch (Exception exception) {
                    d2 = 0.0;
                    n2 = 1;
                }
            }
            if (n3 == 0) {
                throw new NumberFormatException("Invalid exponent format for: " + d2 * (double)n2);
            }
        }
        if (n < 0) {
            this.hadEOF = true;
        } else {
            this.pushback(n);
        }
        return d2 * (double)n2;
    }

    public String readLine() throws IOException {
        int n;
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        if (this.hadEOF) {
            return null;
        }
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n2 = cArray.length;
        int n3 = 0;
        block4: while (true) {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10) break block4;
                    this.pushback(n4);
                    break block4;
                }
                default: {
                    if (--n2 < 0) {
                        cArray = new char[n3 + 128];
                        n2 = cArray.length - n3 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n3);
                        this.lineBuffer = cArray;
                    }
                    cArray[n3++] = (char)n;
                    continue block4;
                }
            }
            break;
        }
        if (n == -1 && n3 == 0) {
            this.hadEOF = true;
            return null;
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public String readUTF() throws IOException {
        return "";
    }

    public String readWord() throws IOException {
        InputStream inputStream = this.in;
        char[] cArray = this.lineBuffer;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        if (this.hadEOF) {
            return null;
        }
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        n = cArray.length;
        n3 = this.nextNonWhiteSpaceCharacter();
        while (n3 != 32 && n3 != 9 && n3 != 10 && n3 != 13 && n3 >= 0) {
            if (--n < 0) {
                cArray = new char[n2 + 128];
                n = cArray.length - n2 - 1;
                System.arraycopy(this.lineBuffer, 0, cArray, 0, n2);
                this.lineBuffer = cArray;
            }
            cArray[n2++] = (char)n3;
            n3 = inputStream.read();
        }
        if (n3 == -1 && n2 == 0) {
            this.hadEOF = true;
            return null;
        }
        this.pushback(n3);
        return String.copyValueOf(cArray, 0, n2);
    }

    public void flushLine() throws IOException {
        int n;
        while ((n = this.in.read()) >= 0) {
            if (n == 13) {
                n = this.in.read();
                if (n != 10) {
                    this.pushback(n);
                }
                return;
            }
            if (n != 10) continue;
            return;
        }
        if (n < 0) {
            this.hadEOF = true;
        }
    }

    public void pushback(int n) throws IOException {
        if (!(this.in instanceof PushbackInputStream)) {
            this.in = new PushbackInputStream(this.in);
        }
        ((PushbackInputStream)this.in).unread(n);
    }

    public int nextNonWhiteSpaceCharacter() throws IOException {
        int n;
        while ((n = this.in.read()) == 32 || n == 9 || n == 13 || n == 10) {
        }
        return n;
    }
}

